/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorScope;

public class SwingValidatorMessageWidget
extends JToggleButton {
    private static final Log log = LogFactory.getLog(SwingValidatorMessageWidget.class);
    private static final long serialVersionUID = 1L;
    public static final String CLOSE_DIALOG_ACTION = "closeDialog";
    protected SwingValidatorMessageTableModel errorTableModel = new SwingValidatorMessageTableModel();
    protected JDialog popup = new JDialog();
    protected JTable errorTable = new JTable();
    protected Point popupPosition = null;

    public SwingValidatorMessageWidget() {
        super(SwingUtil.createActionIcon((String)"alert-none"));
        this.setToolTipText(I18n._((String)"validator.messageWidget.alert.none", (Object[])new Object[0]));
        this.errorTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                String icon;
                String label;
                int alerts = SwingValidatorMessageWidget.this.errorTableModel.getRowCount();
                switch (alerts) {
                    case 0: {
                        label = I18n.n_((String)"validator.messageWidget.alert.none", (Object[])new Object[0]);
                        break;
                    }
                    case 1: {
                        label = I18n.n_((String)"validator.messageWidget.alert.one", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        label = I18n.n_((String)"validator.messageWidget.alert.several", (Object[])new Object[0]);
                    }
                }
                if (alerts == 0) {
                    icon = "alert-none";
                } else {
                    NuitonValidatorScope maxScope = NuitonValidatorScope.INFO;
                    for (int i = 0; i < alerts; ++i) {
                        NuitonValidatorScope scope = SwingValidatorMessageWidget.this.errorTableModel.getRow(i).getScope();
                        int diff = scope.compareTo((Enum)maxScope);
                        if (diff >= 0) continue;
                        maxScope = scope;
                    }
                    switch (maxScope) {
                        case INFO: {
                            icon = "alert-info";
                            break;
                        }
                        case WARNING: {
                            icon = "alert-warning";
                            break;
                        }
                        default: {
                            icon = "alert-error";
                        }
                    }
                }
                SwingValidatorMessageWidget.this.setToolTipText(I18n._((String)label, (Object[])new Object[]{alerts}));
                SwingValidatorMessageWidget.this.setIcon(SwingUtil.createActionIcon((String)icon));
            }
        });
        this.errorTable.setModel(this.errorTableModel);
        this.errorTable.setRowSelectionAllowed(true);
        this.errorTable.setAutoCreateRowSorter(true);
        this.errorTable.setAutoResizeMode(2);
        this.errorTable.setCellSelectionEnabled(false);
        this.errorTable.setSelectionMode(0);
        this.errorTable.setFillsViewportHeight(true);
        SwingValidatorUtil.installUI(this.errorTable, new SwingValidatorMessageTableRenderer());
        JScrollPane scrollPanel = new JScrollPane(this.errorTable);
        scrollPanel.setColumnHeaderView(this.errorTable.getTableHeader());
        JXTitledPanel titledPanel = new JXTitledPanel(I18n._((String)"validator.messageWidget.title", (Object[])new Object[0]), (Container)scrollPanel);
        this.popup.add((Component)titledPanel);
        this.popup.setTitle(I18n._((String)"validator.messageWidget.title", (Object[])new Object[0]));
        this.popup.setSize(800, 300);
        this.popup.setAlwaysOnTop(true);
        this.popup.setUndecorated(true);
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{this.popup});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{this.popup});
        this.popup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingValidatorMessageWidget.this.setSelected(false);
            }
        });
        this.popup.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Component component = e.getComponent();
                if (component.isShowing()) {
                    SwingValidatorMessageWidget.this.popupPosition = component.getLocationOnScreen();
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwingValidatorMessageWidget.this.isSelected()) {
                    SwingValidatorMessageWidget.this.popup.setVisible(true);
                } else {
                    SwingValidatorMessageWidget.this.popup.dispose();
                }
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (SwingValidatorMessageWidget.this.popupPosition == null && SwingValidatorMessageWidget.this.isShowing()) {
                    Point point = new Point(SwingValidatorMessageWidget.this.getLocationOnScreen());
                    point.translate(-SwingValidatorMessageWidget.this.popup.getWidth() + SwingValidatorMessageWidget.this.getWidth(), -SwingValidatorMessageWidget.this.popup.getHeight());
                    SwingValidatorMessageWidget.this.popup.setLocation(point);
                }
            }
        });
        JRootPane rootPane = this.popup.getRootPane();
        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(27, 0);
        rootPane.getInputMap(2).put(shortcutClosePopup, CLOSE_DIALOG_ACTION);
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingValidatorMessageWidget.this.popup.dispose();
                SwingValidatorMessageWidget.this.setSelected(false);
            }
        };
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)"close-dialog");
        closeAction.putValue("SmallIcon", actionIcon);
        closeAction.putValue("SwingLargeIconKey", actionIcon);
        closeAction.putValue("ActionCommandKey", "close");
        closeAction.putValue("Name", "close");
        closeAction.putValue("ShortDescription", I18n._((String)"validator.messageWidget.closeDialog.tip", (Object[])new Object[0]));
        rootPane.getActionMap().put(CLOSE_DIALOG_ACTION, closeAction);
        JButton closeButton = new JButton(closeAction);
        closeButton.setText(null);
        closeButton.setFocusPainted(false);
        closeButton.setRequestFocusEnabled(false);
        closeButton.setFocusable(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.add(closeAction);
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        titledPanel.setRightDecoration((JComponent)jToolBar);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.errorTableModel.addTableModelListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.errorTableModel.removeTableModelListener(listener);
    }

    public void registerValidator(SwingValidator validator) {
        this.errorTableModel.registerValidator(validator);
        validator.reloadBean();
    }

    public void clearValidators() {
        this.errorTableModel.clearValidators();
        this.errorTableModel.clear();
    }
}

