/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.translation;

import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.translation.ExpressionException;
import org.andromda.core.translation.TranslationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Expression {
    private StringBuffer translatedExpression;
    private String originalExpression;
    private String contextElement;
    private String kind;
    private String name;

    public Expression(String originalExpression) {
        ExceptionUtils.checkEmpty("originalExpression", originalExpression);
        this.originalExpression = StringUtils.trimToEmpty((String)originalExpression);
        this.translatedExpression = new StringBuffer();
    }

    public void appendToTranslatedExpression(Object object) {
        this.translatedExpression.append(object);
    }

    public void appendSpaceToTranslatedExpression() {
        this.translatedExpression.append(' ');
    }

    public void replaceInTranslatedExpression(String pattern, String replacement) {
        this.translatedExpression = new StringBuffer(this.getTranslatedExpression().replaceAll(pattern, replacement));
    }

    public void insertInTranslatedExpression(int position, Object object) {
        this.translatedExpression.insert(position, object);
    }

    public String getTranslatedExpression() {
        return TranslationUtils.removeExtraWhitespace(this.translatedExpression.toString());
    }

    public String getOriginalExpression() {
        return TranslationUtils.removeExtraWhitespace(this.originalExpression);
    }

    public String getContextElement() {
        String methodName = "Expression.getContextElement";
        if (this.contextElement == null) {
            throw new ExpressionException("Expression.getContextElement - contextElement can not be null");
        }
        return this.contextElement;
    }

    public String getKind() {
        String methodName = "Expression.getKind";
        if (this.contextElement == null) {
            throw new ExpressionException("Expression.getKind - kind can not be null");
        }
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContextElement(String contextElement) {
        this.contextElement = contextElement;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

