/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import com.google.common.collect.Maps;
import fr.ifremer.adagio.core.service.technical.CacheService;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CruisePersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.MarineLitterBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.PlanktonBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ProtocolPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TuttiPersistenceImpl
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(TuttiPersistenceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Autowired
    protected ProgramPersistenceService programService;
    @Autowired
    protected CruisePersistenceService cruiseService;
    @Autowired
    protected FishingOperationPersistenceService fishingOperationService;
    @Autowired
    protected CatchBatchPersistenceService catchBatchService;
    @Autowired
    protected SpeciesBatchPersistenceService speciesBatchService;
    @Autowired
    protected BenthosBatchPersistenceService benthosBatchService;
    @Autowired
    protected PlanktonBatchPersistenceService planktonBatchService;
    @Autowired
    protected MarineLitterBatchPersistenceService marineLitterBatchService;
    @Autowired
    protected AccidentalBatchPersistenceService accidentalBatchService;
    @Autowired
    protected IndividualObservationBatchPersistenceService individualObservationBatchService;
    @Autowired
    protected ProtocolPersistenceService protocolService;
    @Autowired
    protected AttachmentPersistenceService attachmentService;
    @Autowired
    protected CacheService cacheService;

    @Override
    public String getImplementationName() {
        return "Persistence Adagio implementation";
    }

    @Override
    public void clearAllCaches() {
        this.cacheService.clearAllCaches();
    }

    @Override
    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Open persistence driver " + this.getImplementationName()));
        }
        this.referentialService.init();
        this.programService.init();
        this.cruiseService.init();
        this.fishingOperationService.init();
        this.catchBatchService.init();
        this.speciesBatchService.init();
        this.benthosBatchService.init();
        this.planktonBatchService.init();
        this.marineLitterBatchService.init();
        this.accidentalBatchService.init();
        this.individualObservationBatchService.init();
        this.protocolService.init();
        this.attachmentService.init();
    }

    @Override
    public void close() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Close persistence driver " + this.getImplementationName()));
        }
        this.referentialService.close();
        this.programService.close();
        this.cruiseService.close();
        this.fishingOperationService.close();
        this.catchBatchService.close();
        this.speciesBatchService.close();
        this.benthosBatchService.close();
        this.planktonBatchService.close();
        this.marineLitterBatchService.close();
        this.accidentalBatchService.close();
        this.individualObservationBatchService.close();
        this.protocolService.close();
        this.attachmentService.close();
        TuttiPersistenceServiceLocator.close();
    }

    @Override
    public List<TuttiLocation> getAllProgramZone() {
        return this.referentialService.getAllProgramZone();
    }

    @Override
    public List<TuttiLocation> getAllCountry() {
        return this.referentialService.getAllCountry();
    }

    @Override
    public List<TuttiLocation> getAllHarbour() {
        return this.referentialService.getAllHarbour();
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        return this.referentialService.getAllFishingOperationStrata(zoneId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.referentialService.getAllFishingOperationSubStrata(zoneId, strataId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.referentialService.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        return this.referentialService.getAllScientificVessel();
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        return this.referentialService.getAllFishingVessel();
    }

    @Override
    public List<Species> getAllSpecies() {
        return this.referentialService.getAllSpecies();
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        return this.referentialService.getAllReferentSpecies();
    }

    @Override
    public List<Species> getAllSpecies(TuttiProtocol protocol) {
        List<Species> result = this.referentialService.getAllSpecies();
        this.setSpeciesSurveyCode(result, protocol);
        return result;
    }

    @Override
    public List<Species> getAllReferentSpecies(TuttiProtocol protocol) {
        List<Species> result = this.referentialService.getAllReferentSpecies();
        this.setSpeciesSurveyCode(result, protocol);
        return result;
    }

    @Override
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer referenceTaxonId) {
        return this.referentialService.getSpeciesByReferenceTaxonIdWithVernacularCode(referenceTaxonId);
    }

    protected void setSpeciesSurveyCode(List<Species> speciesList, TuttiProtocol protocol) {
        if (protocol != null && !protocol.isSpeciesEmpty()) {
            TreeMap surveyCodeByTaxonId = Maps.newTreeMap();
            for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                String surveyCode = speciesProtocol.getSpeciesSurveyCode();
                if (!StringUtils.isNotBlank((CharSequence)surveyCode)) continue;
                Integer taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                surveyCodeByTaxonId.put(taxonId, surveyCode);
            }
            for (Species species : speciesList) {
                Integer taxonId = species.getReferenceTaxonId();
                String surveyCode = (String)surveyCodeByTaxonId.get(taxonId);
                species.setSurveyCode(surveyCode);
            }
        }
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        return this.referentialService.getAllCaracteristic();
    }

    @Override
    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.referentialService.getAllCaracteristicWithProtected();
    }

    @Override
    public List<Caracteristic> getAllNumericCaracteristic() {
        return this.referentialService.getAllNumericCaracteristic();
    }

    @Override
    public List<ObjectType> getAllObjectType() {
        return this.referentialService.getAllObjectType();
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        return this.referentialService.getSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        return this.referentialService.getSexCaracteristic();
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.referentialService.getSortedUnsortedCaracteristic();
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        return this.referentialService.getMaturityCaracteristic();
    }

    @Override
    public Caracteristic getAgeCaracteristic() {
        return this.referentialService.getAgeCaracteristic();
    }

    @Override
    public Caracteristic getMarineLitterCategoryCaracteristic() {
        return this.referentialService.getMarineLitterCategoryCaracteristic();
    }

    @Override
    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        return this.referentialService.getMarineLitterSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getVerticalOpeningCaracteristic() {
        return this.referentialService.getVerticalOpeningCaracteristic();
    }

    @Override
    public Caracteristic getHorizontalOpeningWingCaracteristic() {
        return this.referentialService.getHorizontalOpeningWingCaracteristic();
    }

    @Override
    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        return this.referentialService.getHorizontalOpeningDoorCaracteristic();
    }

    @Override
    public Caracteristic getDeadOrAliveCaracteristic() {
        return this.referentialService.getDeadOrAliveCaracteristic();
    }

    @Override
    public Caracteristic getSampleIdCaracteristic() {
        return this.referentialService.getSampleIdCaracteristic();
    }

    @Override
    public Caracteristic getOtolitheIdCaracteristic() {
        return this.referentialService.getOtolitheIdCaracteristic();
    }

    @Override
    public Caracteristic getPmfmIdCaracteristic() {
        return this.referentialService.getPmfmIdCaracteristic();
    }

    @Override
    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.referentialService.getWeightMeasuredCaracteristic();
    }

    @Override
    public boolean isTemporary(TuttiReferentialEntity entity) {
        return this.referentialService.isTemporary(entity);
    }

    @Override
    public List<Gear> getAllScientificGear() {
        return this.referentialService.getAllScientificGear();
    }

    @Override
    public List<Gear> getAllFishingGear() {
        return this.referentialService.getAllFishingGear();
    }

    @Override
    public List<Person> getAllPerson() {
        return this.referentialService.getAllPerson();
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        return this.referentialService.getVessel(vesselCode);
    }

    @Override
    public Person getPerson(Integer personId) {
        return this.referentialService.getPerson(personId);
    }

    @Override
    public Gear getGear(Integer gearId) {
        return this.referentialService.getGear(gearId);
    }

    @Override
    public ObjectType getObjectType(String objectTypeCode) {
        return this.referentialService.getObjectType(objectTypeCode);
    }

    @Override
    public List<Species> importTemporarySpecies(List<Species> species) {
        return this.referentialService.importTemporarySpecies(species);
    }

    @Override
    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        return this.referentialService.importTemporaryVessel(vessels);
    }

    @Override
    public List<Person> importTemporaryPerson(List<Person> persons) {
        return this.referentialService.importTemporaryPerson(persons);
    }

    @Override
    public List<Gear> importTemporaryGear(List<Gear> gears) {
        return this.referentialService.importTemporaryGear(gears);
    }

    @Override
    public List<Attachment> getAllAttachments(AttachementObjectTypeEnum objectType, Integer objectId) {
        return this.attachmentService.getAllAttachments(objectType, objectId);
    }

    @Override
    public File getAttachmentFile(String attachmentId) {
        return this.attachmentService.getAttachmentFile(attachmentId);
    }

    @Override
    public Attachment createAttachment(Attachment attachment, File file) {
        return this.attachmentService.createAttachment(attachment, file);
    }

    @Override
    public Attachment saveAttachment(Attachment attachment) {
        return this.attachmentService.saveAttachment(attachment);
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        this.attachmentService.deleteAttachment(attachmentId);
    }

    @Override
    public List<Program> getAllProgram() {
        return this.programService.getAllProgram();
    }

    @Override
    public Program getProgram(String id) {
        return this.programService.getProgram(id);
    }

    @Override
    public Program createProgram(Program bean) {
        return this.programService.createProgram(bean);
    }

    @Override
    public Program saveProgram(Program bean) {
        return this.programService.saveProgram(bean);
    }

    @Override
    public List<Cruise> getAllCruise(String programId) {
        return this.cruiseService.getAllCruise(programId);
    }

    @Override
    public Cruise getCruise(String id) {
        return this.cruiseService.getCruise(id);
    }

    @Override
    public Cruise createCruise(Cruise bean) {
        return this.cruiseService.createCruise(bean);
    }

    @Override
    public Cruise saveCruise(Cruise bean) {
        return this.cruiseService.saveCruise(bean);
    }

    @Override
    public Gear getGearWithCaracteristics(Gear gear, Cruise cruise) {
        return this.cruiseService.getGearWithCaracteristics(gear, cruise);
    }

    @Override
    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        this.cruiseService.saveGearCaracteristics(gear, cruise);
    }

    @Override
    public boolean isProtocolExist(String id) {
        return this.protocolService.isProtocolExist(id);
    }

    @Override
    public List<String> getAllProtocolNames() {
        return this.protocolService.getAllProtocolId();
    }

    @Override
    public List<TuttiProtocol> getAllProtocol() {
        return this.protocolService.getAllProtocol();
    }

    @Override
    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.protocolService.saveProtocol(bean);
    }

    @Override
    public void deleteProtocol(String id) {
        this.protocolService.deleteProtocol(id);
    }

    @Override
    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.protocolService.createProtocol(bean);
    }

    @Override
    public TuttiProtocol getProtocol(String id) {
        return this.protocolService.getProtocol(id);
    }

    @Override
    public int getFishingOperationCount(String cruiseId) {
        return this.fishingOperationService.getFishingOperationCount(cruiseId);
    }

    @Override
    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        return this.fishingOperationService.getAllFishingOperation(cruiseId);
    }

    @Override
    public FishingOperation getFishingOperation(String id) {
        return this.fishingOperationService.getFishingOperation(id);
    }

    @Override
    public FishingOperation createFishingOperation(FishingOperation bean) {
        return this.fishingOperationService.createFishingOperation(bean);
    }

    @Override
    public FishingOperation saveFishingOperation(FishingOperation bean) {
        return this.fishingOperationService.saveFishingOperation(bean);
    }

    @Override
    public void deleteFishingOperation(String id) {
        this.fishingOperationService.deleteFishingOperation(id);
    }

    @Override
    public boolean isFishingOperationWithCatchBatch(String operationId) {
        return this.catchBatchService.isFishingOperationWithCatchBatch(operationId);
    }

    @Override
    public CatchBatch getCatchBatchFromFishingOperation(String id) throws InvalidBatchModelException {
        return this.catchBatchService.getCatchBatchFromFishingOperation(id);
    }

    @Override
    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.catchBatchService.createCatchBatch(bean);
    }

    @Override
    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.catchBatchService.saveCatchBatch(bean);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId) {
        return this.speciesBatchService.getRootSpeciesBatch(fishingOperationId);
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        return this.speciesBatchService.createSpeciesBatch(bean, parentBatchId);
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.speciesBatchService.saveSpeciesBatch(bean);
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        this.speciesBatchService.deleteSpeciesBatch(id);
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        this.speciesBatchService.deleteSpeciesSubBatch(id);
    }

    @Override
    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        this.speciesBatchService.changeSpeciesBatchSpecies(batchId, species);
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        return this.speciesBatchService.getAllSpeciesBatchFrequency(speciesBatchId);
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.speciesBatchService.saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    @Override
    public BatchContainer<BenthosBatch> getRootBenthosBatch(String fishingOperationId) {
        return this.benthosBatchService.getRootBenthosBatch(fishingOperationId);
    }

    @Override
    public BenthosBatch createBenthosBatch(BenthosBatch bean, String parentBatchId) {
        return this.benthosBatchService.createBenthosBatch(bean, parentBatchId);
    }

    @Override
    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        return this.benthosBatchService.saveBenthosBatch(bean);
    }

    @Override
    public void deleteBenthosBatch(String id) {
        this.benthosBatchService.deleteBenthosBatch(id);
    }

    @Override
    public void deleteBenthosSubBatch(String id) {
        this.benthosBatchService.deleteBenthosSubBatch(id);
    }

    @Override
    public void changeBenthosBatchSpecies(String batchId, Species species) {
        this.benthosBatchService.changeBenthosBatchSpecies(batchId, species);
    }

    @Override
    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        return this.benthosBatchService.getAllBenthosBatchFrequency(benthosBatchId);
    }

    @Override
    public List<BenthosBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<BenthosBatchFrequency> frequencies) {
        return this.benthosBatchService.saveBenthosBatchFrequency(benthosBatchId, frequencies);
    }

    @Override
    public List<PlanktonBatch> getAllPlanktonBatch(String fishingOperationId) {
        return this.planktonBatchService.getAllPlanktonBatch(fishingOperationId);
    }

    @Override
    public PlanktonBatch createPlanktonBatch(PlanktonBatch bean) {
        return this.planktonBatchService.createPlanktonBatch(bean);
    }

    @Override
    public PlanktonBatch savePlanktonBatch(PlanktonBatch bean) {
        return this.planktonBatchService.savePlanktonBatch(bean);
    }

    @Override
    public void deletePlanktonBatch(String id) {
        this.planktonBatchService.deletePlanktonBatch(id);
    }

    @Override
    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(String fishingOperationId) {
        return this.marineLitterBatchService.getRootMarineLitterBatch(fishingOperationId);
    }

    @Override
    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch bean) {
        return this.marineLitterBatchService.createMarineLitterBatch(bean);
    }

    @Override
    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch bean) {
        return this.marineLitterBatchService.saveMarineLitterBatch(bean);
    }

    @Override
    public void deleteMarineLitterBatch(String id) {
        this.marineLitterBatchService.deleteMarineLitterBatch(id);
    }

    @Override
    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        return this.accidentalBatchService.getAllAccidentalBatch(fishingOperationId);
    }

    @Override
    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.accidentalBatchService.createAccidentalBatch(bean);
    }

    @Override
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.accidentalBatchService.saveAccidentalBatch(bean);
    }

    @Override
    public void deleteAccidentalBatch(String id) {
        this.accidentalBatchService.deleteAccidentalBatch(id);
    }

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String fishingOperationId) {
        return this.individualObservationBatchService.getAllIndividualObservationBatch(fishingOperationId);
    }

    @Override
    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.individualObservationBatchService.createIndividualObservationBatch(bean);
    }

    @Override
    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.individualObservationBatchService.saveIndividualObservationBatch(bean);
    }

    @Override
    public void deleteIndividualObservationBatch(String id) {
        this.individualObservationBatchService.deleteIndividualObservationBatch(id);
    }
}

