/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.util.decorator.Decorator;

public abstract class AbstractTuttiAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractBean {
    public static final String PROPERTY_DONE = "done";
    protected final H handler;
    protected String actionDescription;
    protected final boolean hideBody;
    protected final Object lock = new Object();

    protected abstract void doAction() throws Exception;

    protected AbstractTuttiAction(H handler, boolean hideBody) {
        this.handler = handler;
        this.hideBody = hideBody;
    }

    protected boolean prepareAction() throws Exception {
        return true;
    }

    protected void releaseAction() {
        this.firePropertyChange(PROPERTY_DONE, null, true);
    }

    public void postSuccessAction() {
    }

    public void postFailedAction(Throwable error) {
    }

    public H getHandler() {
        return this.handler;
    }

    public M getModel() {
        return (M)((AbstractBean)((AbstractTuttiUIHandler)this.handler).getModel());
    }

    public final UI getUI() {
        return ((AbstractTuttiUIHandler)this.handler).getUI();
    }

    public TuttiUIContext getContext() {
        return ((AbstractTuttiUIHandler)this.handler).getContext();
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public void setActionDescription(String actionDescription) {
        this.actionDescription = actionDescription;
    }

    protected void setProgressionModel(ProgressionModel progressionModel) {
        this.getContext().getActionUI().getModel().setProgressionModel(progressionModel);
    }

    protected ProgressionModel getProgressionModel() {
        return this.getContext().getActionUI().getModel().getProgressionModel();
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    protected TuttiApplicationConfig getConfig() {
        return this.getContext().getConfig();
    }

    protected void sendMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    protected <O> Decorator<O> getDecorator(Class<O> type, String name) {
        Decorator<O> decorator = ((AbstractTuttiUIHandler)this.handler).getDecorator(type, name);
        Preconditions.checkNotNull(decorator);
        return decorator;
    }

    protected String decorate(Object object) {
        return this.getDecorator(object.getClass(), null).toString(object);
    }

    protected String decorate(Object object, String context) {
        return this.getDecorator(object.getClass(), context).toString(object);
    }
}

