package fr.ifremer.tutti.ui.swing.util.caracteristics;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class CaracteristicMapEditorUI extends Table implements TuttiUI<CaracteristicMapEditorUIModel, CaracteristicMapEditorUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ROW_ENABLED = "addRow.enabled";
    public static final String BINDING_NEW_ROW_KEY_ENABLED = "newRowKey.enabled";
    public static final String BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED = "removeCaracteristicMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WTW8bRRieuLFT5wNKoqat2qIkpKg9sC4SSEBa2tq1iRPng9hIET6U8e7EnnQ8M8zOJmtZRfwCxE+AOxckbpwQB84cuCD+AkIcuCLe2bW9XmfThCSRMkpm5n3eZ5533mf2uz9R2lVocR/7vqU8rmmbWGtPdne3GvvE1k+JaysqtVAo/BlLoVQdTTmDeVejN+oVE57rhecKoi0FJ3woeqWCJl3dYcRtEaI1uh2PsF03Vx0sr/jSU33UAakk1G/+/iv1tfPltymEfAnspuEoCydFRScZr6AUdTSahUwHOMcwbwINRXkT+M6YuQLDrruJ2+Rz9AWaqKCMxArANFo6/ZEDjCDelxpNLNdwg5H7GpX2lEX3FGkTZWlPa2p51HIPIbvlacosGytsa6Koq6ntWoXhfzewLDoUsnxSljIAzwB0C3OHEaXRxsVAr4Z4UYZ0WziEabR+MfgbBi1Cn9RGmW0hPdBp3sjv90DXgskNwr1o9zVILw5IHBt2aHQ1Fmrmypq0TdjsIDrLyeGOOFwnHY3ejd2YMIwEFK0GwdzKw1CiDJIYflDqhsgL3wBlB3gZ7DiAp9FcLHkexBE8vnVmea1qK8HYNubmHlyLRURL8aibdqKIwWWCVaGa1j505XMtZAjlW2u7waoBeH2Ac3l5zYAzSDwbl9jMxnNO25jbhEWHuG2G5ahgLj4gR1cVuhlTFLrbiro7ar+xOkorD6Y1ul4/agg7sBRawfURKzCAweq/83O//fjHD6V+/2ch99XErUP2BX0plZDQJ9SkfjVsfnNvcyDrSh1QCAPvC7ztVgKxam8ZyEG+10x4eO1XsdsCiPTE7z/9PP/Zr5dQqoQmmcBOCZv9ZZTVLQUqCOb48tHjgNH04WUYr8BvCgSlb7/HtxXZoz4QCzurx7VjwaWF0MMd4hoHHdfKIz6IcytBnAHDRvaXf+aq3z/uCzQGhG8cuz0SKf0pylDOKCeBRfbcL9ESp6RLPEdELpfke8h0dHIf9Tr6fjC+k6TKBOEmAIx6vrs46FuLusW21J27917Are6rBN0fVo84MWfwPQP/QSCB+esBGvYA+X9I3OlGHJpEV3vpjMfcvbew+HCBe4wBp0nITgUv24JrdAn8IYlDzzdOIjAOthGeCxCNbRoaFThZdXiSWdXy5keV4rNqsVIs1Mpbm0YaVygdukR6DzO4PGhuAFUSijSV8Dica6ZbEAw8L195Ulh/Mbwrj+3n/V2ZbnC8pLO8zKJOOmB6WOE3u8E7AxXeOerxxXBXUPZxTXzohdWwU4xnl7lDD6jjYbbVcIk6wIZ/If4chXWxEt6PkaJNN7C2W28BFaJBtmnTnRscwrjZ+vFFZbXaA8wpLQSrUVkLzlW5sAyayqSKHfeGnqJaPelXzkQxfFdG1M70Z0d0fnqOFMdK++g8oKAmNNOzFny8AL3u0nmwDMhSYjvFXt/TV+T9M7ExL/lIPcbDuZFq5M8Mf2wtHp4dMlaJ/BkrESAdX4ehr5yTqjAGdms+GWsdCcq98sDBGi80KFDhzQ+PYI+Z8cYpMDMMd4SnzfpXySh3AOU/qynx7ssNAAA=";
    private static final Log log = LogFactory.getLog(CaracteristicMapEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRow;
    protected JButton cancelButton;
    protected JXTable caracteristicMapEditorTable;
    protected CaracteristicMapEditorUIHandler handler;
    protected CaracteristicMapEditorUIModel model;
    protected BeanFilterableComboBox<Caracteristic> newRowKey;
    protected JMenuItem removeCaracteristicMenu;
    protected JButton saveButton;
    protected JPopupMenu tablePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private CaracteristicMapEditorUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CaracteristicMapEditorUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CaracteristicMapEditorUIHandler handler = new CaracteristicMapEditorUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CaracteristicMapEditorUI() {
        $initialize();
    }

    public CaracteristicMapEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addRow(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addRow();
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__removeCaracteristicMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeCaracteristic();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doKeyPressed__on__caracteristicMapEditorTable(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__caracteristicMapEditorTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRow() {
        return addRow;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JXTable getCaracteristicMapEditorTable() {
        return caracteristicMapEditorTable;
    }

    public CaracteristicMapEditorUIHandler getHandler() {
        return handler;
    }

    public CaracteristicMapEditorUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<Caracteristic> getNewRowKey() {
        return newRowKey;
    }

    public JMenuItem getRemoveCaracteristicMenu() {
        return removeCaracteristicMenu;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeCaracteristicMenu);
    }

    protected void createAddRow() {
        $objectMap.put("addRow", addRow = new JButton());
        
        addRow.setName("addRow");
        addRow.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addRow"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.editIndividualObservationCaracteristics.action.cancel"));
        cancelButton.setToolTipText(_("tutti.editIndividualObservationCaracteristics.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.editIndividualObservationCaracteristics.action.cancel.help");
    }

    protected void createCaracteristicMapEditorTable() {
        $objectMap.put("caracteristicMapEditorTable", caracteristicMapEditorTable = new JXTable());
        
        caracteristicMapEditorTable.setName("caracteristicMapEditorTable");
        caracteristicMapEditorTable.setSortable(false);
        caracteristicMapEditorTable.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__caracteristicMapEditorTable"));
        caracteristicMapEditorTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__caracteristicMapEditorTable"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CaracteristicMapEditorUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CaracteristicMapEditorUIModel.class));
    }

    protected void createNewRowKey() {
        $objectMap.put("newRowKey", newRowKey = new BeanFilterableComboBox<Caracteristic>(this));
        
        newRowKey.setName("newRowKey");
        newRowKey.setI18nPrefix("tutti.property.");
        newRowKey.setProperty("selectedCaracteristic");
        newRowKey.setShowReset(true);
    }

    protected void createRemoveCaracteristicMenu() {
        $objectMap.put("removeCaracteristicMenu", removeCaracteristicMenu = new JMenuItem());
        
        removeCaracteristicMenu.setName("removeCaracteristicMenu");
        removeCaracteristicMenu.setText(_("tutti.editIndividualObservationCaracteristics.action.removeCaracteristic"));
        removeCaracteristicMenu.setToolTipText(_("tutti.editIndividualObservationCaracteristics.action.removeCaracteristic.tip"));
        removeCaracteristicMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeCaracteristicMenu"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editIndividualObservationCaracteristics.action.save"));
        saveButton.setToolTipText(_("tutti.editIndividualObservationCaracteristics.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.editIndividualObservationCaracteristics.action.save.help");
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(newRowKey, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addRow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTablePopup();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(caracteristicMapEditorTable);
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        newRowKey.setBeanType(Caracteristic.class);
        removeCaracteristicMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeCaracteristicMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editIndividualObservationCaracteristics.action.removeCaracteristic.mnemonic"),'Z'));
        addRow.setIcon(SwingUtil.createActionIcon("add"));
        caracteristicMapEditorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        caracteristicMapEditorTable.setSelectionForeground(Color.BLACK);
        caracteristicMapEditorTable.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editIndividualObservationCaracteristics.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editIndividualObservationCaracteristics.action.save.mnemonic"),'Z'));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createModel();
        createTablePopup();
        createRemoveCaracteristicMenu();
        createNewRowKey();
        createAddRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createCaracteristicMapEditorTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeCaracteristicMenu.setEnabled(model.isRemoveCaracteristicEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_ROW_KEY_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    newRowKey.setEnabled(!newRowKey.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    addRow.setEnabled(newRowKey.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

}