package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiUI.java 970 2013-05-21 14:44:45Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/TuttiUI.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.JAXXObject;

import javax.swing.UIManager;
import java.awt.Font;

/**
 * Contract to place on each generated jaxx ui.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public interface TuttiUI<M, H extends AbstractTuttiUIHandler<M, ?>> extends JAXXObject {

    M getModel();

    H getHandler();

    /**
     * Pattern to use for short numeric values in editors with max 1 digits.
     *
     * @since 0.2
     */
    public static final String INT_1_DIGITS_PATTERN = "\\d{0,1}";

    /**
     * Pattern to use for short numeric values in editors with max 2 digits.
     *
     * @since 0.1
     */
    public static final String INT_2_DIGITS_PATTERN = "\\d{0,2}";

    /**
     * Pattern to use for signed numeric values in editors with max 2 digits.
     *
     * @since 1.0
     */
    public static final String SIGNED_INT_2_DIGITS_PATTERN = "-?\\d{0,2}";

    /**
     * Pattern to use for short numeric values in editors with max 3 digits.
     *
     * @since 0.1
     */
    public static final String INT_3_DIGITS_PATTERN = "\\d{0,3}";

    /**
     * Pattern to use for singed numeric values in editors with max 3 digits.
     *
     * @since 1.0
     */
    public static final String SIGNED_INT_3_DIGITS_PATTERN = "-?\\d{0,3}";

    /**
     * Pattern to use for short numeric values in editors with max 4 digits.
     *
     * @since 0.2
     */
    public static final String INT_4_DIGITS_PATTERN = "\\d{0,4}";

    /**
     * Pattern to use for integer numeric values in editors with max 6 digits.
     *
     * @since 0.1
     */
    public static final String INT_6_DIGITS_PATTERN = "\\d{0,6}";

    /**
     * Pattern to use for integer numeric values in editors with max 7 digits.
     *
     * @since 0.1
     */
    public static final String INT_7_DIGITS_PATTERN = "\\d{0,7}";

    /**
     * Pattern to use for decimal numeric values with 1 decimal digits in
     * editors.
     *
     * @since 0.1
     */
    public static final String DECIMAL1_PATTERN = "\\d{0,6}(\\.\\d{0,1})?";

    /**
     * Pattern to use for decimal numeric values with 2 decimal digits in
     * editors.
     *
     * @since 0.1
     */
    public static final String DECIMAL2_PATTERN = "\\d{0,6}(\\.\\d{0,2})?";

    /**
     * Pattern to use for decimal numeric values with 3 decimal digits in
     * editors.
     *
     * @since 0.1
     */
    public static final String DECIMAL3_PATTERN = "\\d{0,6}(\\.\\d{0,3})?";

    /**
     * Pattern to use for decimal numeric values with 2 digits + 3 decimal digits in
     * editors.
     *
     * @since 1.0
     */
    public static final String DECIMAL2_DIGITS_PATTERN = "\\d{0,2}(\\.\\d*)?";

    public static final Font TEXTFIELD_NORMAL_FONT = UIManager.getDefaults().getFont("TextField.font");

    public static final Font TEXTFIELD_COMPUTED_FONT = UIManager.getDefaults().getFont("TextField.font").deriveFont(Font.ITALIC);
}
