package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolUIModel.java 1087 2013-06-10 08:46:40Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/EditProtocolUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditProtocolUIModel extends AbstractTuttiBeanUIModel<TuttiProtocol, EditProtocolUIModel> implements TuttiProtocol {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SPECIES_ROW = "speciesRow";

    public static final String PROPERTY_BENTHOS_ROW = "benthosRow";

    public static final String PROPERTY_REMOVE_SPECIES_ENABLED = "removeSpeciesEnabled";

    public static final String PROPERTY_REMOVE_BENTHOS_ENABLED = "removeBenthosEnabled";

    public static final String PROPERTY_IMPORTED = "imported";

    public static final String PROPERTY_CLONED = "cloned";

    /**
     * Delegate edit object.
     *
     * @since 1.3
     */
    protected final TuttiProtocol editObject = TuttiBeanFactory.newTuttiProtocol();

    /**
     * Flag when a incoming protocol is imported.
     *
     * @since 1.0
     */
    protected boolean imported;

    /**
     * Flag when a incoming protocol is cloned.
     *
     * @since 1.0
     */
    protected boolean cloned;

    /**
     * Can user remove a selected species?
     *
     * @since 0.3
     */
    protected boolean removeSpeciesEnabled;

    /**
     * Can user remove a selected benthos?
     *
     * @since 0.3
     */
    protected boolean removeBenthosEnabled;

    protected List<Species> allSpecies;

    protected List<Species> allSynonyms;

    protected Multimap<String, Species> allSpeciesByTaxonId;

    protected Map<String, Species> allReferentSpeciesByTaxonId;

    protected List<Caracteristic> caracteristics;

    protected Map<String, Caracteristic> allCaracteristic;

    protected List<EditProtocolSpeciesRowModel> speciesRow;

    protected List<EditProtocolSpeciesRowModel> benthosRow;

    protected static Binder<EditProtocolUIModel, TuttiProtocol> toBeanBinder =
            BinderFactory.newBinder(EditProtocolUIModel.class,
                                    TuttiProtocol.class);

    protected static Binder<TuttiProtocol, EditProtocolUIModel> fromBeanBinder =
            BinderFactory.newBinder(TuttiProtocol.class, EditProtocolUIModel.class);

    public EditProtocolUIModel() {
        super(TuttiProtocol.class, fromBeanBinder, toBeanBinder);
    }

    @Override
    protected TuttiProtocol newEntity() {
        return TuttiBeanFactory.newTuttiProtocol();
    }

    public void setLengthClassesPmfm(List<Caracteristic> lengthClassesPmfm) {
        List<String> ids = TuttiEntities.collecIds(lengthClassesPmfm);
        setLengthClassesPmfmId(ids);
    }

    public void setGearUseFeaturePmfm(List<Caracteristic> gearUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(gearUseFeaturePmfm);
        setGearUseFeaturePmfmId(ids);
    }

    public void setVesselUseFeaturePmfm(List<Caracteristic> vesselUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(vesselUseFeaturePmfm);
        setVesselUseFeaturePmfmId(ids);
    }

    public List<EditProtocolSpeciesRowModel> getSpeciesRow() {
        return speciesRow;
    }

    public void setSpeciesRow(List<EditProtocolSpeciesRowModel> speciesRow) {
        Object oldValue = getSpeciesRow();
        this.speciesRow = speciesRow;
        firePropertyChange(PROPERTY_SPECIES_ROW, oldValue, speciesRow);
    }

    public List<EditProtocolSpeciesRowModel> getBenthosRow() {
        return benthosRow;
    }

    public void setBenthosRow(List<EditProtocolSpeciesRowModel> benthosRow) {
        Object oldValue = getBenthosRow();
        this.benthosRow = benthosRow;
        firePropertyChange(PROPERTY_BENTHOS_ROW, oldValue, benthosRow);
    }

    public boolean isRemoveSpeciesEnabled() {
        return removeSpeciesEnabled;
    }

    public void setRemoveSpeciesEnabled(boolean removeSpeciesEnabled) {
        Object oldValue = isRemoveSpeciesEnabled();
        this.removeSpeciesEnabled = removeSpeciesEnabled;
        firePropertyChange(PROPERTY_REMOVE_SPECIES_ENABLED, oldValue, removeSpeciesEnabled);
    }

    public boolean isRemoveBenthosEnabled() {
        return removeBenthosEnabled;
    }

    public void setRemoveBenthosEnabled(boolean removeBenthosEnabled) {
        Object oldValue = isRemoveBenthosEnabled();
        this.removeBenthosEnabled = removeBenthosEnabled;
        firePropertyChange(PROPERTY_REMOVE_BENTHOS_ENABLED, oldValue, removeBenthosEnabled);
    }

    public boolean isImported() {
        return imported;
    }

    public void setImported(boolean imported) {
        Object oldValue = isImported();
        this.imported = imported;
        firePropertyChange(PROPERTY_IMPORTED, oldValue, imported);
    }

    public boolean isCloned() {
        return cloned;
    }

    public void setCloned(boolean cloned) {
        Object oldValue = isCloned();
        this.cloned = cloned;
        firePropertyChange(PROPERTY_CLONED, oldValue, cloned);
    }

    public List<Species> getAllSpecies() {
        return allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        this.allSpecies = allSpecies;
        if (allReferentSpeciesByTaxonId != null && allSpecies != null) {
            allSynonyms = Lists.newArrayList(allSpecies);
            allSynonyms.removeAll(allReferentSpeciesByTaxonId.values());
        }
    }

    public Multimap<String, Species> getAllSpeciesByTaxonId() {
        return allSpeciesByTaxonId;
    }

    public Collection<Species> getAllSynonyms(String taxonId) {
        return allSpeciesByTaxonId.get(taxonId);
    }

    public void setAllSpeciesByTaxonId(Multimap<String, Species> allSpeciesByTaxonId) {
        this.allSpeciesByTaxonId = allSpeciesByTaxonId;
    }

    public List<Species> getAllSynonyms() {
        return allSynonyms;
    }

    public Map<String, Species> getAllReferentSpeciesByTaxonId() {
        return allReferentSpeciesByTaxonId;
    }

    public void setAllReferentSpeciesByTaxonId(Map<String, Species> allReferentSpeciesByTaxonId) {
        this.allReferentSpeciesByTaxonId = allReferentSpeciesByTaxonId;
        if (allReferentSpeciesByTaxonId != null && allSpecies != null) {
            allSynonyms = Lists.newArrayList(allSpecies);
            allSynonyms.removeAll(allReferentSpeciesByTaxonId.values());
        }
    }

    public List<Caracteristic> getCaracteristics() {
        return caracteristics;
    }

    public void setCaracteristics(List<Caracteristic> caracteristics) {
        this.caracteristics = caracteristics;
    }

    public Map<String, Caracteristic> getAllCaracteristic() {
        return allCaracteristic;
    }

    public void setAllCaracteristic(Map<String, Caracteristic> allCaracteristic) {
        this.allCaracteristic = allCaracteristic;
    }

    //------------------------------------------------------------------------//
    //-- TuttiProtocol methods                                              --//
    //------------------------------------------------------------------------//

    @Override
    public String getName() {
        return editObject.getName();
    }

    @Override
    public void setName(String name) {
        Object oldValue = getName();
        editObject.setName(name);
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getComment() {
        return editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        Object oldValue = getComment();
        editObject.setComment(comment);
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public List<String> getLengthClassesPmfmId() {
        return editObject.getLengthClassesPmfmId();
    }

    @Override
    public void setLengthClassesPmfmId(List<String> lengthClassesPmfmId) {
        editObject.setLengthClassesPmfmId(lengthClassesPmfmId);
        // force to always propagates (need to recompte data of combobox in species table)
        firePropertyChange(PROPERTY_LENGTH_CLASSES_PMFM_ID, null, lengthClassesPmfmId);
    }

    @Override
    public List<String> getGearUseFeaturePmfmId() {
        return editObject.getGearUseFeaturePmfmId();
    }

    @Override
    public void setGearUseFeaturePmfmId(List<String> gearUseFeaturePmfmId) {
        Object oldValue = getGearUseFeaturePmfmId();
        editObject.setGearUseFeaturePmfmId(gearUseFeaturePmfmId);
        firePropertyChange(PROPERTY_GEAR_USE_FEATURE_PMFM_ID, null, gearUseFeaturePmfmId);
    }

    @Override
    public List<String> getVesselUseFeaturePmfmId() {
        return editObject.getVesselUseFeaturePmfmId();
    }

    @Override
    public void setVesselUseFeaturePmfmId(List<String> vesselUseFeaturePmfmId) {
        Object oldValue = getVesselUseFeaturePmfmId();
        editObject.setVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
        firePropertyChange(PROPERTY_VESSEL_USE_FEATURE_PMFM_ID, null, vesselUseFeaturePmfmId);
    }

    @Override
    public String getGearUseFeaturePmfmId(int index) {
        return null;
    }

    @Override
    public boolean isGearUseFeaturePmfmIdEmpty() {
        return false;
    }

    @Override
    public int sizeGearUseFeaturePmfmId() {
        return 0;
    }

    @Override
    public void addGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
    }

    @Override
    public void addAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
    }

    @Override
    public boolean removeGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
        return false;
    }

    @Override
    public boolean removeAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
        return false;
    }

    @Override
    public boolean containsGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
        return false;
    }

    @Override
    public boolean containsAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
        return false;
    }

    @Override
    public String getVesselUseFeaturePmfmId(int index) {
        return null;
    }

    @Override
    public boolean isVesselUseFeaturePmfmIdEmpty() {
        return false;
    }

    @Override
    public int sizeVesselUseFeaturePmfmId() {
        return 0;
    }

    @Override
    public void addVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
    }

    @Override
    public void addAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
    }

    @Override
    public boolean removeVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
        return false;
    }

    @Override
    public boolean removeAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
        return false;
    }

    @Override
    public boolean containsVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
        return false;
    }

    @Override
    public boolean containsAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
        return false;
    }

    @Override
    public String getLengthClassesPmfmId(int index) {
        return null;
    }

    @Override
    public boolean isLengthClassesPmfmIdEmpty() {
        return false;
    }

    @Override
    public int sizeLengthClassesPmfmId() {
        return 0;
    }

    @Override
    public void addLengthClassesPmfmId(String lengthClassesPmfmId) {
    }

    @Override
    public void addAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
    }

    @Override
    public boolean removeLengthClassesPmfmId(String lengthClassesPmfmId) {
        return false;
    }

    @Override
    public boolean removeAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        return false;
    }

    @Override
    public boolean containsLengthClassesPmfmId(String lengthClassesPmfmId) {
        return false;
    }

    @Override
    public boolean containsAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        return false;
    }

    @Override
    public SpeciesProtocol getSpecies(int index) {
        return null;
    }

    @Override
    public boolean isSpeciesEmpty() {
        return false;
    }

    @Override
    public int sizeSpecies() {
        return 0;
    }

    @Override
    public void addSpecies(SpeciesProtocol species) {
    }

    @Override
    public void addAllSpecies(Collection<SpeciesProtocol> species) {
    }

    @Override
    public boolean removeSpecies(SpeciesProtocol species) {
        return false;
    }

    @Override
    public boolean removeAllSpecies(Collection<SpeciesProtocol> species) {
        return false;
    }

    @Override
    public boolean containsSpecies(SpeciesProtocol species) {
        return false;
    }

    @Override
    public boolean containsAllSpecies(Collection<SpeciesProtocol> species) {
        return false;
    }

    @Override
    public List<SpeciesProtocol> getSpecies() {
        return null;
    }

    @Override
    public void setSpecies(List<SpeciesProtocol> species) {
    }

    @Override
    public SpeciesProtocol getBenthos(int index) {
        return null;
    }

    @Override
    public boolean isBenthosEmpty() {
        return false;
    }

    @Override
    public int sizeBenthos() {
        return 0;
    }

    @Override
    public void addBenthos(SpeciesProtocol benthos) {
    }

    @Override
    public void addAllBenthos(Collection<SpeciesProtocol> benthos) {
    }

    @Override
    public boolean removeBenthos(SpeciesProtocol benthos) {
        return false;
    }

    @Override
    public boolean removeAllBenthos(Collection<SpeciesProtocol> benthos) {
        return false;
    }

    @Override
    public boolean containsBenthos(SpeciesProtocol benthos) {
        return false;
    }

    @Override
    public boolean containsAllBenthos(Collection<SpeciesProtocol> benthos) {
        return false;
    }

    @Override
    public List<SpeciesProtocol> getBenthos() {
        return null;
    }

    @Override
    public void setBenthos(List<SpeciesProtocol> benthos) {
    }
}