package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: SendCruiseReportAction.java 1005 2013-05-24 13:20:36Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/SendCruiseReportAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.catches.ExportCatchesReportService;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Opens a file chooser, exports the cruise catches into the selected file and open the default email editor.
 *
 * @author kmorin <morin@codelutin.com>
 * @since 1.0
 */
public class SendCruiseReportAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(SendCruiseReportAction.class);

    protected File file;

    public SendCruiseReportAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            Cruise cruise = getModel().getCruise();
            // choose file to export
            file = TuttiUIUtil.saveFile(
                    "exportCruise-" + cruise.getName() + ".pdf",
                    getContext().getMainUI(),
                    _("tutti.sendCruiseReport.title.choose.exportFile"),
                    _("tutti.sendCruiseReport.action.chooseFile"),
                    "^.+\\.pdf$", _("tutti.common.file.pdf")
            );
            doAction = file != null;
            if (doAction) {
                file = TuttiIOUtil.addExtensionIfMissing(file, ".pdf");

                // ask user to confirm overwrite.
                doAction = getHandler().askOverwriteFile(file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Cruise cruise = getModel().getCruise();
        Preconditions.checkNotNull(cruise);
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will export cruise " + cruise.getId() +
                     " to file: " + file);
        }

        // export catches
        ExportCatchesReportService service =
                getContext().getGeneratePDFService();
        service.generatePDFFile(file, cruise.getId(), getConfig().getI18nLocale());

        try  {
            throw new TuttiTechnicalException();
//            TuttiUIUtil.mail(_("tutti.sendCruiseReport.mail.subject", cruise.getName()),
//                             _("tutti.sendCruiseReport.mail.body", cruise.getName(), file.getAbsolutePath()));

        } catch (TuttiTechnicalException e) {
            JOptionPane.showMessageDialog(getContext().getMainUI(),
                                          _("tutti.sendCruiseReport.action.error.mail.message", file),
                                          _("tutti.sendCruiseReport.action.error.mail.title"),
                                          JOptionPane.WARNING_MESSAGE);
        }

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(_("tutti.sendCruiseReport.action.success", file));
    }
}
