/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.Collection;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.nuiton.i18n.I18n;

public class AddBenthosProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    protected Species species;

    public AddBenthosProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        this.species = null;
        EditProtocolUI ui = (EditProtocolUI)this.getUI();
        EditProtocolSpeciesTableModel tableModel = ((EditProtocolUIHandler)this.handler).getBenthosTableModel();
        BeanFilterableComboBox<Species> benthosComboBox = ui.getBenthosComboBox();
        this.species = (Species)benthosComboBox.getSelectedItem();
        Preconditions.checkNotNull((Object)this.species, (Object)"Can't add a benthosProtocol with a null species");
        Preconditions.checkArgument((boolean)this.species.isReferenceTaxon(), (Object)"Can't add a benthosProtocol with a not referent species");
        Integer taxonId = this.species.getReferenceTaxonId();
        String taxonIdStr = String.valueOf(taxonId);
        Collection<Species> allSynonyms = ((EditProtocolUIModel)this.getModel()).getAllSynonyms(taxonIdStr);
        ((EditProtocolUIModel)this.getModel()).getAllSynonyms().removeAll(allSynonyms);
        benthosComboBox.removeItem((Object)this.species);
        ui.getSpeciesComboBox().removeItem((Object)this.species);
        EditProtocolSpeciesRowModel protocol = tableModel.createNewRow();
        protocol.setSpecies(this.species);
        tableModel.addNewRow(protocol);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        String speciesStr = this.decorate(this.species);
        this.sendMessage(I18n._((String)"tutti.flash.info.benthos.add.to.protocol", (Object[])new Object[]{speciesStr}));
    }
}

