package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportMultiPostAction.java 1004 2013-05-24 12:54:22Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/accidental/ExportMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractExportMultiPostAction;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ExportMultiPostAction
        extends AbstractExportMultiPostAction<AccidentalBatchUIModel, AccidentalBatchUI, AccidentalBatchUIHandler> {

    public ExportMultiPostAction(AccidentalBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiAccidental";
    }

    @Override
    protected String getFileExtensionDescription() {
        return _("tutti.common.file.tuttiAccidental");
    }

    @Override
    protected String getFileChooserTitle() {
        return _("tutti.editAccidentalBatch.action.exportMultiPost.destinationFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return _("tutti.editAccidentalBatch.action.exportMultiPost.destinationFile.button");
    }

    @Override
    protected void doAction() throws Exception {
        multiPostImportExportService.exportAccidentalCatch(file, currentOperation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(_("tutti.editAccidentalBatch.action.exportMultiPost.success", file));
    }
}
