package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractImportMultiPostAction.java 1053 2013-05-30 15:41:32Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/AbstractImportMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.TuttiMultiPostImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import org.jdesktop.beans.AbstractBean;

import java.io.File;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public abstract class AbstractImportMultiPostAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
        extends AbstractTuttiAction<M, UI, H> {

    protected File file;

    protected EditFishingOperationAction editAction;

    protected TuttiMultiPostImportExportService multiPostImportExportService;

    public AbstractImportMultiPostAction(H handler) {
        super(handler, false);
        multiPostImportExportService = getContext().getMultiPostImportExportService();
    }

    public EditFishingOperationAction getEditAction() {
        FishingOperationsUI parentUI = getUI().getParentContainer(FishingOperationsUI.class);
        if (editAction == null) {
            editAction = TuttiActionHelper.createLogicAction(parentUI.getHandler(),
                                                             EditFishingOperationAction.class);
        }
        return editAction;
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to import
            file = TuttiUIUtil.chooseFile(
                    getContext().getMainUI(),
                    getFileChooserTitle(),
                    getFileChooserButton(),
                    "^.*\\." + getFileExtension(),
                    getFileExtensionDescription()
            );
            doAction = file != null;
        }
        return doAction;
    }

    protected abstract String getFileExtension();

    protected abstract String getFileExtensionDescription();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserButton();

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        EditCatchesUI editCatchesUI = getUI().getParentContainer(EditCatchesUI.class);
        EditCatchesUIModel editCatchesUIModel = editCatchesUI.getModel();

        FishingOperation operation = editCatchesUIModel.getFishingOperation();

        importBatches(operation);

        getEditAction().loadCatchBatch(operation, true);
    }

    protected abstract void importBatches(FishingOperation operation);

}
