/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.transshipment;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.transshipment.TransshipmentImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class Transshipment
implements Serializable {
    private static final long serialVersionUID = -3685829031633801774L;
    private Integer id;
    private Date transshipmentDateTime;
    private Short rankOrder;
    private String comments;
    private Date creationDate;
    private Date controlDate;
    private Date qualificationDate;
    private String qualificationComments;
    private Timestamp updateDate;
    private Location transshipmentLocation;
    private Vessel toVessel;
    private FishingTrip fishingTrip;
    private Program program;
    private Person recorderPerson;
    private QualityFlag qualityFlag;
    private Department recorderDepartment;
    private Vessel fromVessel;
    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();
    private Collection<Produce> produces = new HashSet<Produce>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getTransshipmentDateTime() {
        return this.transshipmentDateTime;
    }

    public void setTransshipmentDateTime(Date transshipmentDateTime) {
        this.transshipmentDateTime = transshipmentDateTime;
    }

    public Short getRankOrder() {
        return this.rankOrder;
    }

    public void setRankOrder(Short rankOrder) {
        this.rankOrder = rankOrder;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getControlDate() {
        return this.controlDate;
    }

    public void setControlDate(Date controlDate) {
        this.controlDate = controlDate;
    }

    public Date getQualificationDate() {
        return this.qualificationDate;
    }

    public void setQualificationDate(Date qualificationDate) {
        this.qualificationDate = qualificationDate;
    }

    public String getQualificationComments() {
        return this.qualificationComments;
    }

    public void setQualificationComments(String qualificationComments) {
        this.qualificationComments = qualificationComments;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public Location getTransshipmentLocation() {
        return this.transshipmentLocation;
    }

    public void setTransshipmentLocation(Location transshipmentLocation) {
        this.transshipmentLocation = transshipmentLocation;
    }

    public Vessel getToVessel() {
        return this.toVessel;
    }

    public void setToVessel(Vessel toVessel) {
        this.toVessel = toVessel;
    }

    public FishingTrip getFishingTrip() {
        return this.fishingTrip;
    }

    public void setFishingTrip(FishingTrip fishingTrip) {
        this.fishingTrip = fishingTrip;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Person getRecorderPerson() {
        return this.recorderPerson;
    }

    public void setRecorderPerson(Person recorderPerson) {
        this.recorderPerson = recorderPerson;
    }

    public QualityFlag getQualityFlag() {
        return this.qualityFlag;
    }

    public void setQualityFlag(QualityFlag qualityFlag) {
        this.qualityFlag = qualityFlag;
    }

    public Department getRecorderDepartment() {
        return this.recorderDepartment;
    }

    public void setRecorderDepartment(Department recorderDepartment) {
        this.recorderDepartment = recorderDepartment;
    }

    public Vessel getFromVessel() {
        return this.fromVessel;
    }

    public void setFromVessel(Vessel fromVessel) {
        this.fromVessel = fromVessel;
    }

    public Collection<SurveyMeasurement> getSurveyMeasurements() {
        return this.surveyMeasurements;
    }

    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurements) {
        this.surveyMeasurements = surveyMeasurements;
    }

    public Collection<Produce> getProduces() {
        return this.produces;
    }

    public void setProduces(Collection<Produce> produces) {
        this.produces = produces;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Transshipment)) {
            return false;
        }
        Transshipment that = (Transshipment)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Transshipment newInstance() {
            TransshipmentImpl entity = new TransshipmentImpl();
            return entity;
        }

        public static Transshipment newInstance(Date transshipmentDateTime, Date creationDate, Vessel toVessel, Program program, QualityFlag qualityFlag, Department recorderDepartment, Vessel fromVessel) {
            Transshipment entity = Factory.newInstance();
            entity.setTransshipmentDateTime(transshipmentDateTime);
            entity.setCreationDate(creationDate);
            entity.setToVessel(toVessel);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setFromVessel(fromVessel);
            return entity;
        }

        public static Transshipment newInstance(Date transshipmentDateTime, Short rankOrder, String comments, Date creationDate, Date controlDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Location transshipmentLocation, Vessel toVessel, FishingTrip fishingTrip, Program program, Person recorderPerson, QualityFlag qualityFlag, Department recorderDepartment, Vessel fromVessel, Collection<SurveyMeasurement> surveyMeasurements, Collection<Produce> produces) {
            Transshipment entity = Factory.newInstance();
            entity.setTransshipmentDateTime(transshipmentDateTime);
            entity.setRankOrder(rankOrder);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setTransshipmentLocation(transshipmentLocation);
            entity.setToVessel(toVessel);
            entity.setFishingTrip(fishingTrip);
            entity.setProgram(program);
            entity.setRecorderPerson(recorderPerson);
            entity.setQualityFlag(qualityFlag);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setFromVessel(fromVessel);
            entity.setSurveyMeasurements(surveyMeasurements);
            entity.setProduces(produces);
            return entity;
        }
    }
}

