/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.oxbow.swingbits.popup;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

final class PopupMenuResizer
extends MouseAdapter {
    private final JPopupMenu menu;
    private static final int REZSIZE_SPOT_SIZE = 10;
    private Point mouseStart = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private Dimension startSize;
    private boolean isResizing = false;

    public static void decorate(JPopupMenu menu) {
        new PopupMenuResizer(menu);
    }

    private PopupMenuResizer(JPopupMenu menu) {
        this.menu = menu;
        this.menu.setLightWeightPopupEnabled(true);
        menu.addMouseListener(this);
        menu.addMouseMotionListener(this);
    }

    private boolean isInResizeSpot(Point point) {
        if (point == null) {
            return false;
        }
        Rectangle resizeSpot = new Rectangle(this.menu.getWidth() - 10, this.menu.getHeight() - 10, 10, 10);
        return resizeSpot.contains(point);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.menu.setCursor(Cursor.getPredefinedCursor(this.isInResizeSpot(e.getPoint()) ? 5 : 0));
    }

    private Point toScreen(MouseEvent e) {
        Point p = e.getPoint();
        SwingUtilities.convertPointToScreen(p, e.getComponent());
        return p;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseStart = this.toScreen(e);
        this.startSize = this.menu.getSize();
        this.isResizing = this.isInResizeSpot(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseStart = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.isResizing = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isResizing) {
            return;
        }
        Point p = this.toScreen(e);
        int dx = p.x - this.mouseStart.x;
        int dy = p.y - this.mouseStart.y;
        Dimension minDim = this.menu.getMinimumSize();
        Dimension newDim = new Dimension(this.startSize.width + dx, this.startSize.height + dy);
        if (newDim.width >= minDim.width && newDim.height >= minDim.height) {
            this.menu.setPopupSize(newDim);
        }
    }
}

