/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MacroWasteBatch;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface TuttiPersistence
extends TuttiPersistenceServiceImplementor {
    public String getImplementationName();

    public List<Zone> getAllProgramZone();

    public List<Country> getAllCountry();

    public List<FishingOperationLocation> getAllFishingOperationStrata(String var1);

    public List<FishingOperationLocation> getAllFishingOperationSubStrata(String var1, String var2);

    public List<FishingOperationLocation> getAllFishingOperationLocation(String var1, String var2, String var3);

    public List<Vessel> getAllScientificVessel();

    public List<Vessel> getAllFishingVessel();

    public List<Species> getAllSpecies();

    public List<Species> getAllReferentSpecies();

    public List<Species> getAllSpecies(TuttiProtocol var1);

    public List<Caracteristic> getAllCaracteristic();

    public Caracteristic getSizeCategoryCaracteristic();

    public Caracteristic getSexCaracteristic();

    public Caracteristic getSortedUnsortedCaracteristic();

    public Caracteristic getMaturityCaracteristic();

    public Caracteristic getMacroWasteCategoryCaracteristic();

    public Caracteristic getMacroWasteSizeCategoryCaracteristic();

    public List<Gear> getAllScientificGear();

    public List<Gear> getAllFishingGear();

    public List<Person> getAllPerson();

    public Person getPerson(Integer var1);

    public Gear getGear(Integer var1);

    public Vessel getVessel(String var1);

    public boolean isSortedQualitativeValue(CaracteristicQualitativeValue var1);

    @Transactional(readOnly=false)
    public List<Species> importTemporarySpecies(List<Species> var1);

    @Transactional(readOnly=false)
    public List<Vessel> importTemporaryVessel(List<Vessel> var1);

    @Transactional(readOnly=false)
    public List<Person> importTemporaryPerson(List<Person> var1);

    @Transactional(readOnly=false)
    public List<Gear> importTemporaryGear(List<Gear> var1);

    public List<Program> getAllProgram();

    public Program getProgram(String var1);

    @Transactional(readOnly=false)
    public Program createProgram(Program var1);

    @Transactional(readOnly=false)
    public Program saveProgram(Program var1);

    public List<Cruise> getAllCruise(String var1);

    public Cruise getCruise(String var1);

    @Transactional(readOnly=false)
    public Cruise createCruise(Cruise var1);

    @Transactional(readOnly=false)
    public Cruise saveCruise(Cruise var1);

    public List<String> getAllProtocolNames();

    public List<TuttiProtocol> getAllProtocol();

    public boolean isProtocolExist(String var1);

    public TuttiProtocol getProtocol(String var1);

    @Transactional(readOnly=false)
    public TuttiProtocol createProtocol(TuttiProtocol var1);

    @Transactional(readOnly=false)
    public TuttiProtocol saveProtocol(TuttiProtocol var1);

    @Transactional(readOnly=false)
    public void deleteProtocol(String var1);

    public List<FishingOperation> getAllFishingOperation(String var1);

    public FishingOperation getFishingOperation(String var1);

    @Transactional(readOnly=false)
    public FishingOperation createFishingOperation(FishingOperation var1);

    @Transactional(readOnly=false)
    public FishingOperation saveFishingOperation(FishingOperation var1);

    public CatchBatch getCatchBatchFromFishingOperation(String var1);

    @Transactional(readOnly=false)
    public CatchBatch createCatchBatch(CatchBatch var1);

    @Transactional(readOnly=false)
    public CatchBatch saveCatchBatch(CatchBatch var1);

    public List<SpeciesBatch> getAllRootSpeciesBatch(String var1);

    @Transactional(readOnly=false)
    public SpeciesBatch createSpeciesBatch(SpeciesBatch var1, String var2);

    @Transactional(readOnly=false)
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch var1);

    @Transactional(readOnly=false)
    public void deleteSpeciesBatch(String var1);

    @Transactional(readOnly=false)
    public void deleteSpeciesSubBatch(String var1);

    @Transactional(readOnly=false)
    public void changeSpeciesBatchSpecies(String var1, Species var2);

    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String var1);

    @Transactional(readOnly=false)
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String var1, List<SpeciesBatchFrequency> var2);

    public List<BenthosBatch> getAllBenthosBatch(String var1);

    public BenthosBatch getBenthosBatch(String var1);

    @Transactional(readOnly=false)
    public BenthosBatch createBenthosBatch(BenthosBatch var1);

    @Transactional(readOnly=false)
    public BenthosBatch saveBenthosBatch(BenthosBatch var1);

    @Transactional(readOnly=false)
    public void deleteBenthosBatch(String var1);

    public List<PlanktonBatch> getAllPlanktonBatch(String var1);

    public PlanktonBatch getPlanktonBatch(String var1);

    @Transactional(readOnly=false)
    public PlanktonBatch createPlanktonBatch(PlanktonBatch var1);

    @Transactional(readOnly=false)
    public PlanktonBatch savePlanktonBatch(PlanktonBatch var1);

    @Transactional(readOnly=false)
    public void deletePlanktonBatch(String var1);

    public List<MacroWasteBatch> getAllMacroWasteBatch(String var1);

    public MacroWasteBatch getMacroWasteBatch(String var1);

    @Transactional(readOnly=false)
    public MacroWasteBatch createMacroWasteBatch(MacroWasteBatch var1);

    @Transactional(readOnly=false)
    public MacroWasteBatch saveMacroWasteBatch(MacroWasteBatch var1);

    @Transactional(readOnly=false)
    public void deleteMacroWasteBatch(String var1);

    public List<AccidentalBatch> getAllAccidentalBatch(String var1);

    public AccidentalBatch getAccidentalBatch(String var1);

    @Transactional(readOnly=false)
    public AccidentalBatch createAccidentalBatch(AccidentalBatch var1);

    @Transactional(readOnly=false)
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch var1);

    @Transactional(readOnly=false)
    public void deleteAccidentalBatch(String var1);
}

