package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: RenameSpeciesBatchAction.java 409 2013-02-13 18:24:23Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/RenameSpeciesBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To rename the species for a species batch and all his children.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RenameSpeciesBatchAction extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(RenameSpeciesBatchAction.class);

    protected Species selectedSpecies;

    public RenameSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler,
              "renameSpeciesBatch",
              "batch-rename",
              _("tutti.action.renameSpeciesBatch"),
              _("tutti.action.renameSpeciesBatch.tip"),
              false
        );

    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean result = super.prepareAction(event);

        SpeciesBatchUIHandler handler = getHandler();

        SpeciesBatchTableModel tableModel = handler.getTableModel();
        JXTable table = handler.getTable();
        SpeciesBatchRowModel row = tableModel.getEntry(table.getSelectedRow());

        SpeciesBatchUIModel model = handler.getModel();
        List<Species> speciesList = Lists.newArrayList(model.getAllSpecies());
        speciesList.removeAll(
                model.getSpeciesUsed().get(
                        row.getSortedUnsortedCategoryValue()));

        selectedSpecies = getHandler().openAddSpeciesDialog(
                _("tutti.title.selectSpecies"),
                speciesList
        );

        result &= selectedSpecies != null;
        return result;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        selectedSpecies = null;
        super.releaseAction(event);
    }

    @Override
    protected void doAction(ActionEvent event) {
        SpeciesBatchUIHandler handler = getHandler();

        SpeciesBatchTableModel tableModel = handler.getTableModel();
        JXTable table = handler.getTable();
        SpeciesBatchRowModel row = tableModel.getEntry(table.getSelectedRow());

        PersistenceService persistenceService = getService(PersistenceService.class);
        persistenceService.changeSpeciesBatchSpecies(row.getId(), selectedSpecies);

        Collection<Species> speciesUsed = getModel().getSpeciesUsed()
                .get(row.getSortedUnsortedCategoryValue());
        speciesUsed.remove(row.getSpecies());
        changeChildrenSpecies(row, selectedSpecies);
        speciesUsed.add(selectedSpecies);
    }

    protected void changeChildrenSpecies(SpeciesBatchRowModel row,
                                         Species species) {
        row.setSpecies(species);
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (children != null) {
            for (SpeciesBatchRowModel child : children) {
                changeChildrenSpecies(child, species);
            }
        }
    }
}
