package fr.ifremer.tutti.ui.swing.config;

/*
 * #%L
 * Tutti :: Application
 * $Id: TuttiApplicationConfigOption.java 396 2013-02-11 16:56:38Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/config/TuttiApplicationConfigOption.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import org.nuiton.util.ApplicationConfig;

import javax.swing.KeyStroke;
import java.awt.Color;
import java.io.File;
import java.util.Locale;

import static org.nuiton.i18n.I18n.n_;

/**
 * All Tutti configuration options.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public enum TuttiApplicationConfigOption implements ApplicationConfig.OptionDef {

    TUTTI_LAUNCH_MODE(
            "tutti.launch.mode",
            n_("tutti.option.launch.mode.description"),
            null,
            String.class,
            true,
            true
    ),

    TUTTI_I18N_DIRECTORY(
            "tutti.i18n.directory",
            n_("tutti.option.i18n.directory.description"),
            "${tutti.basedir}/i18n",
            File.class
    ),

    TUTTI_I18N_LOCALE(
            "tutti.i18n.locale",
            n_("tutti.option.i18n.locale.description"),
            Locale.FRANCE.getCountry(),
            Locale.class
    ),

    TUTTI_UPDATE_URL(
            "tutti.update.application.url",
            n_("tutti.option.update.url.description"),
            "http://appup.forge.codelutin.com/tutti/update-tutti.properties",
            String.class
    ),

    UI_CONFIG_FILE(
            "tutti.ui.config.file",
            n_("tutti.option.ui.config.file.description"),
            "${tutti.data.directory}/tuttiUI.xml",
            File.class
    ),

    PROGRAM_ID(
            "tutti.programId",
            n_("tutti.option.programId.description"),
            null,
            String.class
    ),

    CRUISE_ID(
            "tutti.cruiseId",
            n_("tutti.option.cruiseId.description"),
            null,
            String.class
    ),

    PROTOCOL_ID(
            "tutti.protocolId",
            n_("tutti.option.protocolId.description"),
            null,
            String.class
    ),

    AUTO_POPUP_NUMBER_EDITOR(
            "tutti.ui.autoPopupNumberEditor",
            n_("tutti.option.ui.autoPopupNumberEditor.description"),
            String.valueOf(false),
            Boolean.class
    ),

    SHOW_NUMBER_EDITOR_BUTTON(
            "tutti.ui.showNumberEditorButton",
            n_("tutti.option.ui.showNumberEditorButton.description"),
            String.valueOf(true),
            Boolean.class
    ),

    COLOR_ROW_READ_ONLY(
            "tutti.ui.color.rowReadOnly",
            n_("tutti.option.ui.color.rowReadOnly.description"),
            new Color(192, 192, 192).toString(),
            Color.class
    ),

    COLOR_ROW_INVALID(
            "tutti.ui.color.rowInvalid",
            n_("tutti.option.ui.color.rowInvalid.description"),
            new Color(255, 128, 128).toString(),
            Color.class
    ),

    COLOR_CELL_WITH_VALUE(
            "tutti.ui.color.cellWithValue",
            n_("tutti.option.ui.color.cellWithValue.description"),
            new Color(128, 255, 128).toString(),
            Color.class
    ),

    COLOR_ROW_TO_CONFIRM(
            "tutti.ui.color.rowToConfirm",
            n_("tutti.option.ui.color.rowToConfirm.description"),
            Color.ORANGE.toString(),
            Color.class
    ),

    SHORTCUT_CLOSE_POPUP(
            "tutti.ui.shortcut.closePopup",
            n_("tutti.option.ui.shortcut.closePopup.description"),
            "alt pressed F",
            KeyStroke.class
    ),

    COORDINATE_EDITOR_TYPE(
            "tutti.ui.coordinateEditorType",
            n_("tutti.option.ui.coordinateEditorType.description"),
            CoordinateEditorType.DD.toString(),
            CoordinateEditorType.class
    ),

    DATE_FORMAT(
            "tutti.ui.dateFormat",
            n_("tutti.option.ui.dateFormat.description"),
            "dd/MM/yyyy",
            String.class
    );

    /** Configuration key. */
    private final String key;

    /** I18n key of option description */
    private final String description;

    /** Type of option */
    private final Class<?> type;

    /** Default value of option. */
    private String defaultValue;

    /** Flag to not keep option value on disk */
    private boolean isTransient;

    /** Flag to not allow option value modification */
    private boolean isFinal;

    TuttiApplicationConfigOption(String key,
                                 String description,
                                 String defaultValue,
                                 Class<?> type,
                                 boolean isTransient,
                                 boolean isFinal) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isTransient = isTransient;
        this.isFinal = isFinal;
    }

    TuttiApplicationConfigOption(String key,
                                 String description,
                                 String defaultValue,
                                 Class<?> type) {
        this(key, description, defaultValue, type, false, false);
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class<?> getType() {
        return type;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    @Override
    public boolean isFinal() {
        return isFinal;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean newValue) {
        // not used
    }

    @Override
    public void setFinal(boolean newValue) {
        // not used
    }
}
