/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public abstract class AbstractTuttiTableModel<R extends Serializable>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractTuttiTableModel.class);
    protected final TableColumnModelExt columnModel;
    protected List<R> rows;
    protected Set<ColumnIdentifier<?>> noneEditableCols;
    protected final boolean createNewRow;
    protected final boolean createEmptyRowIsEmpty;

    public abstract R createNewRow();

    protected AbstractTuttiTableModel(TableColumnModelExt columnModel, boolean createNewRow, boolean createEmptyRowIsEmpty) {
        this.columnModel = columnModel;
        this.createNewRow = createNewRow;
        this.createEmptyRowIsEmpty = createEmptyRowIsEmpty;
        columnModel.addColumnModelListener((TableColumnModelListener)new TableColumnModelExtListener(){

            public void columnPropertyChange(PropertyChangeEvent event) {
                TableColumnExt column = (TableColumnExt)event.getSource();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Property [" + event.getPropertyName() + "] changed on coloumn [" + column.getTitle() + "] :: " + event.getNewValue()));
                }
            }

            public void columnAdded(TableColumnModelEvent e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Column added [" + e.getFromIndex() + "] :: " + e.getToIndex()));
                }
            }

            public void columnRemoved(TableColumnModelEvent e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Column removed [" + e.getFromIndex() + "] :: " + e.getToIndex()));
                }
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public final List<R> getRows() {
        return this.rows;
    }

    public final void setRows(List<R> data) {
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        this.rows = null;
        if (this.createEmptyRowIsEmpty && data.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creates a first empty row on tableModel " + this));
            }
            data.add(this.createNewRow());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Set " + data.size() + " row(s) in table model " + this));
        }
        this.rows = data;
        this.onRowsChanged(data);
        this.fireTableDataChanged();
    }

    public boolean isCreateNewRow() {
        return this.createNewRow;
    }

    public boolean isCreateEmptyRowIsEmpty() {
        return this.createEmptyRowIsEmpty;
    }

    public final void addNewRow() {
        R newValue = this.createNewRow();
        this.addNewRow(newValue);
    }

    public final void addNewRow(R newValue) {
        this.addNewRow(this.getRowCount(), newValue);
    }

    public final void addNewRow(int rowIndex, R newValue) {
        Preconditions.checkNotNull(newValue, (Object)"Row can not be null.");
        List<R> data = this.getRows();
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        data.add(rowIndex, newValue);
        this.onRowAdded(rowIndex, newValue);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public final int updateRow(R row) {
        Preconditions.checkNotNull(row, (Object)"Row can not be null.");
        List<R> data = this.getRows();
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        int rowIndex = data.indexOf(row);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
        return rowIndex;
    }

    public final R removeRow(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        List<R> data = this.getRows();
        Serializable result = (Serializable)data.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return (R)result;
    }

    protected void onRowsChanged(List<R> data) {
    }

    protected void onRowAdded(int rowIndex, R newValue) {
    }

    public final ColumnIdentifier<R> getPropertyName(int columnIndex) {
        TableColumn column = this.getColumn(columnIndex);
        return (ColumnIdentifier)column.getIdentifier();
    }

    public final int getRowIndex(R row) {
        int result = this.rows == null ? -1 : this.rows.indexOf(row);
        return result;
    }

    public final R getEntry(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        List<R> data = this.getRows();
        Serializable result = data == null ? null : (Serializable)data.get(rowIndex);
        return (R)result;
    }

    public final void setNoneEditableCols(ColumnIdentifier<?> ... noneEditableCols) {
        this.noneEditableCols = Sets.newHashSet((Object[])noneEditableCols);
    }

    @Override
    public final int getRowCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    @Override
    public final int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        R entry = this.getEntry(rowIndex);
        ColumnIdentifier<R> propertyName = this.getPropertyName(columnIndex);
        if (log.isInfoEnabled()) {
            log.info((Object)("columnIndex: " + columnIndex + " :: " + propertyName.getPropertyName()));
        }
        Object result = this.getValueAt(rowIndex, columnIndex, propertyName, entry);
        return result;
    }

    @Override
    public final void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setValueAt " + aValue));
        }
        R entry = this.getEntry(rowIndex);
        ColumnIdentifier<R> propertyName = this.getPropertyName(columnIndex);
        this.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
    }

    @Override
    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        ColumnIdentifier<R> identifier = this.getPropertyName(columnIndex);
        boolean result = this.isCellEditable(rowIndex, columnIndex, identifier);
        return result;
    }

    protected Object getValueAt(int rowIndex, int columnIndex, ColumnIdentifier<R> propertyName, R entry) {
        Object result = propertyName.getValue(entry);
        return result;
    }

    protected void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<R> propertyName, R entry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setValueAt " + aValue));
        }
        propertyName.setValue(entry, aValue);
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<R> propertyName) {
        boolean result = !this.noneEditableCols.contains(propertyName);
        return result;
    }

    protected final void fireTableCellUpdated(int rowIndex, ColumnIdentifier ... identifiers) {
        for (ColumnIdentifier identifier : identifiers) {
            int columnIndex = this.getColumnIndex(identifier);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    protected final TableColumn getColumn(int columnIndex) {
        return (TableColumn)this.columnModel.getColumns(true).get(columnIndex);
    }

    protected final int getColumnIndex(ColumnIdentifier<?> property) {
        int result = this.columnModel.getColumnIndex(property);
        return result;
    }
}

