/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.HBox;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentEditorUIHandler {
    private static final Log log = LogFactory.getLog(AttachmentEditorUIHandler.class);
    private final AttachmentEditorUI ui;
    private final PersistenceService persistenceService;

    public AttachmentEditorUIHandler(AttachmentEditorUI ui) {
        this.ui = ui;
        this.persistenceService = TuttiUIContext.getApplicationContext().getPersistenceService();
        this.ui.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AttachmentEditorUIHandler.this.init();
            }
        });
    }

    public void init() {
        List<Attachment> list;
        this.resetFields();
        this.ui.getAttachments().removeAll();
        AttachmentModelAware bean = this.ui.getBean();
        if (bean != null && (list = bean.getAttachment()) != null) {
            for (Attachment attachment : list) {
                this.addAttachment(attachment);
            }
        }
    }

    protected void addAttachment(final Attachment attachment) {
        final HBox hbox = new HBox();
        hbox.setVerticalAlignment(0);
        JButton deleteButton = new JButton(SwingUtil.createActionIcon((String)"delete"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentModelAware bean = AttachmentEditorUIHandler.this.ui.getBean();
                AttachmentEditorUIHandler.this.persistenceService.deleteAttachment(attachment.getId());
                bean.removeAttachment(attachment);
                AttachmentEditorUIHandler.this.ui.getAttachments().remove((Component)hbox);
                JDialog parent = (JDialog)SwingUtil.getParentContainer((Object)((Object)AttachmentEditorUIHandler.this.ui), JDialog.class);
                parent.pack();
            }
        });
        hbox.add((Component)deleteButton);
        final JLabel label = new JLabel("<html><body><a href=''>" + attachment.getName() + "</a></body></html>");
        label.setToolTipText(attachment.getComment());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File file = AttachmentEditorUIHandler.this.persistenceService.getAttachmentFile(attachment.getId());
                SwingUtil.openLink((String)("file://" + file.getAbsolutePath()));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setCursor(Cursor.getDefaultCursor());
            }
        });
        hbox.add((Component)label);
        this.ui.getAttachments().add((Component)hbox);
    }

    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will close UI " + (Object)((Object)this.ui)));
        }
        ((Window)SwingUtil.getParentContainer((Object)((Object)this.ui), Window.class)).dispose();
    }

    public void addAttachment() {
        AttachmentModelAware bean = this.ui.getBean();
        Attachment attachment = new Attachment();
        File file = this.ui.getFile().getSelectedFile();
        if (file != null) {
            String name = this.ui.getFileName().getText();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = file.getName();
            }
            attachment.setObjectType(this.ui.getObjectType());
            attachment.setObjectId(Integer.valueOf(String.valueOf(TuttiUIUtil.getProperty(bean, this.ui.getObjectIdProperty()))));
            attachment.setName(name);
            attachment.setComment(this.ui.getFileComment().getText());
            attachment = this.persistenceService.createAttachment(attachment, file);
            bean.addAttachment(attachment);
            this.resetFields();
            this.addAttachment(attachment);
            JDialog parent = (JDialog)SwingUtil.getParentContainer((Object)((Object)this.ui), JDialog.class);
            parent.pack();
        }
    }

    protected void resetFields() {
        this.ui.getFile().setSelectedFile((File)null);
        this.ui.getFileName().setText("");
        this.ui.getFileComment().setText("");
    }
}

