/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportTemporaryGearAction
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ImportTemporaryGearAction.class);
    private File file;

    public ImportTemporaryGearAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, "import", I18n._((String)"tutti.action.importTemporaryGear", (Object[])new Object[0]), I18n._((String)"tutti.action.importTemporaryGear.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction() {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.importTemporaryGearFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseReferentialGearFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import gear temporary referential from file: " + this.file));
        }
        TuttiReferentialImportExportService service = this.getContext().getTuttiReferentialImportExportService();
        service.importTemporaryGear(this.file);
        this.getDataContext().resetGears();
        this.sendMessage("R\u00e9f\u00e9rentiel temporaire d'engins import\u00e9 depuis le fichier " + this.file + ".");
    }
}

