/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.security;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.security.ICipherProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CipherProviderExtensions {
    private static final String CIPHER_PROVIDER_EXT_POINT = "org.eclipse.datatools.connectivity.cipherProvider";
    private static final String CIPHER_PROVIDER_ELEMENT_NAME = "cipherProvider";
    private static final String CIPHER_PROVIDER_FILE_EXT_ATTR_NAME = "fileExtension";
    private static final String CIPHER_PROVIDER_CLASS_ATTR_NAME = "class";
    private static final String NULL_FILE_EXT_CIPHER_PROVIDER_KEY = "org.eclipse.datatools.connectivity.cipherProvider.nullFileExt";
    private static final String NULL_FILE_EXT_ATTR_VALUE = "default";
    private static final String FILE_EXT_SEPARATOR = ".";
    private static Map<String, ICipherProvider> sm_registeredCipherProviders;

    static ICipherProvider getCipherProviderForFile(File profileStoreFile) {
        if (profileStoreFile == null) {
            return null;
        }
        String profileStoreFilePath = profileStoreFile.getPath();
        int fileExtSeparatorIndex = profileStoreFilePath.lastIndexOf(FILE_EXT_SEPARATOR);
        String fileExtension = null;
        if (fileExtSeparatorIndex >= 0 && profileStoreFilePath.length() > fileExtSeparatorIndex + 1) {
            fileExtension = profileStoreFilePath.substring(fileExtSeparatorIndex + 1);
        }
        return CipherProviderExtensions.getCipherProviderForFileExtension(fileExtension);
    }

    static ICipherProvider getCipherProviderForFileExtension(String fileExtension) {
        if (fileExtension == null) {
            fileExtension = NULL_FILE_EXT_ATTR_VALUE;
        }
        String fileExtKey = CipherProviderExtensions.getFileExtMapKey(fileExtension);
        return CipherProviderExtensions.getRegisteredCipherProviders().get(fileExtKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, ICipherProvider> getRegisteredCipherProviders() {
        if (sm_registeredCipherProviders != null) return sm_registeredCipherProviders;
        Class<CipherProviderExtensions> clazz = CipherProviderExtensions.class;
        synchronized (CipherProviderExtensions.class) {
            if (sm_registeredCipherProviders != null) return sm_registeredCipherProviders;
            sm_registeredCipherProviders = CipherProviderExtensions.loadRegisteredCipherProviders();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_registeredCipherProviders;
        }
    }

    private static Map<String, ICipherProvider> loadRegisteredCipherProviders() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(CIPHER_PROVIDER_EXT_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, ICipherProvider> cipherProviders = new HashMap<String, ICipherProvider>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            if (configElements.length >= 1) {
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    if (configElement.getName().equals(CIPHER_PROVIDER_ELEMENT_NAME)) {
                        String fileExtension = configElement.getAttribute(CIPHER_PROVIDER_FILE_EXT_ATTR_NAME);
                        String providerClassName = configElement.getAttribute(CIPHER_PROVIDER_CLASS_ATTR_NAME);
                        if (fileExtension == null || fileExtension.trim().length() == 0 || providerClassName == null || providerClassName.trim().length() == 0) {
                            ConnectivityPlugin.getDefault().logInfo(ConnectivityPlugin.getDefault().getResourceString("CipherProviderExtensions.missingRequiredAttrValue", new Object[]{CIPHER_PROVIDER_ELEMENT_NAME, CIPHER_PROVIDER_EXT_POINT, extensions[i].getContributor().getName(), CIPHER_PROVIDER_FILE_EXT_ATTR_NAME, fileExtension, CIPHER_PROVIDER_CLASS_ATTR_NAME, providerClassName}));
                        } else {
                            try {
                                Object cipherProviderInstance = configElement.createExecutableExtension(CIPHER_PROVIDER_CLASS_ATTR_NAME);
                                if (!(cipherProviderInstance instanceof ICipherProvider)) {
                                    ConnectivityPlugin.getDefault().logInfo(ConnectivityPlugin.getDefault().getResourceString("CipherProviderExtensions.invalidClassAttrValue", new Object[]{providerClassName, CIPHER_PROVIDER_EXT_POINT, extensions[i].getContributor().getName(), ICipherProvider.class.getName()}));
                                } else {
                                    String fileExtKey = CipherProviderExtensions.getFileExtMapKey(fileExtension);
                                    ICipherProvider overriddenProvider = cipherProviders.put(fileExtKey, (ICipherProvider)cipherProviderInstance);
                                    if (overriddenProvider != null) {
                                        ConnectivityPlugin.getDefault().logWarning(ConnectivityPlugin.getDefault().getResourceString("CipherProviderExtensions.conflictingExtensions", new Object[]{overriddenProvider, cipherProviderInstance, extensions[i].getContributor().getName(), fileExtension}));
                                    }
                                }
                            }
                            catch (CoreException e) {
                                ConnectivityPlugin.getDefault().log(e);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return cipherProviders;
    }

    private static String getFileExtMapKey(String fileExtension) {
        if (fileExtension.startsWith(FILE_EXT_SEPARATOR)) {
            fileExtension = fileExtension.substring(FILE_EXT_SEPARATOR.length());
        }
        if (fileExtension.equals(NULL_FILE_EXT_ATTR_VALUE)) {
            fileExtension = NULL_FILE_EXT_CIPHER_PROVIDER_KEY;
        }
        return fileExtension;
    }
}

