/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.executor.buffermgr.Table;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.HTMLConstants;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertiesProcessor;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.layout.pdf.util.StyleProperties;
import org.eclipse.birt.report.engine.layout.pdf.util.Tag2Style;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableProcessor
implements HTMLConstants {
    private static final String ATTRIBUTE_COLSPAN = "colspan";
    private static final String ATTRIBUTE_ROWSPAN = "rowspan";

    public static void processTable(Element ele, Map<Element, StyleProperties> cssStyles, IContent content, ActionContent action) {
        TableState tableState = new TableState(ele, cssStyles, content, action);
        tableState.processNodes();
        Table table = new Table(tableState.getRowCount(), tableState.getColumnCount());
        TableContent tableContent = (TableContent)tableState.getContent();
        for (RowContent row : tableContent.getChildren()) {
            table.createRow(row);
            for (CellContent cell : row.getChildren()) {
                int rowSpan = cell.getRowSpan();
                int colSpan = cell.getColSpan();
                table.createCell(-1, rowSpan, colSpan, new InternalCellContent(cell));
            }
        }
        TableProcessor.normalize(table, tableContent, tableState);
    }

    protected static void normalize(Table table, TableContent tableContent, TableState tableState) {
        ReportContent report = (ReportContent)tableContent.getReportContent();
        int i = 0;
        while (i < table.getRowCount()) {
            Row row = table.getRow(i);
            RowContent rowContent = (RowContent)row.getContent();
            IStyle rowStyle = rowContent.getStyle();
            if (rowStyle != null && rowStyle.getPageBreakInside() == null) {
                rowStyle.setProperty(56, IStyle.AUTO_VALUE);
            }
            Collection children = rowContent.getChildren();
            children.clear();
            int j = 0;
            while (j < table.getColCount()) {
                Cell cell = row.getCell(j);
                CellContent cellContent = null;
                int status = cell.getStatus();
                if (status == 0) {
                    cellContent = (CellContent)report.createCellContent();
                    cellContent.setRowSpan(1);
                    cellContent.setColSpan(1);
                    cellContent.setColumn(j);
                    children.add(cellContent);
                    cellContent.setParent(rowContent);
                } else if (status == 1) {
                    cellContent = ((InternalCellContent)cell.getContent()).cell;
                    cellContent.setColSpan(cell.getColSpan());
                    cellContent.setRowSpan(cell.getRowSpan());
                    cellContent.setColumn(j);
                    children.add(cellContent);
                    cellContent.setParent(rowContent);
                }
                ++j;
            }
            ++i;
        }
    }

    private static class CellState
    extends State {
        private CellContent cell;

        public CellState(Element element, Map<Element, StyleProperties> cssStyles, IContent parent, ActionContent action) {
            super(element, cssStyles, action);
            this.cell = (CellContent)parent.getReportContent().createCellContent();
            this.content = this.cell;
            this.setParent(parent);
            HTML2Content.handleStyle(element, cssStyles, this.content);
            this.cell.setRowSpan(PropertyUtil.getIntAttribute(element, TableProcessor.ATTRIBUTE_ROWSPAN));
            this.cell.setColSpan(PropertyUtil.getIntAttribute(element, TableProcessor.ATTRIBUTE_COLSPAN));
        }

        public void processNodes() {
            HTML2Content.processNodes(this.element, this.cssStyles, this.content, this.action, 0);
        }

        public int getColSpan() {
            return this.cell.getColSpan();
        }

        public int getRowSpan() {
            return this.cell.getRowSpan();
        }
    }

    private static class InternalCellContent
    implements Cell.Content {
        CellContent cell;

        InternalCellContent(CellContent cell) {
            this.cell = cell;
        }

        @Override
        public boolean isEmpty() {
            return this.cell != null;
        }

        @Override
        public void reset() {
        }
    }

    private static class RowState
    extends State {
        private Hashtable<Integer, Integer> records;
        private int columnCount;
        private int index;

        public RowState(Element element, Map<Element, StyleProperties> cssStyles, IContent parent, ActionContent action, Hashtable<Integer, Integer> records, int index) {
            super(element, cssStyles, action);
            this.content = (RowContent)parent.getReportContent().createRowContent();
            this.setParent(parent);
            this.content.setHeight(PropertyUtil.getDimensionAttribute(element, "height"));
            HTML2Content.handleStyle(element, cssStyles, this.content);
            this.records = records;
            this.index = index;
        }

        public void processNodes() {
            if (this.records.containsKey(this.index)) {
                this.columnCount += this.records.get(this.index).intValue();
            }
            Node node = this.element.getFirstChild();
            while (node != null) {
                int current = this.index;
                assert (node.getNodeType() == 1);
                Element element = (Element)node;
                String tagName = element.getTagName();
                assert ("td".equals(tagName));
                CellState cellState = new CellState(element, this.cssStyles, this.content, this.action);
                cellState.processNodes();
                int rowSpan = cellState.getRowSpan();
                int colSpan = cellState.getColSpan();
                if (rowSpan > 1) {
                    int i = 1;
                    while (i < rowSpan) {
                        int offset = current + i;
                        if (this.records.containsKey(offset)) {
                            this.records.put(offset, this.records.get(offset) + colSpan);
                        } else {
                            this.records.put(offset, colSpan);
                        }
                        ++i;
                    }
                }
                this.columnCount += cellState.getColSpan();
                node = node.getNextSibling();
            }
        }

        public int getColumnCount() {
            return this.columnCount;
        }
    }

    private static class State {
        protected Element element;
        protected Map<Element, StyleProperties> cssStyles;
        protected IContent content;
        protected ActionContent action;

        public State(Element element, Map<Element, StyleProperties> cssStyles, ActionContent action) {
            this.element = element;
            this.cssStyles = cssStyles;
            this.action = action;
        }

        protected void setParent(IContent parent) {
            parent.getChildren().add(this.content);
            this.content.setParent(parent);
        }

        public IContent getContent() {
            return this.content;
        }
    }

    public static class TableState
    extends State {
        private int columnCount;
        private int rowCount;
        private TableContent table;
        private Hashtable<Integer, Integer> records = new Hashtable();
        private int index = 0;

        public TableState(Element element, Map<Element, StyleProperties> cssStyles, IContent parent, ActionContent action) {
            super(element, cssStyles, action);
            this.content = (TableContent)parent.getReportContent().createTableContent();
            this.table = (TableContent)this.content;
            this.setParent(parent);
            this.content.setWidth(PropertyUtil.getDimensionAttribute(element, "width"));
            HTML2Content.handleStyle(element, cssStyles, this.content);
            this.processCellStyle(element, cssStyles);
        }

        protected void processRow(Element element, Map<Element, StyleProperties> cssStyles, String border, String padding) {
            Node n = element.getFirstChild();
            while (n != null) {
                Element c = (Element)n;
                if ("td".equals(c.getTagName()) || "th".equals(c.getTagName())) {
                    StyleProperties sp = cssStyles.get(c);
                    if (sp == null) {
                        sp = new StyleProperties(new StyleDeclaration(this.content.getCSSEngine()));
                        cssStyles.put(c, sp);
                    }
                    if (border != null && border.length() > 0) {
                        PropertiesProcessor.process("border", border, sp);
                    }
                    if (padding != null && padding.length() > 0) {
                        PropertiesProcessor.process("cellpadding", padding, sp);
                    }
                }
                n = n.getNextSibling();
            }
        }

        private void processCellStyle(Element element, Map<Element, StyleProperties> cssStyles) {
            boolean hasPadding;
            String border = element.getAttribute("border");
            String padding = element.getAttribute("cellpadding");
            boolean hasBorder = border != null && border.length() > 0;
            boolean bl = hasPadding = padding != null && padding.length() > 0;
            if (hasBorder || hasPadding) {
                Node node = element.getFirstChild();
                while (node != null) {
                    Element r = (Element)node;
                    if ("tr".equals(r.getTagName())) {
                        this.processRow(r, cssStyles, border, padding);
                    } else if ("tbody".equals(r.getTagName()) || "thead".equals(r.getTagName()) || "tfoot".equals(r.getTagName())) {
                        Node n = r.getFirstChild();
                        while (n != null) {
                            Element c = (Element)n;
                            if ("tr".equals(c.getTagName())) {
                                this.processRow(c, cssStyles, border, padding);
                            }
                            n = n.getNextSibling();
                        }
                    }
                    node = node.getNextSibling();
                }
            }
        }

        public void processNodes() {
            Element ele = this.element;
            this.processNodes(ele);
        }

        void handleColumnStyle(Element ele, Map<Element, StyleProperties> cssStyles, IColumn column) {
            String tagName;
            Tag2Style tag2Style;
            StyleProperties sp = cssStyles.get(ele);
            if (sp == null) {
                sp = new StyleProperties(new StyleDeclaration(this.content.getCSSEngine()));
                cssStyles.put(ele, sp);
            }
            if ((tag2Style = Tag2Style.getStyleProcess(tagName = ele.getTagName())) != null) {
                tag2Style.process(ele, sp);
            }
            column.setInlineStyle(sp.getStyle());
            Object w = sp.getProperty("width");
            if (w != null && w instanceof DimensionType) {
                column.setWidth((DimensionType)w);
            }
        }

        private void addColumn(int count) {
            int i = 0;
            while (i < count) {
                this.table.addColumn(new Column(this.table.getReportContent()));
                ++i;
            }
        }

        private void processNodes(Element ele) {
            Node node = ele.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    String tagName = element.getTagName();
                    if ("tr".equals(tagName)) {
                        RowState rowState = new RowState(element, this.cssStyles, this.content, this.action, this.records, this.index);
                        rowState.processNodes();
                        this.columnCount = Math.max(this.columnCount, rowState.getColumnCount());
                        if (this.columnCount > this.table.getColumnCount()) {
                            this.addColumn(this.columnCount - this.table.getColumnCount());
                        }
                        ++this.rowCount;
                        ++this.index;
                    } else if ("col".equals(tagName)) {
                        Column column = new Column(this.content.getReportContent());
                        DimensionType cw = PropertyUtil.getDimensionAttribute(element, "width");
                        if (cw != null) {
                            column.setWidth(cw);
                        }
                        ((TableContent)this.content).addColumn(column);
                        this.handleColumnStyle(element, this.cssStyles, column);
                    } else if ("tbody".equals(tagName) || "thead".equals(tagName) || "tfoot".equals(tagName)) {
                        this.processNodes(element);
                    }
                }
                node = node.getNextSibling();
            }
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }
    }
}

