/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.core;

import com.ibm.icu.util.ULocale;
import java.util.ResourceBundle;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;

public class DataException
extends BirtException {
    private static ULocale currentLocale;
    private static final String _pluginId = "org.eclipse.birt.data";
    private static final long serialVersionUID = 8571109940669957243L;
    private static ResourceBundle resourceBundle;

    public DataException(String errorCode) {
        super(_pluginId, errorCode, DataException.getResourceBundle());
    }

    public DataException(String errorCode, Object argv) {
        super(_pluginId, errorCode, argv, DataException.getResourceBundle());
    }

    public DataException(String errorCode, Object[] argv) {
        super(_pluginId, errorCode, argv, DataException.getResourceBundle());
    }

    public DataException(String errorCode, Throwable cause) {
        super(_pluginId, errorCode, DataException.getResourceBundle(), cause);
    }

    public DataException(String errorCode, Throwable cause, Object argv) {
        super(_pluginId, errorCode, argv, DataException.getResourceBundle(), cause);
    }

    public DataException(String errorCode, Throwable cause, Object[] argv) {
        super(_pluginId, errorCode, argv, DataException.getResourceBundle(), cause);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Object[] getArgument() {
        return this.oaMessageArguments;
    }

    @Override
    public String getMessage() {
        String extraMsg;
        String msg = super.getMessage();
        if (this.getCause() != null && (extraMsg = this.getCause().getLocalizedMessage()) != null && extraMsg.length() > 0) {
            msg = String.valueOf(msg) + "\n" + extraMsg;
        }
        return msg;
    }

    public static DataException wrap(BirtException e) {
        if (e instanceof DataException) {
            return (DataException)e;
        }
        return new DataException("data.engine.BirtException", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setLocale(ULocale locale) {
        currentLocale = locale;
        if (resourceBundle == null) return;
        Class<DataException> clazz = DataException.class;
        synchronized (DataException.class) {
            if (resourceBundle == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if ((locale != null || ULocale.getDefault().toLocale().equals(resourceBundle.getLocale())) && (locale == null || locale.toLocale().equals(resourceBundle.getLocale()))) return;
            resourceBundle = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourceBundle getResourceBundle() {
        if (resourceBundle != null) return resourceBundle;
        Class<DataException> clazz = DataException.class;
        synchronized (DataException.class) {
            if (resourceBundle != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return resourceBundle;
            }
            resourceBundle = currentLocale != null ? DataResourceHandle.getInstance(currentLocale).getUResourceBundle() : DataResourceHandle.getInstance().getUResourceBundle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return resourceBundle;
        }
    }
}

