/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.logging.console.LogConsole;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationLoggerUtil {
    private static Log log = LogFactory.getLog(SimulationLoggerUtil.class);

    public static void showSimulationLogConsole(Component parent, String simulationName) throws IllegalArgumentException, IOException {
        SimulationStorage storage = SimulationStorage.getSimulation(simulationName);
        File logFile = new File(storage.getSimulationLogFile());
        String smtpServer = IsisFish.config.getSmtpServer();
        String defaultFrom = IsisFish.config.getUserMail();
        String title = I18n.t((String)"isisfish.simulation.log.console.title", (Object[])new Object[]{simulationName});
        LogConsole ui = LogConsole.newConsole(logFile, smtpServer, defaultFrom, null, title);
        ui.setLocationRelativeTo(parent);
        ui.setVisible(true);
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"isisfish.simulation.log.showConsole", (Object[])new Object[]{simulationName}));
        }
    }
}

