/*
 * #%L
 * IsisFish
 * 
 * $Id: ScriptParametersTableCellEditor.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/models/common/ScriptParametersTableCellEditor.java $
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.ui.widget.editor.ParameterTableCellEditor;

/**
 * Specific editor for script parameters.
 *
 * @author chatellier
 * @version $Revision: 4156 $
 * 
 * Last update : $Date: 2014-12-09 12:27:18 +0100 (mar., 09 déc. 2014) $
 * By : $Author: echatellier $
 */
public class ScriptParametersTableCellEditor extends ParameterTableCellEditor {

    /** serialVersionUID. */
    private static final long serialVersionUID = 8211639776194497615L;

    protected Object script;

    protected List<Class<?>> scriptParametersTypes;

    /**
     * Constructor with script parameter.
     * 
     * @param script script
     */
    public ScriptParametersTableCellEditor(Object script) {
        this.script = script;
        scriptParametersTypes = new ArrayList<Class<?>>();
        //TODO map may be sorted
        Map<String, Class<?>> ruleParametersNamesAndTypes = JavaSourceStorage.getParameterNames(script);
        for (Class<?> type : ruleParametersNamesAndTypes.values()) {
            scriptParametersTypes.add(type);
        }
    }

    /*
     * @see fr.ifremer.isisfish.ui.widget.editor.ParameterTableCellEditor#getType(java.lang.Object, int, int)
     */
    @Override
    protected Class<?> getType(Object value, int row, int column) {
        return scriptParametersTypes.get(row);
    }
}
