package fr.ifremer.isisfish.ui.input.metier;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.ui.input.ChangeModel;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MetierSeasonInfoSpeciesUI extends InputContentUI<Metier> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_METIER_SEASON_INFO = "metierSeasonInfo";
    public static final String PROPERTY_SPECIES = "species";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_METIER_SEASON_INFO_ENABLED = "fieldMetierSeasonInfo.enabled";
    public static final String BINDING_FIELD_PRIMARY_CATCH_ENABLED = "fieldPrimaryCatch.enabled";
    public static final String BINDING_FIELD_TARGET_SPECIES_ENABLED = "fieldTargetSpecies.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_TARGET_SPECIES_ENABLED = "tableTargetSpecies.enabled";
    public static final String BINDING_TARGET_FACTOR_ACTIVE = "targetFactor.active";
    public static final String BINDING_TARGET_FACTOR_BEAN = "targetFactor.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWQW8bRRSeuLGdNA1NE1qCCFVKLVFRdZ1eEJDQlpiGOHJIhZtSyIXx7tiesjuznZlNNjkgfgI/Ae5ckLhxQhw4c+CC+AsIceCK+mbW9nptZ71ic5iN5733zTffe/vefv8XKkqBbjzDYWiJgCnqEWvvg6dPD1rPiK0+JNIW1FdcoOhvpoAKR2jBGexLhW4eNXR4tRderXHP54ywoejNBroo1alLZJcQpdDryQhbympzYN4M/UD0UQekJqF++8/fhW+cr78rIBT6wG4VrrI+LSq+yWwDFaij0DKcdIyrLmYdoCEo6wDfRb1Xc7GUH2OPPEdfoXIDlXwsAEyhN7Jf2WCY+NBXaKlSZ36gapwpcD+sbyj0fltYtC2IR+ApqWxT2bUCalHtaHlEUTDsm0eTYMlZnbV50yc2JfKw7vsGvKTQbItgBumYBAdnUQCQPZw4aMkbAVboTgaA2D+GKsuIk0KVVIQe9aHALmaOS4RC2zmk2I1AYtj5Y+xSB0MuFLqdqIqBwZInkG2rqdcn/c0YYcEGZh2yzx3iKnQrlVwtdh1OCXdOocB0LYW9w/YeYTbsU648xi2XQCGsJkhG3samPa+PBtzVP2/q5cbANFfZa+AWcTdGzzS72qky8L3apsR1RsWE/UQgVHaLb/MwGds/x3C4lbQtG9zHWHSI6qVGW24nvS4p47CDbZOfd1K1Jc8DrChnlnl3Dhh52Ns4rI/xMupu6N/rSdsVw+uRoB4WpzWs7O7YXbvE/nLsrhewAz1iJeG5HSjFWdJvsbLXtAV3Xc0AEvBKIiI2jaildC4Tao3mblACm4OolysNKlWTuNCjQQZTdXDk9eG4cY+45kqgND82oO8l+cxKPLQfV1bJxsyOSqhvEei1RMFCF7fiLh632ZkjVBSBqy+2ejTe+D8BU9TyV0davgY01v+urfz+058/7vT7/BqcfXWi69CYgv7rC+5DWzGaXo6afKCoW93H/uYRmpdGHTPD1iYQa/bMQA7Ou6LDLR1u7WLZBYhi+Y+ff7n2xW8XUGEHXXQ5dqJqrqN51RWgAned0L//wDC6dDIH65LmBm9w1FegrF7agpaD11uUOZCzeyGosDZBhQGV1vyv/640f3jQV2IGmL16rnusRvFzVKLMpYyYmdcbZxNn3IIvSeDweGxNGmQz+rnm9yrqwKzNSVctml6rzU/CQD8+Naz1f59lBikTpt+BNJg3M8DMKhLC7F7eipRYxwqGfStQ5N7/xdTbrRRWb2VgNQdfFA4RROTCmcbkTiaEjl66eRDSOFQzqFGCV4hGHegclLtZMq0/hXJiFG0Xn53lBLnc5sKDvgTzhnS4OE3RdzrctAxlQ0jL0Nu5OWRDSOPwbm4O0xHg086jjHqB16RnacW2lQFq0RekTYQgTm6wadrcz0BnXvCTXUI7XZUi0XSgAZVzEB7mTlM2hDQ5PsrNIRtCGod6bg4a4QVWDW6ZiA8AAA==";
    private static final Log log = LogFactory.getLog(MetierSeasonInfoSpeciesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected Metier bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JComboBox<MetierSeasonInfo> fieldMetierSeasonInfo;
    protected JCheckBox fieldPrimaryCatch;
    protected JComboBox<Species> fieldTargetSpecies;
    protected MetierSeasonInfoSpeciesHandler handler;
    protected MetierSeasonInfo metierSeasonInfo;
    protected JButton remove;
    protected JButton save;
    protected Species species;
    protected JTable tableTargetSpecies;
    protected InputOneEquationUI targetFactor;
    @Validator( validatorId = "validator")
    protected SwingValidator<MetierSeasonInfo> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MetierSeasonInfoSpeciesUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void resetChangeModel() {
            changeModel.setStayChanged(false);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MetierSeasonInfoSpeciesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI() {
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.add();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.remove();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);changeModel.setStayChanged(false);
    }

    public void doItemStateChanged__on__fieldMetierSeasonInfo(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.metierSeasonInfoChanged();
    }

    public void doItemStateChanged__on__fieldTargetSpecies(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.speciesChanged();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        remove.setEnabled(tableTargetSpecies.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public Metier getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JComboBox<MetierSeasonInfo> getFieldMetierSeasonInfo() {
        return fieldMetierSeasonInfo;
    }

    public JCheckBox getFieldPrimaryCatch() {
        return fieldPrimaryCatch;
    }

    public JComboBox<Species> getFieldTargetSpecies() {
        return fieldTargetSpecies;
    }

    public MetierSeasonInfoSpeciesHandler getHandler() {
        return handler;
    }

    public MetierSeasonInfo getMetierSeasonInfo() {
        return metierSeasonInfo;
    }

    public JButton getRemove() {
        return remove;
    }

    public JButton getSave() {
        return save;
    }

    public Species getSpecies() {
        return species;
    }

    public JTable getTableTargetSpecies() {
        return tableTargetSpecies;
    }

    public InputOneEquationUI getTargetFactor() {
        return targetFactor;
    }

    public SwingValidator<MetierSeasonInfo> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Metier bean) {
        Metier oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {
        MetierSeasonInfo oldValue = this.metierSeasonInfo;
        this.metierSeasonInfo = metierSeasonInfo;
        firePropertyChange(PROPERTY_METIER_SEASON_INFO, oldValue, metierSeasonInfo);
    }

    public void setSpecies(Species species) {
        Species oldValue = this.species;
        this.species = species;
        firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setText(t("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createFieldMetierSeasonInfo() {
        $objectMap.put("fieldMetierSeasonInfo", fieldMetierSeasonInfo = new JComboBox<MetierSeasonInfo>());
        
        fieldMetierSeasonInfo.setName("fieldMetierSeasonInfo");
        fieldMetierSeasonInfo.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldMetierSeasonInfo"));
    }

    protected void createFieldPrimaryCatch() {
        $objectMap.put("fieldPrimaryCatch", fieldPrimaryCatch = new JCheckBox());
        
        fieldPrimaryCatch.setName("fieldPrimaryCatch");
        fieldPrimaryCatch.setText(t("isisfish.metierSeasonInfoSpecies.mainSpecies"));
    }

    protected void createFieldTargetSpecies() {
        $objectMap.put("fieldTargetSpecies", fieldTargetSpecies = new JComboBox<Species>());
        
        fieldTargetSpecies.setName("fieldTargetSpecies");
        fieldTargetSpecies.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldTargetSpecies"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new MetierSeasonInfoSpeciesHandler(this));
    }

    protected void createMetierSeasonInfo() {
        $objectMap.put("metierSeasonInfo", metierSeasonInfo = null);
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setEnabled(false);
        remove.setText(t("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSpecies() {
        $objectMap.put("species", species = null);
    }

    protected void createTableTargetSpecies() {
        $objectMap.put("tableTargetSpecies", tableTargetSpecies = new JTable());
        
        tableTargetSpecies.setName("tableTargetSpecies");
        tableTargetSpecies.setRowHeight(24);
    }

    protected void createTargetFactor() {
        $objectMap.put("targetFactor", targetFactor = new InputOneEquationUI(this));
        
        targetFactor.setName("targetFactor");
        targetFactor.setFormuleCategory("TargetFactor");
        targetFactor.setText(t("isisfish.metierSeasonInfoSpecies.targetFactor"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(MetierSeasonInfo.class, "metier"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldMetierSeasonInfo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer($JLabel1), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldTargetSpecies), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(targetFactor), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel0, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPrimaryCatch), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(add), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(tableTargetSpecies));
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        fieldMetierSeasonInfo.setRenderer(new MetierSeasonInfoComboRenderer());
        targetFactor.setClazz(fr.ifremer.isisfish.equation.TargetSpeciesTargetFactorEquation.class);
        $JScrollPane0.setMinimumSize(new Dimension(0,0));
        $JScrollPane0.setPreferredSize(new Dimension(0,0));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createMetierSeasonInfo();
        createSpecies();
        createHandler();
        createValidator();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.metierSeasonInfoSpecies.selectSeason"));
        createFieldMetierSeasonInfo();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.metierSeasonInfoSpecies.selectSpecies"));
        createFieldTargetSpecies();
        createTargetFactor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createFieldPrimaryCatch();
        createAdd();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTableTargetSpecies();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = tableTargetSpecies.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createRemove();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getMetierSeasonInfo());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    changeModel.setChanged(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    changeModel.setValid(validator.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_METIER_SEASON_INFO_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("active", this);
                addPropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    fieldMetierSeasonInfo.setEnabled(isActive() && (isSensitivity() || !changeModel.isChanged() ) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("active", this);
                removePropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TARGET_SPECIES_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldTargetSpecies.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TARGET_FACTOR_ACTIVE, true ,"active" ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                targetFactor.setActive(isActive() && getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TARGET_FACTOR_BEAN, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                targetFactor.setBean(getMetierSeasonInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_PRIMARY_CATCH_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPrimaryCatch.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_ENABLED, true ,"metierSeasonInfo" ,"species") {
        
            @Override
            public void processDataBinding() {
                add.setEnabled(getMetierSeasonInfo() != null && getSpecies() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TABLE_TARGET_SPECIES_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                tableTargetSpecies.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}