/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.simulator.SimulationProperties;
import fr.ifremer.isisfish.ui.widget.filter.DateInterval;
import fr.ifremer.isisfish.ui.widget.filter.FilterParamModel;
import fr.ifremer.isisfish.ui.widget.filter.ValueGetter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public enum SimulationMeta implements ValueGetter<SimulationProperties, Object>
{
    isisFishVersion(String.class),
    description(String.class),
    simulationName(String.class),
    simulatorName(String.class),
    simulationPlanName(String.class),
    regionName(String.class),
    otherInfo(String.class),
    numberOfYear(Integer.class),
    simulationPlanNumber(Integer.class),
    simulationInterval((Class)DateInterval.class){

        @Override
        public DateInterval getValue(SimulationProperties sim) {
            return new DateInterval(simulationStart.getDateValue(sim), simulationEnd.getDateValue(sim));
        }
    }
    ,
    simulationStart(Long.class),
    simulationEnd(Long.class),
    exportTime(Long.class),
    useOptimization(Boolean.class),
    useSimulationPlan(Boolean.class),
    useStatistic(Boolean.class),
    usePreScript(Boolean.class),
    onlyExport(Boolean.class),
    local(Boolean.class);

    private static final Log log;
    private static final SimpleDateFormat dateFormat;
    private final Class<?> klazz;

    private SimulationMeta(Class<?> klazz) {
        this.klazz = klazz;
    }

    public FilterParamModel<SimulationProperties, ?> createParamModel() {
        return new FilterParamModel<SimulationProperties, Object>(this.name(), this.getKlazz(), this);
    }

    public Class<?> getKlazz() {
        return this.klazz;
    }

    @Override
    public Object getValue(SimulationProperties sim) {
        return sim.getData().getProperty(this.name());
    }

    public long getDateValue(SimulationProperties sim) {
        Date result;
        block3: {
            String d = (String)this.getValue(sim);
            result = null;
            if (d != null) {
                try {
                    result = dateFormat.parse(d);
                }
                catch (ParseException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n.t((String)"isisfish.error.parse.date", (Object[])new Object[]{d}), (Throwable)eee);
                }
            }
        }
        return result == null ? -1L : result.getTime();
    }

    static {
        log = LogFactory.getLog(SimulationMeta.class);
        dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    }
}

