/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectiveStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(ObjectiveStorage.class);
    public static final String OBJECTIVE_PATH = "objectives";
    public static final String OBJECTIVE_TEMPLATE = "templates/script/objective.ftl";
    private static Map<String, ObjectiveStorage> objectiveCache = new ReferenceMap();

    protected ObjectiveStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getObjectiveDirectory() {
        File result = new File(ObjectiveStorage.getContextDatabaseDirectory(), OBJECTIVE_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityObjectiveDirectory() {
        File result = new File(ObjectiveStorage.getCommunityDatabaseDirectory(), OBJECTIVE_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getObjectiveNames() {
        List<String> rules = ObjectiveStorage.getStorageNames(ObjectiveStorage.getObjectiveDirectory());
        rules.addAll(ObjectiveStorage.getStorageNames(ObjectiveStorage.getCommunityObjectiveDirectory()));
        return rules;
    }

    public static ObjectiveStorage getObjective(String name, CodeSourceStorage.Location ... location) {
        ObjectiveStorage result = objectiveCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location[] locs = ObjectiveStorage.nonEmptyLocation(location);
            for (int i = 0; i < locs.length && result == null; ++i) {
                CodeSourceStorage.Location loc = locs[i];
                for (File dir : loc.getDirectories()) {
                    ObjectiveStorage storage = new ObjectiveStorage(dir, new File(dir, OBJECTIVE_PATH), name);
                    File sFile = storage.getFile();
                    if (!sFile.isFile()) continue;
                    result = storage;
                    objectiveCache.put(name, result);
                }
            }
        }
        return result;
    }

    public static ObjectiveStorage createObjective(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        ObjectiveStorage storage = new ObjectiveStorage(dir, new File(dir, OBJECTIVE_PATH), name);
        return storage;
    }

    public static void checkout() throws VCSException {
        ObjectiveStorage.checkout(IsisFish.config.getDatabaseDirectory(), OBJECTIVE_PATH);
    }

    public static List<String> getNewObjectiveNames() {
        List<String> result = ObjectiveStorage.getObjectiveNames();
        result.removeAll(ObjectiveStorage.getRemoteObjectiveNames());
        return result;
    }

    public static List<String> getRemoteObjectiveNames() {
        File dir = ObjectiveStorage.getObjectiveDirectory();
        return ObjectiveStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteObjectiveNames() {
        List<String> result = ObjectiveStorage.getRemoteObjectiveNames();
        result.removeAll(ObjectiveStorage.getObjectiveNames());
        return result;
    }
}

