/*
 * Decompiled with CFR 0.152.
 */
package sensitivityanalysis;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.AbstractSensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.util.List;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.types.RDataFrame;

public class RandomLHS
extends AbstractSensitivityAnalysis {
    @Doc(value="Simulation number (default=10)")
    public int param_simulationNumber = 10;
    @Doc(value="True to be able to modify the code sent to R")
    public boolean param_modifR = false;

    public boolean canManageCardinality() {
        return true;
    }

    public SensitivityScenarios compute(DesignPlan plan, File outputDirectory) throws SensitivityException {
        this.setIsisFactorsR(plan, outputDirectory);
        int factorNumber = plan.getFactors().size();
        SensitivityScenarios thisExperiment = new SensitivityScenarios();
        List thisExperimentScenarios = thisExperiment.getScenarios();
        List factors = plan.getFactors();
        this.checkAllFactorContinuous(factors);
        try {
            Factor factor;
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("library(lhs)");
            String rInstruction = "isis.methodAnalyse<-randomLHS(%s,%s)";
            String rCall = String.format(rInstruction, this.param_simulationNumber, factorNumber);
            if (this.param_modifR) {
                rCall = this.editRInstruction(rCall);
            }
            engine.voidEval(rCall);
            engine.eval("expPlan<-as.data.frame(isis.methodAnalyse)");
            RDataFrame dataFrame = (RDataFrame)engine.eval("expPlan");
            dataFrame.setVariable("expPlan");
            int j = 0;
            while (j < this.param_simulationNumber) {
                Scenario experimentScenario = new Scenario();
                int i = 0;
                while (i < factorNumber) {
                    factor = (Factor)plan.getFactors().get(i);
                    factor.setValueForIdentifier(dataFrame.get(i, j));
                    experimentScenario.addFactor(factor);
                    ++i;
                }
                thisExperimentScenarios.add(experimentScenario);
                thisExperiment.setScenarios(thisExperimentScenarios);
                ++j;
            }
            engine.voidEval(this.getIsisFactorDistribution(factors));
            engine.voidEval("call<-\"isis.methodAnalyse<-randomLHS(" + this.param_simulationNumber + "," + factorNumber + ")\"");
            engine.voidEval("isis.methodExp<-list(\"isis.factors\"=isis.factors,\"isis.factor.distribution\"=isis.factor.distribution,\"call\"=call)");
            engine.voidEval("attr(isis.methodExp,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("isis.simule<-data.frame(isis.methodAnalyse)");
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("names(isis.simule)<-isis.factors[[1]]");
            String data = "data<-data.frame(";
            int j2 = 0;
            while (j2 < factors.size()) {
                Scenario firstScenario = (Scenario)thisExperimentScenarios.get(0);
                factor = (Factor)firstScenario.getFactors().get(j2);
                String factorName = factor.getName().replaceAll(" ", "");
                String vector = String.valueOf(factorName) + "<-c(";
                int i = 0;
                while (i < this.param_simulationNumber) {
                    Scenario scenario = (Scenario)thisExperimentScenarios.get(i);
                    List factorList = scenario.getFactors();
                    Factor factor1 = (Factor)factorList.get(j2);
                    vector = i < this.param_simulationNumber - 1 ? String.valueOf(vector) + factor1.getDisplayedValue() + "," : String.valueOf(vector) + factor1.getDisplayedValue();
                    ++i;
                }
                vector = String.valueOf(vector) + ")";
                engine.voidEval(vector);
                data = j2 < factors.size() - 1 ? String.valueOf(data) + factorName + "=factor(" + factorName + ")," : String.valueOf(data) + factorName + "=factor(" + factorName + "))";
                ++j2;
            }
            engine.voidEval(data);
            rInstruction = "factornames<-c(";
            int i = 0;
            while (i < factorNumber) {
                rInstruction = i != factorNumber - 1 ? String.valueOf(rInstruction) + "\"" + ((Factor)factors.get(i)).getName() + "\"," : String.valueOf(rInstruction) + "\"" + ((Factor)factors.get(i)).getName() + "\"";
                ++i;
            }
            rInstruction = String.valueOf(rInstruction) + ")";
            engine.voidEval(rInstruction);
            for (Factor factor2 : factors) {
                String factorName = factor2.getName().replaceAll(" ", "");
                engine.remove(factorName);
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't generate scenarios", (Throwable)e);
        }
        return thisExperiment;
    }

    public void analyzeResult(List<SimulationStorage> simulationStorages, File outputDirectory) throws SensitivityException {
        SimulationStorage simulationStorage1 = simulationStorages.get(0);
        String simulationName = outputDirectory.getName().replaceAll("-", "");
        SimulationParameter param = simulationStorage1.getParameter();
        int sensitivityNumber = param.getSensitivityExport().size();
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("factors<-data.frame(isis.methodAnalyse)");
            int factorNumber = (Integer)engine.eval("length(factors)");
            this.param_simulationNumber = (Integer)engine.eval("length(factors[,1])");
            int k = 0;
            while (k < sensitivityNumber) {
                SensitivityExport sensitivityExport = (SensitivityExport)param.getSensitivityExport().get(k);
                String rInstruction = this.createImportInstruction(sensitivityExport, simulationStorages);
                engine.voidEval(rInstruction);
                engine.voidEval("isis.simule<-data.frame(isis.simule," + sensitivityExport.getExportFilename() + ")");
                ++k;
            }
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("attr(isis.simule,\"call\")<-isis.methodExp$call");
            k = 0;
            while (k < sensitivityNumber) {
                String name = ((SensitivityExport)param.getSensitivityExport().get(k)).getExportFilename();
                String dataframe = "dataforaov<-data.frame(factors," + name + "=" + name + ")";
                engine.voidEval(dataframe);
                String aovCall = "aovresult<-aov(" + name + "~";
                int j = 0;
                while (j < factorNumber) {
                    aovCall = j < factorNumber - 1 ? String.valueOf(aovCall) + engine.eval("names(factors)[" + (j + 1) + "]") + "+" : String.valueOf(aovCall) + engine.eval("names(factors)[" + (j + 1) + "]") + ",data=dataforaov)";
                    ++j;
                }
                engine.voidEval(aovCall);
                engine.voidEval("SoS<-summary(aovresult)[[1]][1:dim(summary(aovresult)[[1]])[1],2]");
                engine.voidEval("names(SoS)<-dimnames(summary(aovresult)[[1]])[[1]][1:dim(summary(aovresult)[[1]])[1]]");
                engine.voidEval("IndSensibilite<-SoS/sum(SoS)");
                engine.voidEval("exportsensitivity<-data.frame(SoS[1:dim(summary(aovresult)[[1]])[1]],IndSensibilite[1:dim(summary(aovresult)[[1]])[1]])");
                engine.voidEval("names(exportsensitivity)<-c(\"Sum Of Squares\",\"Sensitivity indices\")");
                engine.voidEval("row.names(exportsensitivity)<-dimnames(summary(aovresult)[[1]])[1][[1]][1:dim(summary(aovresult)[[1]])[1]]");
                engine.voidEval("resultsnames<-c(isis.factor.distribution$NomFacteur,\"Result\")");
                engine.voidEval("names(dataforaov)<-resultsnames");
                engine.setwd(outputDirectory);
                engine.voidEval("write.csv(dataforaov,\"" + ((SensitivityExport)param.getSensitivityExport().get(k)).getExportFilename() + "_Results.csv\")");
                engine.voidEval("write.csv(exportsensitivity,\"" + ((SensitivityExport)param.getSensitivityExport().get(k)).getExportFilename() + "_SensitivityIndices.csv\")");
                String exportMethodAnalyse = String.format("%s.isis.methodAnalyse", String.valueOf(simulationName) + "." + name);
                engine.voidEval(String.valueOf(exportMethodAnalyse) + "<-list(" + "\"isis.factors\"=isis.factors," + "\"isis.factor.distribution\"=isis.factor.distribution," + "\"isis.simule\"=isis.simule," + "call_method=\"" + aovCall + "\"," + "\"analysis_result\"=list(aovresult,IndSensibilite))");
                engine.voidEval("attr(" + exportMethodAnalyse + "," + "\"nomModel\")<-\"isis-fish-externe-R\"");
                ++k;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't evaluate results", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Implementation of Random Latin Hypercube method method using R needs the 'lhs' package to work)";
    }
}

