/*
 * Decompiled with CFR 0.152.
 */
package scripts;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneDAO;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import scripts.MinimisationUtil;
import scripts.ObjectiveFunctionBaranov;
import scripts.ResultName;

public class SiMatrix {
    private static Log log = LogFactory.getLog(SiMatrix.class);
    protected SimulationContext context = null;
    protected TopiaContext db = null;

    public static SiMatrix getSiMatrix(SimulationContext context) throws TopiaException {
        SiMatrix result = (SiMatrix)context.getValue(SiMatrix.class.getName());
        if (result == null) {
            result = new SiMatrix(context);
        }
        return result;
    }

    private static void setSiMatrix(SimulationContext context, SiMatrix siMatrix) {
        context.setValue(SiMatrix.class.getName(), (Object)siMatrix);
    }

    public SiMatrix(SimulationContext context) throws TopiaException {
        this.context = context;
        this.db = context.getDB();
        SiMatrix.setSiMatrix(context, this);
    }

    public List<Zone> getZones(TimeStep step) throws TopiaException {
        ZoneDAO dao = IsisFishDAOHelper.getZoneDAO((TopiaContext)this.db);
        List result = dao.findAll();
        return result;
    }

    public List<Population> getPopulations(TimeStep step) throws TopiaException {
        ArrayList<Population> populations = new ArrayList<Population>();
        for (Population pop : this.context.getSimulationStorage().getParameter().getPopulations()) {
            Population tmp = (Population)this.db.findByTopiaId(pop.getTopiaId());
            populations.add(tmp);
        }
        return populations;
    }

    public List<Strategy> getStrategies(TimeStep step) throws TopiaException {
        ArrayList<Strategy> strategies = new ArrayList<Strategy>();
        for (Strategy str : this.context.getSimulationStorage().getParameter().getStrategies()) {
            Strategy tmp = (Strategy)this.db.findByTopiaId(str.getTopiaId());
            strategies.add(tmp);
        }
        return strategies;
    }

    public List<Metier> getMetiers(TimeStep step) throws TopiaException {
        ArrayList<Metier> metiers = new ArrayList<Metier>();
        HashSet<Metier> tmp = new HashSet<Metier>();
        for (Strategy str : this.getStrategies(step)) {
            SetOfVessels sov = str.getSetOfVessels();
            for (EffortDescription effort : sov.getPossibleMetiers()) {
                Metier metier = effort.getPossibleMetiers();
                if (!tmp.add(metier)) continue;
                metiers.add(metier);
            }
        }
        return metiers;
    }

    public List<Metier> getMetiers(Strategy str, TimeStep step) {
        StrategyMonthInfo info = str.getStrategyMonthInfo(step.getMonth());
        MatrixND props = info.getProportionMetier();
        ArrayList<Metier> result = new ArrayList<Metier>();
        MatrixIterator i = props.iterator();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() == 0.0) continue;
            Metier metier = (Metier)i.getSemanticsCoordinates()[0];
            result.add(metier);
        }
        return result;
    }

    public MatrixND getMetierZone(TimeStep step) throws TopiaException {
        List<Metier> metiers = this.getMetiers(step);
        List<Zone> zones = this.getZones(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_METIER_ZONE, new List[]{metiers, zones}, new String[]{I18n.n((String)"Metiers", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        for (Metier metier : metiers) {
            Collection zoneMetier = metier.getMetierSeasonInfo(step.getMonth()).getZone();
            for (Zone zone : zoneMetier) {
                result.setValue((Object)metier, (Object)zone, 1.0);
            }
        }
        return result;
    }

    public MatrixND matrixPrice(TimeStep step, Population pop) {
        List groups = pop.getPopulationGroup();
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_PRICE, new List[]{groups}, new String[]{I18n.n((String)"PopulationGroup", (Object[])new Object[0])});
        for (PopulationGroup group : groups) {
            result.setValue((Object)group, group.getPrice());
        }
        return result;
    }

    public MatrixND matrixCatchWeightPerStrategyMetPerZoneMet(TimeStep step, Population pop, MatrixND matrixCatchPerStrategyMetPerZoneMet) throws TopiaException, IsisFishException {
        List groups = pop.getPopulationGroup();
        MatrixND result = matrixCatchPerStrategyMetPerZoneMet.copy();
        result.setName(ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_MET);
        for (PopulationGroup group : groups) {
            MatrixND sub = result.getSubMatrix(2, (Object)group, 1);
            double meanWeight = group.getMeanWeight();
            sub.mults(meanWeight);
        }
        return result;
    }

    public MatrixND matrixCatchPerStrategyMetPerZoneMet(MatrixND N, Population pop, TimeStep step) throws TopiaException, IsisFishException {
        MatrixND matrixFishingMortalityPerCell = this.matrixFishingMortalityPerCell(step, pop);
        MatrixND matrixCatchRatePerStrategyMetPerCell = this.matrixCatchRatePerStrategyMetPerCell(pop, step, matrixFishingMortalityPerCell);
        MatrixND matrixCatchPerStrategyMetPerCell = this.matrixCatchPerStrategyMetPerCell(N, pop, step, matrixCatchRatePerStrategyMetPerCell);
        List<Strategy> strategies = this.getStrategies(step);
        List<Metier> metiers = this.getMetiers(step);
        List groups = matrixCatchPerStrategyMetPerCell.getSemantic(2);
        List<Zone> zones = this.getZones(step);
        HashSet cellPops = new HashSet(matrixCatchPerStrategyMetPerCell.getSemantic(4));
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_CATCH_PER_STRATEGY_MET_PER_ZONE_MET, new List[]{strategies, metiers, groups, zones}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0]), I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        MatrixND tmp = matrixCatchPerStrategyMetPerCell.sumOverDim(3);
        tmp = tmp.reduceDims(new int[]{3});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            int g = 0;
            while (g < groups.size()) {
                PopulationGroup group = (PopulationGroup)groups.get(g);
                int m = 0;
                while (m < metiers.size()) {
                    Metier metier = metiers.get(m);
                    MetierSeasonInfo infoMet = metier.getMetierSeasonInfo(step.getMonth());
                    Collection zoneMet = infoMet.getZone();
                    for (Zone z : zoneMet) {
                        double value = 0.0;
                        List cells = z.getCell();
                        int c = 0;
                        while (c < cells.size()) {
                            Cell cell = (Cell)cells.get(c);
                            if (cellPops.contains(cell)) {
                                value += tmp.getValue((Object)str, (Object)metier, (Object)group, (Object)cell);
                            }
                            ++c;
                        }
                        result.setValue((Object)str, (Object)metier, (Object)group, (Object)z, value);
                    }
                    ++m;
                }
                ++g;
            }
            ++s;
        }
        return result;
    }

    public MatrixND matrixCatchPerStrategyMetPerZonePop(MatrixND N, Population pop, TimeStep step) throws TopiaException, IsisFishException {
        MatrixND matrixFishingMortalityPerCell = this.matrixFishingMortalityPerCell(step, pop);
        MatrixND matrixCatchRatePerStrategyMetPerCell = this.matrixCatchRatePerStrategyMetPerCell(pop, step, matrixFishingMortalityPerCell);
        MatrixND matrixCatchPerStrategyMetPerCell = this.matrixCatchPerStrategyMetPerCell(N, pop, step, matrixCatchRatePerStrategyMetPerCell);
        MatrixND result = matrixCatchPerStrategyMetPerCell.sumOverDim(4);
        result = result.reduceDims(new int[]{4});
        result.setName(ResultName.MATRIX_CATCH_PER_STRATEGY_MET_PER_ZONE_POP);
        return result;
    }

    public MatrixND matrixCatchWeightPerStrategyMetPerZonePop(TimeStep step, Population pop, MatrixND matrixCatchPerStrategyMetPerZonePop) throws TopiaException, IsisFishException {
        List groups = pop.getPopulationGroup();
        MatrixND result = matrixCatchPerStrategyMetPerZonePop.copy();
        result.setName(ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP);
        for (PopulationGroup group : groups) {
            MatrixND sub = result.getSubMatrix(2, (Object)group, 1);
            double meanWeight = group.getMeanWeight();
            sub.mults(meanWeight);
        }
        return result;
    }

    public MatrixND matrixCatchPerStrategyMetPerZone(MatrixND N, Population pop, TimeStep step, MatrixND matrixCatchRatePerStrategyMet) throws TopiaException, IsisFishException {
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        MatrixND result = matrixCatchRatePerStrategyMet.copy();
        result.setName(ResultName.MATRIX_CATCH_PER_STRATEGY_MET_PER_ZONE_POP);
        for (PopulationGroup group : groups) {
            MatrixND sub = result.getSubMatrix(2, (Object)group, 1);
            for (Zone zone : zones) {
                MatrixND subsub = sub.getSubMatrix(3, (Object)zone, 1);
                double val = N.getValue((Object)group, (Object)zone);
                subsub.mults(val);
            }
        }
        return result;
    }

    public MatrixND matrixCatchRatePerStrategyMetPerZone(Population pop, TimeStep step, MatrixND matrixFishingMortality) throws TopiaException, IsisFishException {
        List<Strategy> strategies = this.getStrategies(step);
        List<Metier> metiers = this.getMetiers(step);
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_CATCH_RATE_PER_STRATEGY_MET_PER_ZONE_POP, new List[]{strategies, metiers, groups, zones}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0]), I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                int z = 0;
                while (z < zones.size()) {
                    Zone zone = (Zone)zones.get(z);
                    double effort = this.effortPerZonePop(str, metier, step, zone);
                    if (effort > 0.0) {
                        int g = 0;
                        while (g < groups.size()) {
                            PopulationGroup group = (PopulationGroup)groups.get(g);
                            double value = this.catchRatePerStrategyMet(str, metier, step, group, zone, matrixFishingMortality);
                            result.setValue((Object)str, (Object)metier, (Object)group, (Object)zone, value);
                            ++g;
                        }
                    }
                    ++z;
                }
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double effortPerZonePop(Strategy str, Metier metier, TimeStep step, Zone zonePop) {
        Month month = step.getMonth();
        Collection zoneMet = metier.getMetierSeasonInfo(month).getZone();
        double inter = this.nbCellInter(zoneMet, zonePop);
        double effortPerStrategyPerCell = this.effortPerStrategyPerCell(str, metier, step);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" strategy=" + str + " metier=" + metier + " inter=" + inter + " effortPerStrategyPerCell=" + effortPerStrategyPerCell));
        }
        double result = effortPerStrategyPerCell * inter;
        return result;
    }

    private double catchRatePerStrategyMet(Strategy str, Metier metier, TimeStep step, PopulationGroup group, Zone zone, MatrixND matrixFishingMortality) throws TopiaException, IsisFishException {
        double totalFishingMortality = this.totalFishingMortality(step, matrixFishingMortality).getValue((Object)group, (Object)zone);
        if (totalFishingMortality == 0.0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("pas de totalFishingMortality pour (" + group + ", " + zone + ")"));
            }
            return 0.0;
        }
        double fishingMortality = matrixFishingMortality.getValue((Object)str, (Object)metier, (Object)group, (Object)zone);
        double totalCatchRate = this.totalCatchRate(step, group, zone, totalFishingMortality);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" totalFishingMortality=" + totalFishingMortality + " fishingMortality=" + fishingMortality + " totalCatchRate=" + totalCatchRate));
        }
        double result = fishingMortality / totalFishingMortality * totalCatchRate;
        return result;
    }

    private double totalCatchRate(TimeStep step, PopulationGroup group, Zone zone, double totalFishingMortality) throws TopiaException {
        double M = group.getNaturalDeathRate(zone) / (double)Month.NUMBER_OF_MONTH;
        if (M == 0.0 && log.isWarnEnabled()) {
            log.warn((Object)("Pas de mortalite naturelle pour: " + group));
        }
        double F = totalFishingMortality;
        double result = 0.0;
        if (M != 0.0 || F != 0.0) {
            result = F / (F + M) * (1.0 - Math.exp(-(F + M)));
        }
        return result;
    }

    private MatrixND totalFishingMortality(TimeStep step, MatrixND matrixFishingMortality) {
        MatrixND result = matrixFishingMortality.sumOverDim(0);
        result = result.sumOverDim(1);
        result = result.reduceDims(new int[]{0, 1});
        return result;
    }

    public MatrixND matrixFishingMortality(TimeStep step, Population pop) throws TopiaException, IsisFishException {
        List<Strategy> strategies = this.getStrategies(step);
        List<Metier> metiers = this.getMetiers(step);
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_FISHING_MORTALITY, new List[]{strategies, metiers, groups, zones}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0]), I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        Month month = step.getMonth();
        PopulationSeasonInfo infoPop = pop.getPopulationSeasonInfo(month);
        int g = 0;
        while (g < groups.size()) {
            PopulationGroup group = (PopulationGroup)groups.get(g);
            double capturability = infoPop.getCapturability(group);
            if (capturability != 0.0) {
                int m = 0;
                while (m < metiers.size()) {
                    double coeff;
                    Gear gear;
                    Selectivity selectivity;
                    Metier metier = metiers.get(m);
                    MetierSeasonInfo infoMet = metier.getMetierSeasonInfo(month);
                    double ciblage = infoMet.getTargetFactor(group);
                    if (ciblage != 0.0 && (selectivity = (gear = metier.getGear()).getPopulationSelectivity(pop)) != null && (coeff = selectivity.getCoefficient(pop, group, metier)) != 0.0) {
                        int s = 0;
                        while (s < strategies.size()) {
                            Strategy str = strategies.get(s);
                            int z = 0;
                            while (z < zones.size()) {
                                Zone zone = (Zone)zones.get(z);
                                double effort = this.effortPerZonePop(str, metier, step, zone);
                                if (effort > 0.0) {
                                    double value = coeff * capturability * ciblage * effort;
                                    result.setValue((Object)str, (Object)metier, (Object)group, (Object)zone, value);
                                }
                                ++z;
                            }
                            ++s;
                        }
                    }
                    ++m;
                }
            }
            ++g;
        }
        return result;
    }

    private MatrixND matrixCatchPerStrategyMetPerCell(MatrixND N, Population pop, TimeStep step, MatrixND matrixCatchRatePerStrategyMetPerCell) throws TopiaException, IsisFishException {
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        MatrixND result = matrixCatchRatePerStrategyMetPerCell.copy();
        result.setName("matrixCatchPerStrategyMetPerCell");
        for (PopulationGroup group : groups) {
            MatrixND sub = result.getSubMatrix(2, (Object)group, 1);
            for (Zone zone : zones) {
                MatrixND subsub = sub.getSubMatrix(3, (Object)zone, 1);
                double val = N.getValue((Object)group, (Object)zone) / (double)zone.sizeCell();
                subsub.mults(val);
            }
        }
        return result;
    }

    private MatrixND matrixCatchRatePerStrategyMetPerCell(Population pop, TimeStep step, MatrixND matrixFishingMortalityPerCell) throws TopiaException, IsisFishException {
        List<Strategy> strategies = this.getStrategies(step);
        List<Metier> metiers = this.getMetiers(step);
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        List<Cell> cells = this.getCells(zones);
        MatrixND result = MatrixFactory.getInstance().create("matrixCatchRatePerStrategyMetPerCell", new List[]{strategies, metiers, groups, zones, cells}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0]), I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0]), I18n.n((String)"Cells", (Object[])new Object[0])});
        MatrixND matrixFishingMortalityPerCellSumOverGroup = matrixFishingMortalityPerCell.sumOverDim(2);
        matrixFishingMortalityPerCellSumOverGroup = matrixFishingMortalityPerCellSumOverGroup.reduceDims(new int[]{2});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                int z = 0;
                while (z < zones.size()) {
                    Zone zone = (Zone)zones.get(z);
                    List cellZones = zone.getCell();
                    int c = 0;
                    while (c < cellZones.size()) {
                        Cell cell = (Cell)cellZones.get(c);
                        double effort = matrixFishingMortalityPerCellSumOverGroup.getValue((Object)str, (Object)metier, (Object)zone, (Object)cell);
                        if (effort > 0.0) {
                            int g = 0;
                            while (g < groups.size()) {
                                PopulationGroup group = (PopulationGroup)groups.get(g);
                                double value = this.catchRatePerStrategyMetPerCell(str, metier, step, group, zone, cell, matrixFishingMortalityPerCell);
                                result.setValue(new Object[]{str, metier, group, zone, cell}, value);
                                ++g;
                            }
                        }
                        ++c;
                    }
                    ++z;
                }
                ++m;
            }
            ++s;
        }
        return result;
    }

    private double catchRatePerStrategyMetPerCell(Strategy str, Metier metier, TimeStep step, PopulationGroup group, Zone zone, Cell cell, MatrixND matrixFishingMortalityPerCell) throws TopiaException, IsisFishException {
        MatrixND totalFishingMortalityPerCell = this.totalFishingMortalityPerCell(step, matrixFishingMortalityPerCell);
        double totalFishingMortality = totalFishingMortalityPerCell.getValue((Object)group, (Object)zone, (Object)cell);
        if (totalFishingMortality == 0.0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("pas de totalFishingMortality pour (" + group + ", " + zone + ")"));
            }
            return 0.0;
        }
        double fishingMortalityPerCell = matrixFishingMortalityPerCell.getValue(new Object[]{str, metier, group, zone, cell});
        double totalCatchRatePerCell = this.totalCatchRatePerCell(step, group, zone, totalFishingMortality);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" totalFishingMortality=" + totalFishingMortality + " fishingMortality=" + fishingMortalityPerCell + " totalCatchRate=" + totalCatchRatePerCell));
        }
        double result = fishingMortalityPerCell / totalFishingMortality * totalCatchRatePerCell;
        return result;
    }

    private double totalCatchRatePerCell(TimeStep step, PopulationGroup group, Zone zone, double totalFishingMortalityPerCell) throws TopiaException {
        double M = group.getNaturalDeathRate(zone) / (double)Month.NUMBER_OF_MONTH;
        if (M == 0.0 && log.isWarnEnabled()) {
            log.warn((Object)("Pas de mortalite naturelle pour: " + group));
        }
        double F = totalFishingMortalityPerCell;
        double result = 0.0;
        if (M != 0.0 || F != 0.0) {
            result = F / (F + M) * (1.0 - Math.exp(-(F + M)));
        }
        return result;
    }

    private MatrixND totalFishingMortalityPerCell(TimeStep step, MatrixND matrixFishingMortalityPerCell) {
        MatrixND result = matrixFishingMortalityPerCell.sumOverDim(0);
        result = result.sumOverDim(1);
        result = result.reduceDims(new int[]{0, 1});
        return result;
    }

    public MatrixND matrixFishingMortalityPerCell(TimeStep step, Population pop) throws TopiaException, IsisFishException {
        List<Strategy> strategies = this.getStrategies(step);
        List<Metier> metiers = this.getMetiers(step);
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        List<Cell> cells = this.getCells(zones);
        MatrixND result = MatrixFactory.getInstance().create("matrixFishingMortalityPerCell", new List[]{strategies, metiers, groups, zones, cells}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0]), I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0]), I18n.n((String)"Cells", (Object[])new Object[0])});
        Month month = step.getMonth();
        PopulationSeasonInfo infoPop = pop.getPopulationSeasonInfo(month);
        int g = 0;
        while (g < groups.size()) {
            PopulationGroup group = (PopulationGroup)groups.get(g);
            double capturability = infoPop.getCapturability(group);
            if (capturability != 0.0) {
                int m = 0;
                while (m < metiers.size()) {
                    double coeff;
                    Gear gear;
                    Selectivity selectivity;
                    Metier metier = metiers.get(m);
                    MetierSeasonInfo infoMet = metier.getMetierSeasonInfo(month);
                    double ciblage = infoMet.getTargetFactor(group);
                    if (ciblage != 0.0 && (selectivity = (gear = metier.getGear()).getPopulationSelectivity(pop)) != null && (coeff = selectivity.getCoefficient(pop, group, metier)) != 0.0) {
                        int s = 0;
                        while (s < strategies.size()) {
                            Strategy str = strategies.get(s);
                            double effort = this.effortPerStrategyPerCell(str, metier, step);
                            if (effort > 0.0) {
                                int z = 0;
                                while (z < zones.size()) {
                                    Zone zone = (Zone)zones.get(z);
                                    HashSet cellPops = new HashSet(zone.getCell());
                                    for (Cell cellMet : infoMet.getCells()) {
                                        if (!cellPops.contains(cellMet)) continue;
                                        double value = coeff * capturability * ciblage * effort;
                                        result.setValue(new Object[]{str, metier, group, zone, cellMet}, value);
                                    }
                                    ++z;
                                }
                            }
                            ++s;
                        }
                    }
                    ++m;
                }
            }
            ++g;
        }
        return result;
    }

    private double effortPerStrategyPerCell(Strategy str, Metier metier, TimeStep step) {
        Month month = step.getMonth();
        Collection zones = metier.getMetierSeasonInfo(month).getZone();
        double nbCell = this.getCells(zones).size();
        if (nbCell == 0.0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Calcul d'une distance pour le metier " + metier + " pour le mois " + month + " avec une zone sans maille: " + zones));
            }
            return 0.0;
        }
        double effortPerStrategy = this.effortPerStrategyMet(str, metier, step);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" strategy=" + str + " metier=" + metier + " nbCell=" + nbCell + " effortPerStrategy=" + effortPerStrategy));
        }
        double result = effortPerStrategy / nbCell;
        return result;
    }

    private double effortNominalPerStrategyMet(Strategy str, Metier metier, TimeStep step) {
        Month month = step.getMonth();
        StrategyMonthInfo smi = str.getStrategyMonthInfo(month);
        double propSetOfVessels = str.getProportionSetOfVessels();
        int nbOfVessels = str.getSetOfVessels().getNumberOfVessels();
        double propStrMet = smi.getProportionMetier(metier);
        double effortNominalPerVessel = this.effortNominalPerStrategyPerVessel(str, metier, step);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" strategy=" + str + " metier=" + metier + " propSetOfVessels=" + propSetOfVessels + " nbOfVessels=" + nbOfVessels + " propStrMet=" + propStrMet + " effortPerVessel=" + effortNominalPerVessel));
        }
        double result = propSetOfVessels * (double)nbOfVessels * propStrMet * effortNominalPerVessel;
        return result;
    }

    private double effortNominalPerStrategyPerVessel(Strategy str, Metier metier, TimeStep step) {
        Month month = step.getMonth();
        StrategyMonthInfo smi = str.getStrategyMonthInfo(month);
        double nbTrips = smi.getNumberOfTrips();
        double fishingTime = this.fishingTimePerTrip(str, metier, step);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" strategy=" + str + " metier=" + metier + " nbTrips=" + nbTrips + " fishingTime=" + fishingTime));
        }
        double result = nbTrips * fishingTime;
        return result;
    }

    private double effortPerStrategyMet(Strategy str, Metier metier, TimeStep step) {
        Month month = step.getMonth();
        StrategyMonthInfo smi = str.getStrategyMonthInfo(month);
        double propSetOfVessels = str.getProportionSetOfVessels();
        int nbOfVessels = str.getSetOfVessels().getNumberOfVessels();
        double propStrMet = smi.getProportionMetier(metier);
        double effortPerVessel = this.effortPerStrategyPerVessel(str, metier, step);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" strategy=" + str + " metier=" + metier + " propSetOfVessels=" + propSetOfVessels + " nbOfVessels=" + nbOfVessels + " propStrMet=" + propStrMet + " effortPerVessel=" + effortPerVessel));
        }
        double result = propSetOfVessels * (double)nbOfVessels * propStrMet * effortPerVessel;
        return result;
    }

    private double effortPerStrategyPerVessel(Strategy str, Metier metier, TimeStep step) {
        Month month = step.getMonth();
        StrategyMonthInfo smi = str.getStrategyMonthInfo(month);
        double nbTrips = smi.getNumberOfTrips();
        double fishingTime = this.fishingTimePerTrip(str, metier, step);
        double stdEffortPerHour = this.stdEffortPerHour(step, str.getSetOfVessels(), metier);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" strategy=" + str + " metier=" + metier + " nbTrips=" + nbTrips + " fishingTime=" + fishingTime + " stdEffortPerHour=" + stdEffortPerHour));
        }
        double result = nbTrips * fishingTime * stdEffortPerHour;
        return result;
    }

    protected double fishingTimePerTrip(Strategy str, Metier metier, TimeStep step) {
        double travelTime;
        double tripDuration;
        double result;
        Month month = step.getMonth();
        StrategyMonthInfo smi = str.getStrategyMonthInfo(month);
        Collection zone = metier.getMetierSeasonInfo(month).getZone();
        if (zone == null && log.isWarnEnabled()) {
            log.warn((Object)("missing zone for metier =" + metier + " for month" + month));
        }
        if ((result = (tripDuration = smi.getTripType().getTripDuration().getHour()) - (travelTime = this.travelTimePerTrip(str.getSetOfVessels(), zone))) < 0.0 && log.isWarnEnabled()) {
            log.warn((Object)(" strategy=" + str + " metier=" + metier + " tripDuration=" + tripDuration + " travelTime=" + travelTime));
        }
        return result;
    }

    protected double travelTimePerTrip(SetOfVessels sov, Collection<Zone> zoneMetier) {
        Cell maille = sov.getPort().getCell();
        double result = 2.0 * this.distance(zoneMetier, maille) / sov.getVesselType().getSpeed();
        return result;
    }

    private double distance(Collection<Zone> zones, Cell cell) {
        double result = 0.0;
        List<Cell> cells = this.getCells(zones);
        if (cells.size() == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Calcul d'une distance avec une zone sans maille");
            }
            return 0.0;
        }
        for (Cell c : cells) {
            result += this.distance(c, cell);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" result=" + result + " nbMaille=" + cells.size()));
        }
        return result /= (double)cells.size();
    }

    private double distance(Cell m1, Cell m2) {
        double earthRadius = 6378.388;
        double p = 57.29577951308232;
        if (log.isDebugEnabled()) {
            log.debug((Object)("p: " + p));
        }
        double m1lat = m1.getLatitude();
        double m2lat = m2.getLatitude();
        double m1lon = m1.getLongitude();
        double m2lon = m2.getLongitude();
        if (log.isDebugEnabled()) {
            log.debug((Object)(" m1lat=" + m1lat + " m2lat=" + m2lat + " m1lon=" + m1lon + " m2lonx=" + m2lon));
        }
        double m1lat_div_p = m1lat / p;
        double m2lat_div_p = m2lat / p;
        double m1lon_div_p = m1lon / p;
        double m2lon_div_p = m2lon / p;
        if (log.isDebugEnabled()) {
            log.debug((Object)(" m1lat_div_p=" + m1lat_div_p + " m2lat_div_p=" + m2lat_div_p + " m1lon_div_p=" + m1lon_div_p + " m2lon_div_p=" + m2lon_div_p));
        }
        double sin_m1lat_div_p = Math.sin(m1lat_div_p);
        double sin_m2lat_div_p = Math.sin(m2lat_div_p);
        double cos_m1lat_div_p = Math.cos(m1lat_div_p);
        double cos_m2lat_div_p = Math.cos(m2lat_div_p);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" sin_m1lat_div_p=" + sin_m1lat_div_p + " sin_m2lat_div_p=" + sin_m2lat_div_p + " cos_m1lat_div_p=" + cos_m1lat_div_p + " cos_m2lat_div_p=" + cos_m2lat_div_p));
        }
        double cos_m1lon_div_p_minus_m2lon_div_p = Math.cos(m1lon_div_p - m2lon_div_p);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" cos_m1lon_div_p_minus_m2lon_div_p=" + cos_m1lon_div_p_minus_m2lon_div_p));
        }
        double acos = Math.acos(sin_m1lat_div_p * sin_m2lat_div_p + cos_m1lat_div_p * cos_m2lat_div_p * cos_m1lon_div_p_minus_m2lon_div_p);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" acos=" + acos));
        }
        double result = earthRadius * acos;
        return result;
    }

    private double stdEffortPerHour(TimeStep step, SetOfVessels sov, Metier metier) {
        double result = 0.0;
        EffortDescription ed = sov.getPossibleMetiers(metier);
        if (ed != null) {
            double val;
            double fstd = metier.getGear().getStandardisationFactor();
            double etp = sov.getTechnicalEfficiency(metier);
            result = val = fstd * etp * (double)ed.getFishingOperation() * (double)ed.getGearsNumberPerOperation();
        }
        return result /= 24.0;
    }

    public List<Cell> getCells(Collection<Zone> zones) {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (Zone zone : zones) {
            result.addAll(zone.getCell());
        }
        return result;
    }

    public int nbCellInter(Collection<Zone> zoneMet, Zone zonePop) {
        List<Cell> cells = this.getCells(zoneMet);
        ArrayList<Cell> tmp = new ArrayList<Cell>(cells);
        tmp.retainAll(zonePop.getCell());
        return tmp.size();
    }

    private MatrixND matrixAbundancePerCell(MatrixND N, Population pop, TimeStep step, MatrixND matrixFishingMortality) throws TopiaException, IsisFishException {
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        List<Cell> allCells = this.getCells(zones);
        MatrixND result = MatrixFactory.getInstance().create(String.valueOf(ResultName.MATRIX_ABUNDANCE) + "_PER_CELL", new List[]{groups, zones, allCells}, new String[]{I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0]), I18n.n((String)"Cells", (Object[])new Object[0])});
        int g = 0;
        while (g < groups.size()) {
            PopulationGroup group = (PopulationGroup)groups.get(g);
            int z = 0;
            while (z < zones.size()) {
                Zone zone = (Zone)zones.get(z);
                List cells = zone.getCell();
                int c = 0;
                while (c < cells.size()) {
                    Cell cell = (Cell)cells.get(c);
                    double value = this.survivalRatePerCell(step, group, zone, cell, matrixFishingMortality);
                    double n = N.getValue(g, z) / (double)zone.sizeCell();
                    result.setValue(g, z, c, value *= n);
                    ++c;
                }
                ++z;
            }
            ++g;
        }
        return result;
    }

    public MatrixND matrixAbundance(MatrixND N, Population pop, TimeStep step) throws TopiaException, IsisFishException {
        MatrixND matrixFishingMortalityPerCell = this.matrixFishingMortalityPerCell(step, pop);
        MatrixND result = this.matrixAbundancePerCell(N, pop, step, matrixFishingMortalityPerCell);
        result = result.sumOverDim(2);
        result = result.reduceDims(new int[]{2});
        result.setName(ResultName.MATRIX_ABUNDANCE);
        return result;
    }

    public MatrixND matrixAbundance(MatrixND N, Population pop, TimeStep step, MatrixND matrixFishingMortality) throws TopiaException, IsisFishException {
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_ABUNDANCE, new List[]{groups, zones}, new String[]{I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        int g = 0;
        while (g < groups.size()) {
            PopulationGroup group = (PopulationGroup)groups.get(g);
            int z = 0;
            while (z < zones.size()) {
                Zone zone = (Zone)zones.get(z);
                double value = this.survivalRatePerZone(step, group, zone, matrixFishingMortality);
                double n = N.getValue(g, z);
                result.setValue(g, z, value *= n);
                ++z;
            }
            ++g;
        }
        return result;
    }

    public MatrixND matrixAbundanceSsF(MatrixND N, Population pop, TimeStep step) throws TopiaException, IsisFishException {
        List groups = pop.getPopulationGroup();
        List zones = pop.getPopulationZone();
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_ABUNDANCE, new List[]{groups, zones}, new String[]{I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        int g = 0;
        while (g < groups.size()) {
            PopulationGroup group = (PopulationGroup)groups.get(g);
            int z = 0;
            while (z < zones.size()) {
                Zone zone = (Zone)zones.get(z);
                double M = group.getNaturalDeathRate(zone) / (double)Month.NUMBER_OF_MONTH;
                double value = Math.exp(-M);
                double n = N.getValue(g, z);
                result.setValue(g, z, value *= n);
                ++z;
            }
            ++g;
        }
        return result;
    }

    private double survivalRatePerZone(TimeStep step, PopulationGroup group, Zone zone, MatrixND matrixFishingMortality) throws TopiaException, IsisFishException {
        double F = this.totalFishingMortality(step, matrixFishingMortality).getValue((Object)group, (Object)zone);
        double M = group.getNaturalDeathRate(zone) / (double)Month.NUMBER_OF_MONTH;
        double result = Math.exp(-(F + M));
        return result;
    }

    private double survivalRatePerCell(TimeStep step, PopulationGroup group, Zone zone, Cell cell, MatrixND matrixFishingMortalityPerCell) throws TopiaException, IsisFishException {
        double F = this.totalFishingMortalityPerCell(step, matrixFishingMortalityPerCell).getValue((Object)group, (Object)zone, (Object)cell);
        double M = group.getNaturalDeathRate(zone) / (double)Month.NUMBER_OF_MONTH;
        double result = Math.exp(-(F + M));
        return result;
    }

    public MatrixND matrixBiomass(MatrixND N, Population pop, TimeStep step) {
        List groups = N.getSemantic(0);
        List zones = N.getSemantic(1);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_BIOMASS, new List[]{groups, zones}, new String[]{I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        int g = 0;
        while (g < groups.size()) {
            PopulationGroup group = (PopulationGroup)groups.get(g);
            double meanWeight = group.getMeanWeight();
            int z = 0;
            while (z < zones.size()) {
                Zone zone = (Zone)zones.get(z);
                double n = N.getValue((Object)group, (Object)zone);
                double value = n * meanWeight;
                result.setValue((Object)group, (Object)zone, value);
                ++z;
            }
            ++g;
        }
        return result;
    }

    public MatrixND matrixBiomassBeginMonth(MatrixND N, Population pop, TimeStep step) {
        List groups = N.getSemantic(0);
        List zones = N.getSemantic(1);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_BIOMASS_BEGIN_MONTH, new List[]{groups, zones}, new String[]{I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        int g = 0;
        while (g < groups.size()) {
            PopulationGroup group = (PopulationGroup)groups.get(g);
            double meanWeight = group.getMeanWeight();
            int z = 0;
            while (z < zones.size()) {
                Zone zone = (Zone)zones.get(z);
                double n = N.getValue((Object)group, (Object)zone);
                double value = n * meanWeight;
                result.setValue((Object)group, (Object)zone, value);
                ++z;
            }
            ++g;
        }
        return result;
    }

    public MatrixND matrixAbondanceBeginMonth(MatrixND N, Population pop, TimeStep step) {
        List groups = N.getSemantic(0);
        List zones = N.getSemantic(1);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_ABUNDANCE_BEGIN_MONTH, new List[]{groups, zones}, new String[]{I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
        int g = 0;
        while (g < groups.size()) {
            PopulationGroup group = (PopulationGroup)groups.get(g);
            int z = 0;
            while (z < zones.size()) {
                Zone zone = (Zone)zones.get(z);
                double value = N.getValue((Object)group, (Object)zone);
                result.setValue((Object)group, (Object)zone, value);
                ++z;
            }
            ++g;
        }
        return result;
    }

    public MatrixND matrixEffortPerStrategyMet(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.getStrategies(step);
        List<Metier> metiers = this.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_EFFORT_PER_STRATEGY_MET, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.effortPerStrategyMet(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    public MatrixND matrixDiscardWeightPerStrategyMetPerZonePop(Population pop, TimeStep step, MatrixND matrixDiscardPerStrategyMetPerZonePop) {
        List groups = pop.getPopulationGroup();
        MatrixND result = matrixDiscardPerStrategyMetPerZonePop.copy();
        result.setName(ResultName.MATRIX_DISCARDS_WEIGHT_PER_STR_MET_PER_ZONE_POP);
        for (PopulationGroup group : groups) {
            MatrixND sub = result.getSubMatrix(2, (Object)group, 1);
            double meanWeight = group.getMeanWeight();
            sub.mults(meanWeight);
        }
        return result;
    }

    public MatrixND matrixEffortNominalPerStrategyMet(TimeStep step) throws TopiaException {
        List<Strategy> strategies = this.getStrategies(step);
        List<Metier> metiers = this.getMetiers(step);
        MatrixND result = MatrixFactory.getInstance().create(ResultName.MATRIX_EFFORT_NOMINAL_PER_STRATEGY_MET, new List[]{strategies, metiers}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0])});
        int s = 0;
        while (s < strategies.size()) {
            Strategy str = strategies.get(s);
            metiers = this.getMetiers(str, step);
            int m = 0;
            while (m < metiers.size()) {
                Metier metier = metiers.get(m);
                double value = this.effortNominalPerStrategyMet(str, metier, step);
                result.setValue((Object)str, (Object)metier, value);
                ++m;
            }
            ++s;
        }
        return result;
    }

    public MatrixND fishingMortalityPerGroup(TimeStep step, Population pop, ResultStorage resManager) throws TopiaException {
        double Fgroup = 0.0;
        double Cgroup = 0.0;
        double Mgroup = 0.0;
        double NgroupJan = 0.0;
        List<Population> populations = Collections.singletonList(pop);
        List groups = pop.getPopulationGroup();
        MatrixND tfgMatrix = MatrixFactory.getInstance().create(ResultName.MATRIX_FISHING_MORTALITY_PER_GROUP, new List[]{populations, groups}, new String[]{I18n.n((String)"Population", (Object[])new Object[0]), I18n.n((String)"Group", (Object[])new Object[0])});
        for (PopulationGroup group : groups) {
            if (step.getMonth() == Month.DECEMBER) {
                MatrixND catchPerStrategy = null;
                TimeStep loopstep = new TimeStep(step.getYear() * 12);
                while (loopstep.beforeOrEquals(step)) {
                    MatrixND catchPerStrategyTemp = resManager.getMatrix(loopstep, pop, ResultName.MATRIX_CATCH_PER_STRATEGY_MET_PER_ZONE_POP);
                    catchPerStrategy = catchPerStrategy == null ? catchPerStrategyTemp.clone() : catchPerStrategy.add(catchPerStrategyTemp);
                    loopstep = loopstep.next();
                }
                catchPerStrategy = catchPerStrategy.sumOverDim(0);
                catchPerStrategy = catchPerStrategy.sumOverDim(1);
                catchPerStrategy = catchPerStrategy.sumOverDim(3);
                List semgroup = catchPerStrategy.getSemantic(2);
                catchPerStrategy = catchPerStrategy.reduce();
                catchPerStrategy.setSemantic(0, semgroup);
                Cgroup = catchPerStrategy.getValue((Object)group);
                MatrixND naturalDeathRatePop = pop.getNaturalDeathRateMatrix();
                naturalDeathRatePop = naturalDeathRatePop.meanOverDim(1);
                naturalDeathRatePop = naturalDeathRatePop.reduce();
                Mgroup = naturalDeathRatePop.getValue((Object)group);
                MatrixND abundancePopJan = resManager.getMatrix(new TimeStep(12 * step.getYear()), pop, ResultName.MATRIX_ABUNDANCE);
                abundancePopJan = abundancePopJan.sumOverDim(1);
                abundancePopJan = abundancePopJan.reduce();
                NgroupJan = abundancePopJan.getValue((Object)group);
                ObjectiveFunctionBaranov f = new ObjectiveFunctionBaranov(Cgroup, Mgroup, NgroupJan);
                Fgroup = MinimisationUtil.fmin(0.0, 2.0, 1.0E-10, f);
                tfgMatrix.setValue((Object)pop, (Object)group, Fgroup);
                continue;
            }
            tfgMatrix.setValue((Object)pop, (Object)group, 0.0);
        }
        return tfgMatrix;
    }

    public MatrixND totalFishingMortality(TimeStep step, Population pop, MatrixND fishingMortalityPerGroup) throws TopiaException {
        MatrixND tfmMatrix = fishingMortalityPerGroup.copy();
        tfmMatrix.setName(ResultName.MATRIX_TOTAL_FISHING_MORTALITY);
        List groups = pop.getPopulationGroup();
        int groupMin = pop.getGroupMin();
        int groupMax = pop.getGroupMax();
        int Nbre = groupMax - groupMin + 1;
        for (PopulationGroup group : groups) {
            if (group.getId() != groupMin) continue;
            tfmMatrix = tfmMatrix.getSubMatrix(1, (Object)group, Nbre);
            tfmMatrix = tfmMatrix.meanOverDim(1);
            tfmMatrix = tfmMatrix.reduce();
        }
        return tfmMatrix;
    }
}

