/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.PopulationMonitor;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class TailleMin
extends AbstractRule {
    private static Log log = LogFactory.getLog(TailleMin.class);
    @Doc(value="Begin step")
    public TimeStep param_beginStep = new TimeStep(0);
    @Doc(value="End date")
    public TimeStep param_endStep = new TimeStep(119);
    @Doc(value="Affected species")
    public Species param_species = null;
    @Doc(value="Taille minimale")
    public double param_TailleMin = 27.0;
    @Doc(value="Proportion de survie")
    public double param_propSurvie = 0.0;
    protected boolean affectation = true;
    protected String[] necessaryResult = new String[0];

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Tous les poissons dont la taille est inf\u00e9rieure \u00e0 TailleMin ne seront pas captur\u00e9s. Ils sont plac\u00e9s en rejets et rejet\u00e9s suivant la proportion de survie.";
    }

    public void init(SimulationContext context) throws Exception {
    }

    private boolean isCaptureDate(TimeStep step, Species species, Metier metier) {
        MetierSeasonInfo info = metier.getMetierSeasonInfo(step.getMonth());
        TargetSpecies target = info.getSpeciesTargetSpecies(species);
        boolean result = target != null;
        return result;
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        log.info((Object)"Recherche si la taille Minimale s'applique");
        boolean result = true;
        if (step.before(this.param_beginStep)) {
            result = false;
        } else if (step.after(this.param_endStep)) {
            result = false;
        } else if (!this.isCaptureDate(step, this.param_species, metier)) {
            result = false;
        }
        log.info((Object)("fin de condition TailleMin:" + result));
        return result;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        this.affectation = true;
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        if (this.affectation) {
            log.info((Object)"*$*$*$* ok affecte capture inferieure a TailleMin au rejet");
            PopulationMonitor popMon = context.getPopulationMonitor();
            for (Population pop : this.param_species.getPopulation()) {
                MatrixND discard = popMon.getCatch(pop).copy();
                MatrixND eff = popMon.getN(pop);
                MatrixIterator i = discard.iterator();
                while (i.next()) {
                    Object[] coordonnees = i.getSemanticsCoordinates();
                    PopulationGroup group = (PopulationGroup)coordonnees[2];
                    if (group.getLength() >= this.param_TailleMin) {
                        i.setValue(0.0);
                        continue;
                    }
                    if (!(this.param_propSurvie > 0.0)) continue;
                    eff.setValue(coordonnees[2], coordonnees[3], eff.getValue(coordonnees[2], coordonnees[3]) + i.getValue() * this.param_propSurvie);
                }
                discard.setName(ResultName.MATRIX_DISCARDS_PER_STR_MET_PER_ZONE_POP);
                popMon.addDiscard(step, pop, discard);
            }
            this.affectation = false;
        }
    }
}

