package fr.ifremer.coser.ui.option;

/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coser.CoserConfig;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static fr.ifremer.coser.CoserBusinessConfig.CoserBusinessOption;
import static fr.ifremer.coser.CoserConfig.CoserOption;
import static org.nuiton.i18n.I18n.t;

public class ConfigurationView extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CONTROL_DIFF_CATCH_LENGTH_FIELD_TEXT = "controlDiffCatchLengthField.text";
    public static final String BINDING_CONTROL_NOBS_MIN_FIELD_TEXT = "controlNobsMinField.text";
    public static final String BINDING_CONTROL_STANDARD_DEVIATION_FIELD_TEXT = "controlStandardDeviationField.text";
    public static final String BINDING_CONTROL_TYPE_FISH_FIELD_TEXT = "controlTypeFishField.text";
    public static final String BINDING_PROJECT_DIRECTORY_FIELD_TEXT = "projectDirectoryField.text";
    public static final String BINDING_REFERENCE_SPECIES_FIELD_TEXT = "referenceSpeciesField.text";
    public static final String BINDING_REFERENCE_TYPE_ESPECES_FIELD_TEXT = "referenceTypeEspecesField.text";
    public static final String BINDING_SELECTION_FILTER_DENSITY_FIELD_TEXT = "selectionFilterDensityField.text";
    public static final String BINDING_SELECTION_FILTER_OCCURRENCE_FIELD_TEXT = "selectionFilterOccurrenceField.text";
    public static final String BINDING_SMTP_HOST_FIELD_TEXT = "smtpHostField.text";
    public static final String BINDING_SUPPORT_EMAIL_FIELD_TEXT = "supportEmailField.text";
    public static final String BINDING_SWING_FONT_SIZE_FIELD_SELECTED_ITEM = "swingFontSizeField.selectedItem";
    public static final String BINDING_VALIDATOR_DIRECTORY_FIELD_TEXT = "validatorDirectoryField.text";
    public static final String BINDING_WEB_FRONT_END_FIELD_TEXT = "webFrontEndField.text";
    public static final String BINDING_WEB_ZONES_FIELD_TEXT = "webZonesField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz28bRRTHJ6ZJ6rSF1qlDoqQlpUGoothNnLRUCfRHHJMEpxE4hFILwXh3HE+13llmZpMNAoT4C/gT4M4FiRsnxIEzBy6If6GqOHBFvNndrLPxxLY0OUySefM+7ztvZ+a9H5+hYcHRtac4CArcdyVtk8Lmg8ePtxtPiSXLRFicepJxFP0MZVCmjs7ZybyQ6Hq9qtyLsXtxlbU95hL3mPdyFY0JeegQ0SJESnQl7WEJUawl5uXA8/kRNRGlo37/z/PMd/Y3P2QQCjxQdxO2MtvPq7OTM1WUobZEOYi0j4sOdvdABqfuHui9oOZWHSzEI9wmn6Ov0WgVjXiYA0yiVwffcsgI/QNPouzcZplih+3dkuhmkxdok5M24QWLCRh9WmCepMwF4W6T7vkcq/92KTnwvBAyItFoC7u2Q7hExUEB65FHhzFihWaJZroQq2qMvI/FnNvBDYeA6MlUfsUBZKsQ2tTK7EmHefXvZTXkEtPZuc0qbhAHYDmV5CCmRLNqUT5Zm/c4Cw8i5TAyflihxIFPNpFy3CGBDA1pZ8j1Q19K5kKk8ZRDNJ1efSQrlDyVtr28jx1qYxCQFqLMM6cEDTmv6GMsaGLkOWkSOF0WqXnEokT0jbDQI0JJE2EqibBz6JE1AWEGiFLqEWVRE+XCAWk8gcvQn7zYg7ykIV8EcoUzV6659mnw+Nwt9Dh3txP0SmIbh/sgOXMesYbYom6avtKFuKNBTMeIMm02V7G0WlXi7slWP9RbGtTlGKU+U4WKvoy7GsaVmFGTcPcxt8tkn4ZvwWmw7NH5v6WhXRXEgXMfujuS8G3L8nl4lPri5nW5OoErE1dQeXgaK/6oJc1HTcJ0rtRu5yiKtvTWmZBp8G63d0njfUn4nse4XGtj6vQlLGoIufC5qcCHqNEvSPx05VMvEVSOBnvIgi5qdEWWkiuS6zbePm7kaDr1MkNNLXRqaqfoDdXRMPdhGp7yencZ/gBMUQGePFGAFTC0/jcx/ucvf/9cOaq6NyB2Xrv0WNMA1RCecg+qFlWhX4pKri+pU9zC3nIdZaMjEXYUMxphtdgM4iDeJeVeUO6FdSxagBge/evX3yY+++MFlKmgMYdhu4LV+g2UlS0OWWCOHXj37oeKzh+chfGi0ibRsKTSgRTlVqjrUJfMYglNQMOX5J0A8jCjyUMippH9/d/x2k/3j3IxBNqmTl3eycfwEzQSRQt7kLi90PYc5zxBfJt12ghdYzGkfo95ccF2w5HrNjvSYNxWvcOLK1DP8GyDujYcRNipctkPt6D+CkLixADEMxKqr7J+pWdM9mWo6W97EKYHJ/h6wlVjDdeMCdeNd/GasYbXjQk3jHfxhrGGN40JReNdzBtrKBkTlox3ccdYw11jwvJAhC97EN421nDPmPDAmLBqTFgzJrxrTNgwJrxnTNgyJmwbE943JtSMCR8a36yPjDV8bEyoGxM+MSZ8akzAA3RS56MWmNgbkrR7sCzjd79pTGgB4X9AQTLdPRQAAA==";
    private static final Log log = LogFactory.getLog(ConfigurationView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CoserConfig config;
    protected JTextField controlDiffCatchLengthField;
    protected JTextField controlNobsMinField;
    protected JTextField controlStandardDeviationField;
    protected JTextField controlTypeFishField;
    protected ConfigurationHandler handler;
    protected JTextField projectDirectoryField;
    protected JTextField referenceSpeciesField;
    protected JTextField referenceTypeEspecesField;
    protected JTextField selectionFilterDensityField;
    protected JTextField selectionFilterOccurrenceField;
    protected JTextField smtpHostField;
    protected JTextField supportEmailField;
    protected JComboBox swingFontSizeField;
    protected JTextField validatorDirectoryField;
    protected JTextField webFrontEndField;
    protected JTextField webZonesField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JButton $JButton6;
    private ConfigurationView $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel10;
    private JLabel $JLabel11;
    private JLabel $JLabel12;
    private JLabel $JLabel13;
    private JLabel $JLabel14;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JLabel $JLabel9;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigurationView(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView() {
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Frame param0) {
        super(param0);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Window param0) {
        super(param0);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigurationView(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigurationView(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputDirectory(this, projectDirectoryField);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputDirectory(this, validatorDirectoryField);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputFile(this, referenceSpeciesField);
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputFile(this, referenceTypeEspecesField);
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputFile(this, webZonesField);
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().saveConfiguration(this);
    }

    public void doActionPerformed__on__$JButton6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public CoserConfig getConfig() {
        return config;
    }

    public JTextField getControlDiffCatchLengthField() {
        return controlDiffCatchLengthField;
    }

    public JTextField getControlNobsMinField() {
        return controlNobsMinField;
    }

    public JTextField getControlStandardDeviationField() {
        return controlStandardDeviationField;
    }

    public JTextField getControlTypeFishField() {
        return controlTypeFishField;
    }

    public ConfigurationHandler getHandler() {
        return handler;
    }

    public JTextField getProjectDirectoryField() {
        return projectDirectoryField;
    }

    public JTextField getReferenceSpeciesField() {
        return referenceSpeciesField;
    }

    public JTextField getReferenceTypeEspecesField() {
        return referenceTypeEspecesField;
    }

    public JTextField getSelectionFilterDensityField() {
        return selectionFilterDensityField;
    }

    public JTextField getSelectionFilterOccurrenceField() {
        return selectionFilterOccurrenceField;
    }

    public JTextField getSmtpHostField() {
        return smtpHostField;
    }

    public JTextField getSupportEmailField() {
        return supportEmailField;
    }

    public JComboBox getSwingFontSizeField() {
        return swingFontSizeField;
    }

    public JTextField getValidatorDirectoryField() {
        return validatorDirectoryField;
    }

    public JTextField getWebFrontEndField() {
        return webFrontEndField;
    }

    public JTextField getWebZonesField() {
        return webZonesField;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JButton get$JButton6() {
        return $JButton6;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected JLabel get$JLabel12() {
        return $JLabel12;
    }

    protected JLabel get$JLabel13() {
        return $JLabel13;
    }

    protected JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createConfig() {
        $objectMap.put("config", config = getContextValue(CoserConfig.class));
    }

    protected void createControlDiffCatchLengthField() {
        $objectMap.put("controlDiffCatchLengthField", controlDiffCatchLengthField = new JTextField());
        
        controlDiffCatchLengthField.setName("controlDiffCatchLengthField");
        controlDiffCatchLengthField.setColumns(15);
    }

    protected void createControlNobsMinField() {
        $objectMap.put("controlNobsMinField", controlNobsMinField = new JTextField());
        
        controlNobsMinField.setName("controlNobsMinField");
        controlNobsMinField.setColumns(15);
    }

    protected void createControlStandardDeviationField() {
        $objectMap.put("controlStandardDeviationField", controlStandardDeviationField = new JTextField());
        
        controlStandardDeviationField.setName("controlStandardDeviationField");
        controlStandardDeviationField.setColumns(15);
    }

    protected void createControlTypeFishField() {
        $objectMap.put("controlTypeFishField", controlTypeFishField = new JTextField());
        
        controlTypeFishField.setName("controlTypeFishField");
        controlTypeFishField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ConfigurationHandler());
    }

    protected void createProjectDirectoryField() {
        $objectMap.put("projectDirectoryField", projectDirectoryField = new JTextField());
        
        projectDirectoryField.setName("projectDirectoryField");
        projectDirectoryField.setColumns(15);
    }

    protected void createReferenceSpeciesField() {
        $objectMap.put("referenceSpeciesField", referenceSpeciesField = new JTextField());
        
        referenceSpeciesField.setName("referenceSpeciesField");
        referenceSpeciesField.setColumns(15);
    }

    protected void createReferenceTypeEspecesField() {
        $objectMap.put("referenceTypeEspecesField", referenceTypeEspecesField = new JTextField());
        
        referenceTypeEspecesField.setName("referenceTypeEspecesField");
        referenceTypeEspecesField.setColumns(15);
    }

    protected void createSelectionFilterDensityField() {
        $objectMap.put("selectionFilterDensityField", selectionFilterDensityField = new JTextField());
        
        selectionFilterDensityField.setName("selectionFilterDensityField");
        selectionFilterDensityField.setColumns(15);
    }

    protected void createSelectionFilterOccurrenceField() {
        $objectMap.put("selectionFilterOccurrenceField", selectionFilterOccurrenceField = new JTextField());
        
        selectionFilterOccurrenceField.setName("selectionFilterOccurrenceField");
        selectionFilterOccurrenceField.setColumns(15);
    }

    protected void createSmtpHostField() {
        $objectMap.put("smtpHostField", smtpHostField = new JTextField());
        
        smtpHostField.setName("smtpHostField");
        smtpHostField.setColumns(15);
    }

    protected void createSupportEmailField() {
        $objectMap.put("supportEmailField", supportEmailField = new JTextField());
        
        supportEmailField.setName("supportEmailField");
        supportEmailField.setColumns(15);
    }

    protected void createSwingFontSizeField() {
        $objectMap.put("swingFontSizeField", swingFontSizeField = new JComboBox(new Object[]{"12", "14", "16", "18", "20"}));
        
        swingFontSizeField.setName("swingFontSizeField");
    }

    protected void createValidatorDirectoryField() {
        $objectMap.put("validatorDirectoryField", validatorDirectoryField = new JTextField());
        
        validatorDirectoryField.setName("validatorDirectoryField");
        validatorDirectoryField.setColumns(15);
    }

    protected void createWebFrontEndField() {
        $objectMap.put("webFrontEndField", webFrontEndField = new JTextField());
        
        webFrontEndField.setName("webFrontEndField");
        webFrontEndField.setColumns(15);
    }

    protected void createWebZonesField() {
        $objectMap.put("webZonesField", webZonesField = new JTextField());
        
        webZonesField.setName("webZonesField");
        webZonesField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table3, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton5, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton6, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(projectDirectoryField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(validatorDirectoryField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(referenceSpeciesField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(referenceTypeEspecesField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton3, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(webZonesField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton4, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(webFrontEndField, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(controlNobsMinField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(controlDiffCatchLengthField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel8, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(controlTypeFishField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel9, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(controlStandardDeviationField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel10, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(selectionFilterOccurrenceField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel11, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(selectionFilterDensityField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add($JLabel12, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(smtpHostField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel13, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(supportEmailField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel14, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(swingFontSizeField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(t("coser.ui.configuration.category.path")));
        $JLabel0.setText(t(CoserBusinessOption.PROJECTS_DIRECTORY.getDescription()));
        $JLabel1.setText(t(CoserBusinessOption.VALIDATOR_DIRECTORY.getDescription()));
        $JLabel2.setText(t(CoserBusinessOption.REFERENCE_SPECIES.getDescription()));
        $JLabel3.setText(t(CoserBusinessOption.REFERENCE_TYPE_ESPECES.getDescription()));
        $JLabel4.setText(t(CoserBusinessOption.WEB_ZONES.getDescription()));
        $JLabel5.setText(t(CoserBusinessOption.WEB_FRONT_END.getDescription()));
        $Table2.setBorder(BorderFactory.createTitledBorder(t("coser.ui.configuration.category.controlselection")));
        $JLabel6.setText(t(CoserBusinessOption.CONTROL_NOBSMIN.getDescription()));
        $JLabel7.setText(t(CoserBusinessOption.CONTROL_DIFF_CATCH_LENGTH.getDescription()));
        $JLabel8.setText(t(CoserBusinessOption.CONTROL_TYPE_FISH.getDescription()));
        $JLabel9.setText(t(CoserBusinessOption.CONTROL_STANDARD_DEVIATION_TO_AVERAGE.getDescription()));
        $JLabel10.setText(t(CoserBusinessOption.SELECTION_FILTER_OCCURRENCE.getDescription()));
        $JLabel11.setText(t(CoserBusinessOption.SELECTION_FILTER_DENSITY.getDescription()));
        $Table3.setBorder(BorderFactory.createTitledBorder(t("coser.ui.configuration.category.misc")));
        $JLabel12.setText(t(CoserBusinessOption.SMTP_HOST.getDescription()));
        $JLabel13.setText(t(CoserOption.SUPPORT_EMAIL.getDescription()));
        $JLabel14.setText(t(CoserOption.SWING_FONT_SIZE.getDescription()));
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createHandler();
        createConfig();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createProjectDirectoryField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("coser.ui.common.selectFile"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        createValidatorDirectoryField();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("coser.ui.common.selectFile"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        createReferenceSpeciesField();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("coser.ui.common.selectFile"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        createReferenceTypeEspecesField();
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(t("coser.ui.common.selectFile"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        createWebZonesField();
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(t("coser.ui.common.selectFile"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        createWebFrontEndField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        createControlNobsMinField();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        createControlDiffCatchLengthField();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        createControlTypeFishField();
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new JLabel());
        
        $JLabel9.setName("$JLabel9");
        createControlStandardDeviationField();
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new JLabel());
        
        $JLabel10.setName("$JLabel10");
        createSelectionFilterOccurrenceField();
        // inline creation of $JLabel11
        $objectMap.put("$JLabel11", $JLabel11 = new JLabel());
        
        $JLabel11.setName("$JLabel11");
        createSelectionFilterDensityField();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel12
        $objectMap.put("$JLabel12", $JLabel12 = new JLabel());
        
        $JLabel12.setName("$JLabel12");
        createSmtpHostField();
        // inline creation of $JLabel13
        $objectMap.put("$JLabel13", $JLabel13 = new JLabel());
        
        $JLabel13.setName("$JLabel13");
        createSupportEmailField();
        // inline creation of $JLabel14
        $objectMap.put("$JLabel14", $JLabel14 = new JLabel());
        
        $JLabel14.setName("$JLabel14");
        createSwingFontSizeField();
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setText(t("coser.ui.common.valid"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $JButton6
        $objectMap.put("$JButton6", $JButton6 = new JButton());
        
        $JButton6.setName("$JButton6");
        $JButton6.setText(t("coser.ui.common.cancel"));
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        // inline creation of $JDialog0
        setName("$JDialog0");
        setTitle(t("coser.ui.configuration.title"));
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_DIRECTORY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("projectsDirectory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null && config.getProjectsDirectory() != null) {
                    SwingUtil.setText(projectDirectoryField, config.getProjectsDirectory().getAbsolutePath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("projectsDirectory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATOR_DIRECTORY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("validatorsDirectory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null && config.getValidatorsDirectory() != null) {
                    SwingUtil.setText(validatorDirectoryField, config.getValidatorsDirectory().getAbsolutePath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("validatorsDirectory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REFERENCE_SPECIES_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("referenceSpeciesPath", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(referenceSpeciesField, config.getReferenceSpeciesPath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("referenceSpeciesPath", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REFERENCE_TYPE_ESPECES_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("referenceTypeEspecesPath", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(referenceTypeEspecesField, config.getReferenceTypeEspecesPath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("referenceTypeEspecesPath", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WEB_ZONES_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("webZonesFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null && config.getWebZonesFile() != null) {
                    SwingUtil.setText(webZonesField, config.getWebZonesFile().getAbsolutePath());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("webZonesFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WEB_FRONT_END_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("webFrontEnd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(webFrontEndField, config.getWebFrontEnd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("webFrontEnd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTROL_NOBS_MIN_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("controlNobsmin", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(controlNobsMinField, String.valueOf(config.getControlNobsmin()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("controlNobsmin", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTROL_DIFF_CATCH_LENGTH_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("controlDiffCatchLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(controlDiffCatchLengthField, String.valueOf(config.getControlDiffCatchLength()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("controlDiffCatchLength", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTROL_TYPE_FISH_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("controlTypeFish", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(controlTypeFishField, config.getControlTypeFish());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("controlTypeFish", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTROL_STANDARD_DEVIATION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("standardDeviationToAverage", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(controlStandardDeviationField, String.valueOf(config.getStandardDeviationToAverage()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("standardDeviationToAverage", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_FILTER_OCCURRENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("selectionOccurrenceFilter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(selectionFilterOccurrenceField, String.valueOf(config.getSelectionOccurrenceFilter()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("selectionOccurrenceFilter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_FILTER_DENSITY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("selectionDensityFilter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(selectionFilterDensityField, String.valueOf(config.getSelectionDensityFilter()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("selectionDensityFilter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SMTP_HOST_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("smtpHost", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(smtpHostField, config.getSmtpHost());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("smtpHost", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUPPORT_EMAIL_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("supportEmail", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    SwingUtil.setText(supportEmailField, config.getSupportEmail());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("supportEmail", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SWING_FONT_SIZE_FIELD_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (config != null) {
                    config.addPropertyChangeListener("swingFontSize", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (config != null) {
                    swingFontSizeField.setSelectedItem(String.valueOf(config.getSwingFontSize()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (config != null) {
                    config.removePropertyChangeListener("swingFontSize", this);
                }
            }
        });
    }

}