/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import fr.ifremer.coser.ui.util.ErrorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoserExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(CoserExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        this.handleException(t.getName(), ex);
    }

    public void handle(Throwable thrown) {
        this.handleException(Thread.currentThread().getName(), thrown);
    }

    protected void handleException(String tname, Throwable ex) {
        if (log.isErrorEnabled()) {
            log.error((Object)"Global application exception", ex);
        }
        ErrorHelper errorHelper = new ErrorHelper();
        errorHelper.showErrorDialog(null, ex.getMessage(), ex);
    }
}

