/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.maps;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.event.InfoDisplayListener;
import com.bbn.openmap.event.OMMouseMode;
import com.bbn.openmap.gui.OverlayMapPanel;
import com.bbn.openmap.layer.GraticuleLayer;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.layer.shape.ShapeLayer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.ui.maps.HaulLocationHandler;
import fr.ifremer.coser.ui.maps.HaulLocationLayer;
import fr.ifremer.coser.util.Coordinate;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoserMap
extends OverlayMapPanel {
    private static final long serialVersionUID = 3134624721243512358L;
    private static final Log log = LogFactory.getLog(CoserMap.class);
    protected InformationDelegator informationDelegator;
    protected LocationLayer haulLocationLayer;
    protected static final float SCALE = 9500000.0f;

    public CoserMap() {
        super(new PropertyHandler(new Properties()), true);
        this.create();
        MapBean mapBean = this.getMapBean();
        mapBean.setScale(9500000.0f);
        this.addMapComponent(new LayerHandler());
        this.addMapComponent(new MouseDelegator(mapBean));
        this.getMapBean().setBackgroundColor(new Color(10073036));
    }

    public void initMap(Project project, InformationDelegator informationDelegator) {
        this.informationDelegator = informationDelegator;
        OMMouseMode mouseMode = new OMMouseMode();
        mouseMode.setInfoDelegator(informationDelegator);
        this.addMapComponent(mouseMode);
        MapBean mapBean = this.getMapBean();
        mapBean.setCenter(50.0f, 0.0f);
        mapBean.setScale(1.6E7f);
        this.addGraticuleLayer();
        boolean cntrOOShapeFound = false;
        if (project.getMaps() != null) {
            for (File map : project.getMaps()) {
                if (!map.getName().equals("cntry00.shp")) continue;
                cntrOOShapeFound = true;
            }
        }
        if (!cntrOOShapeFound) {
            this.addLayer("maps/vmap_area_thin.shp", "maps/vmap_area_thin.shp", "ff000000", "ffbdde83");
        }
        if (project.getMaps() != null) {
            for (File map : project.getMaps()) {
                if (map.getName().equals("cntry00.shp")) {
                    this.addLayer(map.getAbsolutePath(), map.getAbsolutePath(), "ff000000", "ffbdde83");
                    continue;
                }
                this.addLayer(map.getAbsolutePath(), map.getAbsolutePath(), "ff000000", "ffFDA908");
            }
        }
    }

    protected void addGraticuleLayer() {
        GraticuleLayer layer = new GraticuleLayer();
        Properties p = new Properties();
        p.setProperty(".showRuler", "true");
        p.setProperty(".show1And5Lines", "true");
        p.setProperty(".threshold", "5");
        p.setProperty(".10DegreeColor", "FF000000");
        p.setProperty(".5DegreeColor", "C7009900");
        p.setProperty(".1DegreeColor", "FF003300");
        p.setProperty(".equatorColor", "FFFF0000");
        p.setProperty(".datelineColor", "FF000099");
        p.setProperty(".specialLineColor", "FF000000");
        p.setProperty(".textColor", "FF000000");
        layer.setProperties("", p);
        this.addMapComponent(layer);
    }

    public void addStataHaulLayer(List<Coordinate> hauls) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding strata haul layer (" + hauls.size() + " coordinates)"));
        }
        if (this.haulLocationLayer != null) {
            this.removeMapComponent(this.haulLocationLayer);
        }
        HaulLocationHandler locationHandler = new HaulLocationHandler(hauls);
        this.haulLocationLayer = new HaulLocationLayer();
        this.haulLocationLayer.setLocationHandlers(new LocationHandler[]{locationHandler});
        this.haulLocationLayer.addInfoDisplayListener((InfoDisplayListener)this.informationDelegator);
        this.addMapComponent(this.haulLocationLayer);
    }

    protected void addLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        Layer layer = null;
        if (mapFile.endsWith(".shp")) {
            layer = this.getShapeLayer(layerId, mapFile, lineColor, fillColor);
        } else if (log.isErrorEnabled()) {
            log.error((Object)("Can't find layer for " + mapFile + " (unknown type)"));
        }
        if (layer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add layer " + layer));
            }
            this.addMapComponent(layer);
        }
    }

    protected Layer getShapeLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get ShapeLayer with filename : " + mapFile));
        }
        ShapeLayer shapeLayer = new ShapeLayer();
        Properties p = new Properties();
        p.setProperty(layerId + "." + "shapeFile", mapFile);
        p.setProperty(layerId + "." + "lineColor", lineColor);
        p.setProperty(layerId + "." + "fillColor", fillColor);
        shapeLayer.setProperties(layerId, p);
        shapeLayer.setName(layerId);
        return shapeLayer;
    }
}

