/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.util;

import fr.ifremer.coser.ui.util.CoserListModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jaxx.runtime.swing.OneClicListSelectionModel;
import org.apache.commons.lang.NotImplementedException;

public class CoserListSelectionModel
extends OneClicListSelectionModel
implements ListDataListener {
    protected Set<Object> selectedObjects;
    protected CoserListModel coserListModel;

    public CoserListSelectionModel(ListSelectionModel delegate, CoserListModel coserListModel) {
        super(delegate, (ListModel)coserListModel);
        this.coserListModel = coserListModel;
        this.selectedObjects = new HashSet<Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedObjects(Collection<?> objects) {
        this.selectedObjects.clear();
        if (objects != null) {
            this.selectedObjects.addAll(objects);
        }
        this.setValueIsAdjusting(true);
        try {
            this.contentsChanged(null);
        }
        finally {
            this.setValueIsAdjusting(false);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        super.clearSelection();
        for (Object o : new HashSet<Object>(this.selectedObjects)) {
            int index = this.coserListModel.indexOf(o);
            if (index < 0) continue;
            this.addSelectionInterval(index, index);
        }
    }

    public void setSelectionInterval(int index0, int index1) {
        super.setSelectionInterval(index0, index1);
        this.registerSelection(index0, index1);
    }

    public void addSelectionInterval(int index0, int index1) {
        super.addSelectionInterval(index0, index1);
        this.registerSelection(index0, index1);
    }

    protected void registerSelection(int index0, int index1) {
        for (int i = index0; i <= index1; ++i) {
            Object o = this.coserListModel.getElementAt(i);
            if (this.isSelectedIndex(i)) {
                this.selectedObjects.add(o);
                continue;
            }
            this.selectedObjects.remove(o);
        }
    }

    public void fillSelection() {
        this.addSelectionInterval(0, this.coserListModel.getSize() - 1);
    }

    public void clearSelection() {
        super.clearSelection();
        this.selectedObjects.clear();
    }
}

