/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.result;

import fr.ifremer.coser.ui.result.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class SelectionAddResultDialog extends javax.swing.JDialog implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_RESULT_ZONE_COMBO_MODEL = "resultZoneComboModel";
    public static final String PROPERTY_RSUFI_RESULT = "rsufiResult";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESULT_NAME_FIELD_TEXT = "resultNameField.text";
    public static final String BINDING_RESULT_ZONE_COMBO_MODEL = "resultZoneCombo.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXz28bRRSemDqJk7YJSeu2IhUpNeJQWLdJCpUSpU1jmcZySIirENUS6tg7sSdZ72xnZpPtBfXCnTsXuHNB4sYJceDMgQviX0CIA1fEm931btYeOy7rwzp+P773zXtv9r189yfKCo5uHWHPM7hrS9ohRmXj4GCncUSaskREk1NHMo6Cz1gGZepo2ozkQqLb9apyL4buxU3WcZhN7DPeq1U0JeRLi4g2IVKim0mPphDFWqRe9RyXd1EjUjrUb/7+K/OV+erbDEKeA+zeg6MsnucVn+RCFWWoKdEcRDrBRQvbLaDBqd0CvpeUbNPCQnyCO+QF+gJNVNG4gzmASfTO6Ef2MXx/z5EoV6iUKLZY665Ey4fcoIecdAg3mkzA06UGJ8K1pFEjFuSfMnvDNPd8UeDmOD7WuEQThae4YRHAuZ44sjiFAxi+TlnmYoc2tk2LcIkMXWDRjRjHfhI4xDGnuXAPacBHolt9MA2CbWOvFtnEnrOEc+gWn9Y2M4kl0VqC9gm2qIkhceEBauq53xVuEyFwi8TuMfKVyPNMYInuvAZ6DDZZqFRxg1iQ1TnVAF5oH0iV0cXIdiYolWqPMiUWNFI+4fKUeNJXJN2mCiXWdDvQLBDkxlkPCQ5GV9nP6Z76fTMJNhdw2FNl2SdcQNGUZnFQSB/jdj/20mDsTU6waoYSlkSiRcZbxhHc/2PJnIC3Z1QOlHKXNo8JT2J08Zc1+FcC/GdwceD+NFjYFu8PuRWR7WPm9bTBTA+aRFcT1ei66fmtaPjliZDgtWWbZWqRRDUH5nepJ79w3R+7UjIbaj2f4BOI9WzuD2Czy5zXYrM8iI3fBg/1wT/UBe9gR5Qoh9cC4y9HC74yKPjSkOAfaYJfc9yGRdXND+72Zps0j6GSfRUO5XrkBxrkS4VKrcmZZe1iW71IryXwYlVPMphsEw4dj1UlqlTIsHPvDencHa1PnJ03+0BBlnwDgUwZf9Y7AfxiXk5yjJK9HCX7eb9yRaOcFfgkTHTcol0bjt5KvFZhcBvx4I4n61gdZbkLYhhO9f5ZvweqYMpf75nyCtDX/puf/+3HP34od0d7HmJf1Zqe2Uxg5DqcOTDiqAo9E8x1V1KruI2d1TrKBUPOX1sWNMRqoRrIQTw//4ZyN55g0QaI7MTvP/2cf/7rGyhTRlMWw2YZK/stlJNtqHSbWabnPHzkM7p4OgnPWcVNomyHmRh6ZG6N2ha1ySKWsGk0XEnWPcjDgiYPEZlG7pd/5mvfP+rmYgy43RhoHucj+wyNB9H8RSfcYbSLzbQjiGuyeFfRbS9j6nvKCZu24z9faA8rqQy2D+m56sv1Wau/TkcGuaDG4RCMhXMxlPiVRJfXYMjjxQa1TbhI63q0t0dDG8Ln3dQId0bJCpzFz+yXeowPUrO4O0qBO+rtNYTG/RFAJmGVNgkPVob/jXPecR6kRlhPjbCRGuHj1AhbqRF2UiN8mhphfySEr4d01OepOTRTI5DUCPB/oPMfGANn7rwPAAA=";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    public static final String PROPERTY$DOCUMENT3 = "$Document3";
    public static final String PROPERTY$DOCUMENT4 = "$Document4";
    private static final Log log = LogFactory.getLog(fr.ifremer.coser.ui.result.SelectionAddResultDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorsTableModel;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "estComIndPath",  editorName = "estComIndFileTextField")
    protected javax.swing.JTextField estComIndFileTextField;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "estPopIndPath",  editorName = "estPopIndFileTextField")
    protected javax.swing.JTextField estPopIndFileTextField;
    protected fr.ifremer.coser.ui.selection.SelectionHandler handler;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "mapsPath",  editorName = "mapsDirectoryTextField")
    protected javax.swing.JTextField mapsDirectoryTextField;
    protected javax.swing.JList otherDataFileList;
    protected fr.ifremer.coser.ui.result.OtherDataFileListModel otherDataFileListModel;
    protected javax.swing.JCheckBox publiableResultCheckBox;
    protected org.jdesktop.swingx.JXDatePicker resultCreationDate;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "name",  editorName = "resultNameField")
    protected javax.swing.JTextField resultNameField;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "rsufiVersion",  editorName = "resultRsufiVersion")
    protected javax.swing.JTextField resultRsufiVersion;
    protected javax.swing.JComboBox resultZoneCombo;
    protected fr.ifremer.coser.ui.result.ZoneComboBoxModel resultZoneComboModel;
    protected fr.ifremer.coser.bean.RSufiResult rsufiResult;
    protected javax.swing.JButton saveResultButton;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorRSufiResult")
    protected jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.bean.RSufiResult > validatorRSufiResult;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SelectionAddResultDialog $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.text.Document $Document1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.text.Document $Document2;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.text.Document $Document3;
    private javax.swing.JButton $JButton1;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.text.Document $Document4;
    private javax.swing.JButton $JButton2;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JButton $JButton3;
    private javax.swing.JButton $JButton4;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionAddResultDialog() {
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInsertUpdate__on__$Document2(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setEstComIndPath(estComIndFileTextField.getText());
    }

    public void doRemoveUpdate__on__$Document2(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setEstComIndPath(estComIndFileTextField.getText());
    }

    public void doInsertUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setRsufiVersion(resultRsufiVersion.getText());
    }

    public void doRemoveUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setRsufiVersion(resultRsufiVersion.getText());
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setName(resultNameField.getText());
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setName(resultNameField.getText());
    }

    public void doInsertUpdate__on__$Document4(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setMapsPath(mapsDirectoryTextField.getText());
    }

    public void doRemoveUpdate__on__$Document4(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setMapsPath(mapsDirectoryTextField.getText());
    }

    public void doInsertUpdate__on__$Document3(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setEstPopIndPath(estPopIndFileTextField.getText());
    }

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        dispose();
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().selectResultFile(this, estComIndFileTextField);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().selectResultFile(this, estPopIndFileTextField);
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        getHandler().selectMapsDirectory(this, mapsDirectoryTextField);
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        getHandler().selectResultFileOrDirectory(this, otherDataFileList);
    }

    public void doActionPerformed__on__publiableResultCheckBox(java.awt.event.ActionEvent event) {
        getRsufiResult().setPubliableResult(publiableResultCheckBox.isSelected());
    }

    public void doActionPerformed__on__resultCreationDate(java.awt.event.ActionEvent event) {
        getRsufiResult().setCreationDate(resultCreationDate.getDate());
    }

    public void doActionPerformed__on__resultZoneCombo(java.awt.event.ActionEvent event) {
        getRsufiResult().setZone((String)resultZoneCombo.getSelectedItem());
    }

    public void doActionPerformed__on__saveResultButton(java.awt.event.ActionEvent event) {
        getHandler().performAddResult(this);
    }

    public void doRemoveUpdate__on__$Document3(javax.swing.event.DocumentEvent event) {
        getRsufiResult().setEstPopIndPath(estPopIndFileTextField.getText());
    }

    public void doTableChanged__on__errorsTableModel(javax.swing.event.TableModelEvent event) {
        saveResultButton.setEnabled(errorsTableModel.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public javax.swing.JTextField getEstComIndFileTextField() {
        return estComIndFileTextField;
    }

    public javax.swing.JTextField getEstPopIndFileTextField() {
        return estPopIndFileTextField;
    }

    public fr.ifremer.coser.ui.selection.SelectionHandler getHandler() {
        return handler;
    }

    public javax.swing.JTextField getMapsDirectoryTextField() {
        return mapsDirectoryTextField;
    }

    public javax.swing.JList getOtherDataFileList() {
        return otherDataFileList;
    }

    public fr.ifremer.coser.ui.result.OtherDataFileListModel getOtherDataFileListModel() {
        return otherDataFileListModel;
    }

    public javax.swing.JCheckBox getPubliableResultCheckBox() {
        return publiableResultCheckBox;
    }

    public org.jdesktop.swingx.JXDatePicker getResultCreationDate() {
        return resultCreationDate;
    }

    public javax.swing.JTextField getResultNameField() {
        return resultNameField;
    }

    public javax.swing.JTextField getResultRsufiVersion() {
        return resultRsufiVersion;
    }

    public javax.swing.JComboBox getResultZoneCombo() {
        return resultZoneCombo;
    }

    public fr.ifremer.coser.ui.result.ZoneComboBoxModel getResultZoneComboModel() {
        return resultZoneComboModel;
    }

    public fr.ifremer.coser.bean.RSufiResult getRsufiResult() {
        return rsufiResult;
    }

    public javax.swing.JButton getSaveResultButton() {
        return saveResultButton;
    }

    public jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.bean.RSufiResult > getValidatorRSufiResult() {
        return validatorRSufiResult;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$Document1(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document1;
        this.$Document1 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, newValue);
    }

    public void set$Document2(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document2;
        this.$Document2 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, newValue);
    }

    public void set$Document3(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document3;
        this.$Document3 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT3, oldValue, newValue);
    }

    public void set$Document4(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document4;
        this.$Document4 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT4, oldValue, newValue);
    }

    public void setHandler(fr.ifremer.coser.ui.selection.SelectionHandler newValue) {
        fr.ifremer.coser.ui.selection.SelectionHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setResultZoneComboModel(fr.ifremer.coser.ui.result.ZoneComboBoxModel newValue) {
        fr.ifremer.coser.ui.result.ZoneComboBoxModel oldValue = this.resultZoneComboModel;
        this.resultZoneComboModel = newValue;
        firePropertyChange(PROPERTY_RESULT_ZONE_COMBO_MODEL, oldValue, newValue);
    }

    public void setRsufiResult(fr.ifremer.coser.bean.RSufiResult newValue) {
        fr.ifremer.coser.bean.RSufiResult oldValue = this.rsufiResult;
        this.rsufiResult = newValue;
        firePropertyChange(PROPERTY_RSUFI_RESULT, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.installFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.text.Document get$Document1() {
        return $Document1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.text.Document get$Document2() {
        return $Document2;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.text.Document get$Document3() {
        return $Document3;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.text.Document get$Document4() {
        return $Document4;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToValidatorRSufiResult() {
        if (!allComponentsCreated) {
            return;
        }
        validatorRSufiResult.setErrorTableModel(errorsTableModel);
        validatorRSufiResult.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validatorRSufiResult.setBean(rsufiResult);
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        
        errorsTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorsTableModel"));
    }

    protected void createEstComIndFileTextField() {
        $objectMap.put("estComIndFileTextField", estComIndFileTextField = new javax.swing.JTextField());
        
        estComIndFileTextField.setName("estComIndFileTextField");
        estComIndFileTextField.setColumns(15);
    }

    protected void createEstPopIndFileTextField() {
        $objectMap.put("estPopIndFileTextField", estPopIndFileTextField = new javax.swing.JTextField());
        
        estPopIndFileTextField.setName("estPopIndFileTextField");
        estPopIndFileTextField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createMapsDirectoryTextField() {
        $objectMap.put("mapsDirectoryTextField", mapsDirectoryTextField = new javax.swing.JTextField());
        
        mapsDirectoryTextField.setName("mapsDirectoryTextField");
        mapsDirectoryTextField.setColumns(15);
    }

    protected void createOtherDataFileList() {
        $objectMap.put("otherDataFileList", otherDataFileList = new javax.swing.JList());
        
        otherDataFileList.setName("otherDataFileList");
    }

    protected void createOtherDataFileListModel() {
        $objectMap.put("otherDataFileListModel", otherDataFileListModel = new fr.ifremer.coser.ui.result.OtherDataFileListModel());
    }

    protected void createPubliableResultCheckBox() {
        $objectMap.put("publiableResultCheckBox", publiableResultCheckBox = new javax.swing.JCheckBox());
        
        publiableResultCheckBox.setName("publiableResultCheckBox");
        publiableResultCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__publiableResultCheckBox"));
    }

    protected void createResultCreationDate() {
        $objectMap.put("resultCreationDate", resultCreationDate = new org.jdesktop.swingx.JXDatePicker());
        
        resultCreationDate.setName("resultCreationDate");
        resultCreationDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resultCreationDate"));
    }

    protected void createResultNameField() {
        $objectMap.put("resultNameField", resultNameField = new javax.swing.JTextField());
        
        resultNameField.setName("resultNameField");
        resultNameField.setColumns(15);
    }

    protected void createResultRsufiVersion() {
        $objectMap.put("resultRsufiVersion", resultRsufiVersion = new javax.swing.JTextField());
        
        resultRsufiVersion.setName("resultRsufiVersion");
        resultRsufiVersion.setColumns(15);
    }

    protected void createResultZoneCombo() {
        $objectMap.put("resultZoneCombo", resultZoneCombo = new javax.swing.JComboBox());
        
        resultZoneCombo.setName("resultZoneCombo");
        resultZoneCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resultZoneCombo"));
    }

    protected void createResultZoneComboModel() {
        $objectMap.put("resultZoneComboModel", resultZoneComboModel = new ZoneComboBoxModel(getContextValue(fr.ifremer.coser.services.WebService.class)));
    }

    protected void createRsufiResult() {
        $objectMap.put("rsufiResult", rsufiResult = null);
    }

    protected void createSaveResultButton() {
        $objectMap.put("saveResultButton", saveResultButton = new javax.swing.JButton());
        
        saveResultButton.setName("saveResultButton");
        saveResultButton.setText(_("coser.ui.result.validNewResult"));
        saveResultButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveResultButton"));
    }

    protected void createValidatorRSufiResult() {
        $objectMap.put("validatorRSufiResult", validatorRSufiResult = SwingValidatorUtil.newValidator(fr.ifremer.coser.bean.RSufiResult.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(resultNameField), new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(resultRsufiVersion), new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultCreationDate, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultZoneCombo, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(estComIndFileTextField), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(estPopIndFileTextField), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel6, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(mapsDirectoryTextField), new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton2, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel7, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(publiableResultCheckBox, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel8, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 9, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 10, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorRSufiResult();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(otherDataFileList);
        // inline complete setup of $Table1
        $Table1.add($JButton3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton4, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(saveResultButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        resultCreationDate.setDate(new java.util.Date());
        resultZoneCombo.setRenderer(new ZoneComboBoxRenderer());
        otherDataFileList.setModel(otherDataFileListModel);
        // late initializer
        $JDialog0.pack();
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.initUI(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createHandler();
        createRsufiResult();
        createErrorsTableModel();
        createValidatorRSufiResult();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.result.resultName"));
        createResultNameField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = resultNameField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.result.rsufiVersion"));
        createResultRsufiVersion();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = resultRsufiVersion.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.result.creationDate"));
        createResultCreationDate();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.result.zone"));
        createResultZoneComboModel();
        createResultZoneCombo();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.result.estComIndFile"));
        createEstComIndFileTextField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = estComIndFileTextField.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.common.selectFile"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.result.estPopIndFile"));
        createEstPopIndFileTextField();
        // inline creation of $Document3
        $objectMap.put("$Document3", $Document3 = estPopIndFileTextField.getDocument());
        
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document3"));
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document3"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.common.selectFile"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("coser.ui.result.mapsDirectory"));
        createMapsDirectoryTextField();
        // inline creation of $Document4
        $objectMap.put("$Document4", $Document4 = mapsDirectoryTextField.getDocument());
        
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document4"));
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document4"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("coser.ui.common.selectFile"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("coser.ui.result.publiableResult"));
        createPubliableResultCheckBox();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new javax.swing.JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("coser.ui.result.otherDataFile"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createOtherDataFileListModel();
        createOtherDataFileList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("coser.ui.result.addOtherDataFile"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("coser.ui.result.cancel"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        createSaveResultButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setTitle(_("coser.ui.result.newResult"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getRsufiResult() != null) {
                    jaxx.runtime.SwingUtil.setText(resultNameField, getRsufiResult().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESULT_ZONE_COMBO_MODEL, true ,"resultZoneComboModel") {
        
            @Override
            public void processDataBinding() {
                resultZoneCombo.setModel(getResultZoneComboModel());
            }
        });
    }

}