/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.project;

import fr.ifremer.coser.ui.project.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ProjectEditView extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PROJECT = "project";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PROJECT_AUTHOR_TEXT = "projectAuthor.text";
    public static final String BINDING_PROJECT_COMMENT_TEXT = "projectComment.text";
    public static final String BINDING_PROJECT_MAPS_MODEL_MAPS = "projectMapsModel.maps";
    public static final String BINDING_PROJECT_PROJECT_NAME_TEXT = "projectProjectName.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTU8TQRieVgoUBPkIXxEiYGOimC2I0RgaAUGCTUGkhKC9ONsd6JLt7jozC+vF+BP8CXr3YuLNk/Hg2YMX418wxoNX4zuz226XbqGkPWzbmed55nk/9p33v1CCUTR1iF1XoY7J9TJRsst7e4/VQ1Lkq4QVqW5ziyLvE4ujeAF1a9V1xtHVQk7Q0z49vWKVbcskZg17IYe6GH9pEFYihHM0EWYUGUvnq9sLru3QimrVVJTq2z+/42+01+/iCLk2uBuBUCbPYgWRtOVQXNc4GoCTjnDawOYB2KC6eQB+e8TaioEZ28Rl8gK9Qh051G5jCmIcTTcfstSQfNfmqCO1g1WDzHI0s08VfZ+SMqFK0WLwdHTFppbIu7LlfT/UdL6rk2PblgrtwC9hUzMI5ehGE/x1D1xD9wFQgjq6SrBZIQaMPkIplFm63rA0YnCUCaX4CBu6hiFihR1D6pS8eO5WFjcIY/iABPQa5Spzq2Jq5hzKNUF5OZ3jaDTE91hyTyCTVUJnKpvDKjGgCgOizK4P9VYFaLQOOyf+T4T3Bvxs+v5Fo3A0HFLcIS5f04mhRaveilDt8VWXHV6yqFicDgO6UqtW0SlDu0EAY7XHcThNqWzadafNR52WyuaL1DKMLWyKthwJ2Q+2wqw+3+MGtpnfFbNN9KOA53TGT3RCd40aR/3hkgBcwG5W0clU9oHDuWWC28EQ1lsOO62iZQHvRpfh9lmJkWQlDOj1XcPLX5ZDYaiu8suUYIHORNROSl4PktDP8BHx8xQEUjFM0eVQb8PIVIKRGcy0WAElqAPL8DIU6qfsNmx583X0xHwVgnL33/Dg908/P65Vhmo/nD0UCa25E2DYQTZsmEu6OPqSN1EdrhtpKOpCASUZMSAweWGMRxjL+9tgDs6TLaAIurKOWQkkEh0/Pn8Zfv7tAoqvoS7DwtoaFvhHKMlLFLJgGZprLy5JRxePO+HZJ7xx1K5aVBMDszcDcwNPqrqpQYHuu5CE8YgkVJ2oya9/B/MfliqJiIGxsYbwIBmJZ6hdNw3dJPJ+8a+OyPuk22bE0azgioi6NGLie8z2OyUrn5tRkbaJ1x+mUsY7fRJzuMxUhxOIVZC2ZRDi147UHD9TUyzviceTaIUrTbjqIKaYwDIPT6Nlplo2cg6FBh5SLXu41rKHmWaKXMYepoGL2SY0EmUxf08RmW85lDtNKaineLjXsofWFRaaKQi1jtkpGostN9Y5FBp4WAWF/0cZFw3rCwAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    private static final Log log = LogFactory.getLog(fr.ifremer.coser.ui.project.ProjectEditView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorsTableModel;
    protected fr.ifremer.coser.ui.project.ProjectHandler handler;
    protected fr.ifremer.coser.bean.Project project;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "author",  editorName = "projectAuthor")
    protected javax.swing.JTextField projectAuthor;
    protected javax.swing.JTextArea projectComment;
    protected javax.swing.JList projectMaps;
    protected fr.ifremer.coser.ui.project.ProjectMapsListModel projectMapsModel;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "name",  editorName = "projectProjectName")
    protected javax.swing.JTextField projectProjectName;
    protected javax.swing.JButton saveProjectButton;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorProject")
    protected jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.bean.Project > validatorProject;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ProjectEditView $Table0 = this;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.text.Document $Document0;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.text.Document $Document1;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ProjectEditView() {
        $initialize();
    }

    public ProjectEditView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInsertUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getProject().setComment(projectComment.getText());
    }

    public void doRemoveUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getProject().setComment(projectComment.getText());
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getProject().setAuthor(projectAuthor.getText());
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().selectMapFiles(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().removeSelectedMapFiles(this);
    }

    public void doActionPerformed__on__saveProjectButton(java.awt.event.ActionEvent event) {
        getHandler().saveProject(this);
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getProject().setAuthor(projectAuthor.getText());
    }

    public void doTableChanged__on__errorsTableModel(javax.swing.event.TableModelEvent event) {
        saveProjectButton.setEnabled(errorsTableModel.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public fr.ifremer.coser.ui.project.ProjectHandler getHandler() {
        return handler;
    }

    public fr.ifremer.coser.bean.Project getProject() {
        return project;
    }

    public javax.swing.JTextField getProjectAuthor() {
        return projectAuthor;
    }

    public javax.swing.JTextArea getProjectComment() {
        return projectComment;
    }

    public javax.swing.JList getProjectMaps() {
        return projectMaps;
    }

    public fr.ifremer.coser.ui.project.ProjectMapsListModel getProjectMapsModel() {
        return projectMapsModel;
    }

    public javax.swing.JTextField getProjectProjectName() {
        return projectProjectName;
    }

    public javax.swing.JButton getSaveProjectButton() {
        return saveProjectButton;
    }

    public jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.bean.Project > getValidatorProject() {
        return validatorProject;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$Document1(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document1;
        this.$Document1 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, newValue);
    }

    public void setHandler(fr.ifremer.coser.ui.project.ProjectHandler newValue) {
        fr.ifremer.coser.ui.project.ProjectHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setProject(fr.ifremer.coser.bean.Project newValue) {
        fr.ifremer.coser.bean.Project oldValue = this.project;
        this.project = newValue;
        firePropertyChange(PROPERTY_PROJECT, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.installFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.text.Document get$Document1() {
        return $Document1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToValidatorProject() {
        if (!allComponentsCreated) {
            return;
        }
        validatorProject.setErrorTableModel(errorsTableModel);
        validatorProject.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validatorProject.setBean(project);
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        
        errorsTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorsTableModel"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createProject() {
        $objectMap.put("project", project = null);
    }

    protected void createProjectAuthor() {
        $objectMap.put("projectAuthor", projectAuthor = new javax.swing.JTextField());
        
        projectAuthor.setName("projectAuthor");
        projectAuthor.setColumns(15);
    }

    protected void createProjectComment() {
        $objectMap.put("projectComment", projectComment = new javax.swing.JTextArea());
        
        projectComment.setName("projectComment");
        projectComment.setColumns(15);
        projectComment.setLineWrap(true);
        projectComment.setWrapStyleWord(true);
        projectComment.setRows(3);
    }

    protected void createProjectMaps() {
        $objectMap.put("projectMaps", projectMaps = new javax.swing.JList());
        
        projectMaps.setName("projectMaps");
    }

    protected void createProjectMapsModel() {
        $objectMap.put("projectMapsModel", projectMapsModel = new fr.ifremer.coser.ui.project.ProjectMapsListModel());
    }

    protected void createProjectProjectName() {
        $objectMap.put("projectProjectName", projectProjectName = new javax.swing.JTextField());
        
        projectProjectName.setName("projectProjectName");
        projectProjectName.setColumns(15);
        projectProjectName.setEnabled(false);
    }

    protected void createSaveProjectButton() {
        $objectMap.put("saveProjectButton", saveProjectButton = new javax.swing.JButton());
        
        saveProjectButton.setName("saveProjectButton");
        saveProjectButton.setText(_("coser.ui.project.saveProject"));
        saveProjectButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveProjectButton"));
    }

    protected void createValidatorProject() {
        $objectMap.put("validatorProject", validatorProject = SwingValidatorUtil.newValidator(fr.ifremer.coser.bean.Project.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorProject();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectProjectName), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectAuthor), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 2, 2, 2, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(saveProjectButton, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(projectMaps);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(projectComment);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(_("coser.ui.project.editProject")));
        $JLabel1.setText(_(getContextValue(fr.ifremer.coser.CoserConfig.class).getProjectsDirectory().getAbsolutePath() + File.separator));
        projectMaps.setModel(projectMapsModel);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.initUI(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createProject();
        createErrorsTableModel();
        createValidatorProject();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.project.projectname"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        createProjectProjectName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.project.projectauthor"));
        createProjectAuthor();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = projectAuthor.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.project.maps"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createProjectMapsModel();
        createProjectMaps();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.project.addMaps"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.project.removeMaps"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.project.projectcomment"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createProjectComment();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = projectComment.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        createSaveProjectButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_PROJECT_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    jaxx.runtime.SwingUtil.setText(projectProjectName, getProject().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_AUTHOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("author", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    jaxx.runtime.SwingUtil.setText(projectAuthor, getProject().getAuthor());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("author", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_MAPS_MODEL_MAPS, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("maps", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    projectMapsModel.setMaps(getProject().getMaps());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("maps", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON1_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProjectMaps() != null) {
                    $bindingSources.put("getProjectMaps().getSelectionModel()", getProjectMaps().getSelectionModel());
                    getProjectMaps().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    getProjectMaps().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectEditView.this, BINDING_$JBUTTON1_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProjectMaps() != null && getProjectMaps().getSelectedIndices() != null) {
                    $JButton1.setEnabled(getProjectMaps().getSelectedIndices().length != 0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProjectMaps() != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("getProjectMaps().getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    getProjectMaps().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectEditView.this, BINDING_$JBUTTON1_ENABLED));
                }
            }
        
            public void $pr$u0(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_COMMENT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    jaxx.runtime.SwingUtil.setText(projectComment, getProject().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("comment", this);
                }
            }
        });
    }

}