/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.option;

import fr.ifremer.coser.ui.option.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ValidatorDialog extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVQW8TRxiduDjBTiAhVgOIVE0hB4Rg3LTqKQgoCRG1TEBJhCLMgbF34kwYz0xnvo2XS9Wf0J/Q3ntB4tZT1UPPPfRS9S9UVQ+9Vv1m1/FmycassA+73vnee/Pm25m3P/5Fys6STw5YFFEbKhA9Thtf7u4+bh/wDqxz17HCgLYk+U2USKlFpoPhuANyrdX09PqAXl/TPaMVV8fYq01SdfBKcrfPOQD5KMvoOFffHpZXIxPaI9WhqTzV7//5u/Rd8O0PJUIig+4u4FKW3sVKV3KmSUoiADKPMx2yumSqizasUF30e86PrUnm3Cbr8a/JN2SqSSYNsygG5GrxJccaMT8yQCrLjXXBpO5+CuTGnqViz/Iet7SjHV5DQbUBoRV9yqQIGOokaGNiiUkgU/tMBZJbINdH0B/Ht4cJNCXXlF7TRvBgR68L97LJXnmhRW279ADf6UvQhh5E0g/Txm5c9sxKOvvyDmtLjuYvZfrs+tg1Gtc8cnZIOLvcaLI2l8iY9x2NBtBk1IPmT2BX/PPF/NpnObVzy43tjtVSPmHKW7uYmSgtZVm1w6MWux3L+SMdcAmEFnknKSFt7fmsHJALGRd+zCMXh4S5AQGVHwQCeUA+9i9ChfigaF8EXQ6UxyWaIE60xK/qZGvj0SwWt939EFAXwbUMOBn2sOtD9GzHcgZ8k/fT6q0spOrYIT+1OoOt4XB6fWhn5XjRkiuZTYWxQNNYSM/tRIuUbYjDuAtbJ5NkC0tJhlx6K0O8YFz9b6H2+09/vtk4Hhwf5kKP5R4eaGO1wRMj/NSzSWqEIGT9ETOrLVJxuOpOEoqLOca2B2U0h/PF+4N6On3I3D5KlKf++PmXhRe/fUBKG6QqNQs2mMd/RSqwb7ELWgaRuXsvdjTTP4vXOe8NSBkEYMPJ/G2hpFB8iQHmWDsEfifCPizm9GFopl359d/a9ut7R72YQG+XT4Wn/Sg/I5PJbHGMDhIyNzanjeNhoNMkzMvGCX+vmsGJWo2vd/MWW93TCm7FfI+5H4X+thZb9/8exEoLBZTOAI9gLA0/vDlC4fLYClcKrGOmw6Xc4irg1uf5+dsYK2ypLVSAR/xOvu61Arrlns84X37+/iLTVmt4Kpxoj3xfRaTm8Aj03RbqJV82N5beuzp/s4CjKa78Ny8YIVMf20gxhVEbeWVsD8UURnn4fGwP4yt8gQr/A1XIELLzCgAA";
    private static final Log log = LogFactory.getLog(fr.ifremer.coser.ui.option.ValidatorDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton createNewButton;
    protected javax.swing.JButton deleteButton;
    protected fr.ifremer.coser.ui.option.OptionHandler handler;
    protected org.jdesktop.jxlayer.JXLayer noCopiedToDiskLayer;
    protected javax.swing.JButton saveButton;
    protected org.nuiton.widget.editor.Editor validationEditor;
    protected javax.swing.JTree validatorsTree;
    protected fr.ifremer.coser.ui.option.ValidatorsTreeModel validatorsTreeModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ValidatorDialog $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ValidatorDialog() {
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().restoreDefaults(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        dispose();
    }

    public void doActionPerformed__on__createNewButton(java.awt.event.ActionEvent event) {
        getHandler().createNew(this);
    }

    public void doActionPerformed__on__deleteButton(java.awt.event.ActionEvent event) {
        getHandler().deleteValidator(this);
    }

    public void doActionPerformed__on__saveButton(java.awt.event.ActionEvent event) {
        getHandler().saveValidator(this);
    }

    public void doValueChanged__on__validatorsTree(javax.swing.event.TreeSelectionEvent event) {
        getHandler().selectValidator(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCreateNewButton() {
        return createNewButton;
    }

    public javax.swing.JButton getDeleteButton() {
        return deleteButton;
    }

    public fr.ifremer.coser.ui.option.OptionHandler getHandler() {
        return handler;
    }

    public org.jdesktop.jxlayer.JXLayer getNoCopiedToDiskLayer() {
        return noCopiedToDiskLayer;
    }

    public javax.swing.JButton getSaveButton() {
        return saveButton;
    }

    public org.nuiton.widget.editor.Editor getValidationEditor() {
        return validationEditor;
    }

    public javax.swing.JTree getValidatorsTree() {
        return validatorsTree;
    }

    public fr.ifremer.coser.ui.option.ValidatorsTreeModel getValidatorsTreeModel() {
        return validatorsTreeModel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(fr.ifremer.coser.ui.option.OptionHandler newValue) {
        fr.ifremer.coser.ui.option.OptionHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNoCopiedToDiskLayer() {
        if (!allComponentsCreated) {
            return;
        }
        noCopiedToDiskLayer.add($Table0);
    }

    protected void createCreateNewButton() {
        $objectMap.put("createNewButton", createNewButton = new javax.swing.JButton());
        
        createNewButton.setName("createNewButton");
        createNewButton.setEnabled(false);
        createNewButton.setText(_("coser.ui.validators.createNew"));
        createNewButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createNewButton"));
    }

    protected void createDeleteButton() {
        $objectMap.put("deleteButton", deleteButton = new javax.swing.JButton());
        
        deleteButton.setName("deleteButton");
        deleteButton.setEnabled(false);
        deleteButton.setText(_("coser.ui.validators.deleteValidator"));
        deleteButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__deleteButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createNoCopiedToDiskLayer() {
        $objectMap.put("noCopiedToDiskLayer", noCopiedToDiskLayer = new org.jdesktop.jxlayer.JXLayer());
        
        noCopiedToDiskLayer.setName("noCopiedToDiskLayer");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new javax.swing.JButton());
        
        saveButton.setName("saveButton");
        saveButton.setEnabled(false);
        saveButton.setText(_("coser.ui.validators.saveValidator"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createValidationEditor() {
        $objectMap.put("validationEditor", validationEditor = new org.nuiton.widget.editor.Editor());
        
        validationEditor.setName("validationEditor");
    }

    protected void createValidatorsTree() {
        $objectMap.put("validatorsTree", validatorsTree = new javax.swing.JTree());
        
        validatorsTree.setName("validatorsTree");
        validatorsTree.setRootVisible(false);
        validatorsTree.setShowsRootHandles(true);
        validatorsTree.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__validatorsTree"));
    }

    protected void createValidatorsTreeModel() {
        $objectMap.put("validatorsTreeModel", validatorsTreeModel = new fr.ifremer.coser.ui.option.ValidatorsTreeModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add(noCopiedToDiskLayer);
        addChildrenToNoCopiedToDiskLayer();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(validationEditor, new GridBagConstraints(1, 2, 1, 1, 2.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(validatorsTree);
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add(createNewButton);
        $JPanel0.add(saveButton);
        $JPanel0.add(deleteButton);
        $JPanel0.add($JButton1);
        
        // apply 2 property setters
        validatorsTree.setCellRenderer(new ValidatorsTreeRenderer());
        validatorsTree.setModel(validatorsTreeModel);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createHandler();
        createNoCopiedToDiskLayer();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.ITALIC));
        }
        $JLabel0.setText(_("coser.ui.validators.description"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.validators.validators"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.validators.content"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createValidatorsTreeModel();
        createValidatorsTree();
        createValidationEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.validators.restoredefaults"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createCreateNewButton();
        createSaveButton();
        createDeleteButton();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.validators.close"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JDialog0
        setName("$JDialog0");
        setTitle(_("coser.ui.validators.title"));
        
        $completeSetup();
    }

}