package fr.ifremer.coselmar.persistence.entity;

import fr.ifremer.coselmar.persistence.AbstractCoselmarTopiaDao;
import fr.ifremer.coselmar.persistence.CoselmarEntityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Fri Jan 30 14:13:46 UTC 2015")
public abstract class GeneratedQuestionTopiaDao<E extends Question> extends AbstractCoselmarTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Question.class;
    }

    @Override
    public CoselmarEntityEnum getTopiaEntityEnum() {
        return CoselmarEntityEnum.Question;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            CoselmarUserGroupTopiaDao dao = topiaDaoSupplier
                    .getDao(CoselmarUserGroup.class, CoselmarUserGroupTopiaDao.class);
            List<CoselmarUserGroup> list = dao
                    .forProperties(CoselmarUserGroup.PROPERTY_QUESTION, entity)
                    .findAll();
            for (CoselmarUserGroup item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getQuestion())) {
                    item.setQuestion(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM question main, children_parents secondary " +
                    " WHERE main.topiaId=secondary.children " +
                    " AND secondary.parents='" + entity.getTopiaId() + "'";
            List<Question> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", CoselmarEntityEnum.Question.getImplementation())
                    .list();

            for (Question item : list) {
                item.removeParents(entity);
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTitleIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_TITLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTitleEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_TITLE, v);
        return result;
    }

    @Deprecated
    public E findByTitle(String v) {
        return forTitleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTitle(String v) {
        return forTitleEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(String v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(String v) {
        return forTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSummaryIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_SUMMARY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSummaryEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_SUMMARY, v);
        return result;
    }

    @Deprecated
    public E findBySummary(String v) {
        return forSummaryEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySummary(String v) {
        return forSummaryEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSubmissionDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_SUBMISSION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSubmissionDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_SUBMISSION_DATE, v);
        return result;
    }

    @Deprecated
    public E findBySubmissionDate(Date v) {
        return forSubmissionDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySubmissionDate(Date v) {
        return forSubmissionDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDeadlineIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_DEADLINE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDeadlineEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_DEADLINE, v);
        return result;
    }

    @Deprecated
    public E findByDeadline(Date v) {
        return forDeadlineEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDeadline(Date v) {
        return forDeadlineEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forThemeContains(String v) {
        return forContains(Question.PROPERTY_THEME, v);
    }

    @Deprecated
    public E findContainsTheme(String v) {
        return forThemeContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsTheme(String v) {
        return forThemeContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClosingDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_CLOSING_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClosingDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_CLOSING_DATE, v);
        return result;
    }

    @Deprecated
    public E findByClosingDate(Date v) {
        return forClosingDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByClosingDate(Date v) {
        return forClosingDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExternalExpertsContains(String v) {
        return forContains(Question.PROPERTY_EXTERNAL_EXPERTS, v);
    }

    @Deprecated
    public E findContainsExternalExperts(String v) {
        return forExternalExpertsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsExternalExperts(String v) {
        return forExternalExpertsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUnavailableIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_UNAVAILABLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUnavailableEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_UNAVAILABLE, v);
        return result;
    }

    @Deprecated
    public E findByUnavailable(boolean v) {
        return forUnavailableEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUnavailable(boolean v) {
        return forUnavailableEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConclusionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_CONCLUSION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConclusionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_CONCLUSION, v);
        return result;
    }

    @Deprecated
    public E findByConclusion(String v) {
        return forConclusionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByConclusion(String v) {
        return forConclusionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParticipantsIn(Collection<CoselmarUserGroup> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_PARTICIPANTS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParticipantsEquals(CoselmarUserGroup v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_PARTICIPANTS, v);
        return result;
    }

    @Deprecated
    public E findByParticipants(CoselmarUserGroup v) {
        return forParticipantsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByParticipants(CoselmarUserGroup v) {
        return forParticipantsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClosingDocumentsContains(Document v) {
        return forContains(Question.PROPERTY_CLOSING_DOCUMENTS, v);
    }

    @Deprecated
    public E findContainsClosingDocuments(Document v) {
        return forClosingDocumentsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsClosingDocuments(Document v) {
        return forClosingDocumentsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSupervisorsContains(CoselmarUser v) {
        return forContains(Question.PROPERTY_SUPERVISORS, v);
    }

    @Deprecated
    public E findContainsSupervisors(CoselmarUser v) {
        return forSupervisorsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsSupervisors(CoselmarUser v) {
        return forSupervisorsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContributorsContains(CoselmarUser v) {
        return forContains(Question.PROPERTY_CONTRIBUTORS, v);
    }

    @Deprecated
    public E findContainsContributors(CoselmarUser v) {
        return forContributorsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsContributors(CoselmarUser v) {
        return forContributorsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParentsContains(Question v) {
        return forContains(Question.PROPERTY_PARENTS, v);
    }

    @Deprecated
    public E findContainsParents(Question v) {
        return forParentsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsParents(Question v) {
        return forParentsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClientsContains(CoselmarUser v) {
        return forContains(Question.PROPERTY_CLIENTS, v);
    }

    @Deprecated
    public E findContainsClients(CoselmarUser v) {
        return forClientsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsClients(CoselmarUser v) {
        return forClientsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPrivacyIn(Collection<Privacy> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_PRIVACY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPrivacyEquals(Privacy v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_PRIVACY, v);
        return result;
    }

    @Deprecated
    public E findByPrivacy(Privacy v) {
        return forPrivacyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPrivacy(Privacy v) {
        return forPrivacyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRelatedDocumentsContains(Document v) {
        return forContains(Question.PROPERTY_RELATED_DOCUMENTS, v);
    }

    @Deprecated
    public E findContainsRelatedDocuments(Document v) {
        return forRelatedDocumentsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsRelatedDocuments(Document v) {
        return forRelatedDocumentsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStatusIn(Collection<Status> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Question.PROPERTY_STATUS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStatusEquals(Status v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Question.PROPERTY_STATUS, v);
        return result;
    }

    @Deprecated
    public E findByStatus(Status v) {
        return forStatusEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStatus(Status v) {
        return forStatusEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == CoselmarUserGroup.class) {
            CoselmarUserGroupTopiaDao dao =
                topiaDaoSupplier.getDao(CoselmarUserGroup.class, CoselmarUserGroupTopiaDao.class);
            tmp = dao.forQuestionEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Question.class) {
            QuestionTopiaDao dao =
                topiaDaoSupplier.getDao(Question.class, QuestionTopiaDao.class);
            tmp = dao.forParentsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(CoselmarUserGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(CoselmarUserGroup.class, list);
        }

        list = findUsages(Question.class, entity);
        if (!list.isEmpty()) {
            result.put(Question.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedQuestionTopiaDao<E extends Question>
