/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.util;

import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.util.CleanStatus;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.StringUtils;

public class GitHelper {
    public static boolean isMergedInto(Git git, String commitString, String baseBranch) throws LocalBranchMissingException, JGitFlowIOException, JGitFlowGitAPIException {
        RevCommit branchCommit = GitHelper.getCommitForString(git, commitString);
        return GitHelper.isMergedInto(git, branchCommit, baseBranch);
    }

    public static RevCommit getCommitForString(Git git, String commitId) throws JGitFlowIOException, LocalBranchMissingException {
        RevWalk walk = null;
        try {
            ObjectId commit = git.getRepository().resolve(commitId);
            if (null == commit) {
                throw new LocalBranchMissingException("commit " + commitId + " does not exist");
            }
            walk = new RevWalk(git.getRepository());
            walk.setRetainBody(true);
            RevCommit revCommit = walk.parseCommit((AnyObjectId)commit);
            return revCommit;
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
        finally {
            if (null != walk) {
                walk.release();
            }
        }
    }

    public static boolean isMergedInto(Git git, RevCommit commit, String branchName) throws JGitFlowGitAPIException, JGitFlowIOException {
        Repository repo = git.getRepository();
        try {
            ObjectId base = repo.resolve(branchName);
            if (null == base) {
                return false;
            }
            Iterable baseCommits = git.log().add((AnyObjectId)base).call();
            boolean merged = false;
            for (RevCommit entry : baseCommits) {
                if (entry.getId().equals((AnyObjectId)commit)) {
                    merged = true;
                    break;
                }
                if (entry.getParentCount() <= 1 || !Arrays.asList(entry.getParents()).contains(commit)) continue;
                merged = true;
                break;
            }
            return merged;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
    }

    public static RevCommit getLatestCommit(Git git, String branchName) throws JGitFlowIOException {
        RevWalk walk = null;
        try {
            ObjectId branch = git.getRepository().resolve(branchName);
            walk = new RevWalk(git.getRepository());
            walk.setRetainBody(true);
            RevCommit revCommit = walk.parseCommit((AnyObjectId)branch);
            return revCommit;
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
        finally {
            if (null != walk) {
                walk.release();
            }
        }
    }

    public static boolean localBranchExists(Git git, String branchName) throws JGitFlowGitAPIException {
        boolean exists = false;
        if (StringUtils.isEmptyOrNull((String)branchName)) {
            return exists;
        }
        try {
            List refs = git.branchList().setListMode(null).call();
            for (Ref ref : refs) {
                String simpleName = ref.getName().substring(ref.getName().indexOf("refs/heads/") + "refs/heads/".length());
                if (!simpleName.equals(branchName)) continue;
                exists = true;
                break;
            }
            return exists;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
    }

    public static boolean remoteBranchExists(Git git, String branch, JGitFlowReporter reporter) throws JGitFlowGitAPIException {
        reporter.debugMethod(GitHelper.getName(), "remoteBranchExists");
        reporter.debugText(GitHelper.getName(), "checking for branch: " + branch);
        boolean exists = false;
        if (StringUtils.isEmptyOrNull((String)branch)) {
            return exists;
        }
        try {
            List refs = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
            reporter.debugText(GitHelper.getName(), "got " + refs.size() + " remote refs");
            for (Ref ref : refs) {
                reporter.debugText(GitHelper.getName(), "ref name: " + ref.getName());
                if (!ref.getName().contains("refs/remotes/origin/")) continue;
                String simpleName = ref.getName().substring(ref.getName().indexOf("refs/remotes/origin/") + "refs/remotes/origin/".length());
                reporter.debugText(GitHelper.getName(), "ref simple name: " + simpleName);
                reporter.debugText(GitHelper.getName(), "simple name equals branch? " + simpleName.equals(branch));
                if (!simpleName.equals(branch)) continue;
                exists = true;
                break;
            }
            boolean bl = exists;
            return bl;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        finally {
            reporter.endMethod();
            reporter.flush();
        }
    }

    public static boolean localBranchBehindRemote(Git git, String branch, JGitFlowReporter reporter) throws JGitFlowIOException {
        RevWalk walk = new RevWalk(git.getRepository());
        walk.setRetainBody(true);
        boolean behind = false;
        try {
            Ref remote = GitHelper.getRemoteBranch(git, branch);
            Ref local = GitHelper.getLocalBranch(git, branch);
            Preconditions.checkNotNull(remote);
            Preconditions.checkNotNull(local);
            ObjectId remoteId = git.getRepository().resolve(remote.getObjectId().getName());
            RevCommit remoteCommit = walk.parseCommit((AnyObjectId)remoteId);
            RevCommit localCommit = walk.parseCommit((AnyObjectId)local.getObjectId());
            if (!localCommit.equals((AnyObjectId)remoteCommit)) {
                reporter.debugText(GitHelper.getName(), localCommit.getName() + " !equals " + remoteCommit.getName());
                behind = true;
                walk.setRevFilter(RevFilter.MERGE_BASE);
                walk.markStart(localCommit);
                walk.markStart(remoteCommit);
                RevCommit base = walk.next();
                reporter.debugText(GitHelper.getName(), "checking if remote is at our merge base");
                if (null != base) {
                    walk.parseBody((RevObject)base);
                    if (remoteCommit.equals((AnyObjectId)base)) {
                        reporter.debugText(GitHelper.getName(), "remote equals merge base, branch is newer");
                        behind = false;
                    }
                }
            }
        }
        catch (IOException e) {
            reporter.errorText(GitHelper.getName(), e.getMessage());
            reporter.endMethod();
            reporter.flush();
            throw new JGitFlowIOException(e);
        }
        finally {
            walk.release();
        }
        return behind;
    }

    public static Ref getRemoteBranch(Git git, String branchName) throws JGitFlowIOException {
        try {
            Map refList = git.getRepository().getRefDatabase().getRefs("refs/remotes/");
            Ref remote = null;
            for (Map.Entry entry : refList.entrySet()) {
                String simpleName;
                int index = ((Ref)entry.getValue()).getName().indexOf("refs/remotes/origin/");
                if (index < 0 || !(simpleName = ((Ref)entry.getValue()).getName().substring(index + "refs/remotes/origin/".length())).equals(branchName)) continue;
                remote = (Ref)entry.getValue();
                break;
            }
            return remote;
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
    }

    public static Ref getLocalBranch(Git git, String branchName) throws JGitFlowIOException {
        try {
            Ref ref2check = git.getRepository().getRef(branchName);
            Ref local = null;
            if (ref2check != null && ref2check.getName().startsWith("refs/heads/")) {
                local = ref2check;
            }
            return local;
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
    }

    public static List<Ref> listBranchesWithPrefix(Git git, String prefix, JGitFlowReporter reporter) throws JGitFlowGitAPIException {
        ArrayList<Ref> branches = new ArrayList<Ref>();
        reporter.debugMethod(GitHelper.getName(), "listBranchesWithPrefix");
        try {
            List refs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            for (Ref ref : refs) {
                String originPrefix = "refs/remotes/origin/";
                String simpleName = ref.getName().indexOf("refs/heads/") > -1 ? ref.getName().substring(ref.getName().indexOf("refs/heads/") + "refs/heads/".length()) : (ref.getName().indexOf(originPrefix) > -1 ? ref.getName().substring(ref.getName().indexOf(originPrefix) + originPrefix.length()) : "");
                reporter.debugText(GitHelper.getName(), "simple name [" + simpleName + "] startsWith prefix [" + prefix + "] ? " + simpleName.startsWith(prefix));
                if (!simpleName.startsWith(prefix)) continue;
                branches.add(ref);
            }
            ArrayList<Ref> arrayList = branches;
            return arrayList;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        finally {
            reporter.endMethod();
        }
    }

    public static CleanStatus workingTreeIsClean(Git git, boolean allowUntracked, JGitFlowReporter reporter) throws JGitFlowIOException, JGitFlowGitAPIException {
        reporter.debugMethod(GitHelper.getName(), "workingTreeIsClean");
        try {
            IndexDiff diffIndex = new IndexDiff(git.getRepository(), "HEAD", (WorkingTreeIterator)new FileTreeIterator(git.getRepository()));
            if (diffIndex.diff()) {
                int addedSize = diffIndex.getAdded().size();
                int assumedSize = diffIndex.getAssumeUnchanged().size();
                int changedSize = diffIndex.getChanged().size();
                int conflictSize = diffIndex.getConflicting().size();
                int ignoredSize = diffIndex.getIgnoredNotInIndex().size();
                int missingSize = diffIndex.getMissing().size();
                int modifiedSize = diffIndex.getModified().size();
                int removedSize = diffIndex.getRemoved().size();
                int untrackedSize = diffIndex.getUntracked().size();
                int untrackedFolderSize = diffIndex.getUntrackedFolders().size();
                boolean changed = false;
                boolean untracked = false;
                StringBuilder sb = new StringBuilder();
                reporter.debugText(GitHelper.getName(), "diffIndex.diff() returned diffs. working tree is dirty!");
                reporter.debugText(GitHelper.getName(), "added size: " + addedSize);
                GitHelper.reportDirtyDetails(GitHelper.getName(), "added", diffIndex.getAdded(), reporter);
                reporter.debugText(GitHelper.getName(), "assume unchanged size: " + assumedSize);
                reporter.debugText(GitHelper.getName(), "changed size: " + changedSize);
                GitHelper.reportDirtyDetails(GitHelper.getName(), "changed", diffIndex.getChanged(), reporter);
                reporter.debugText(GitHelper.getName(), "conflicting size: " + conflictSize);
                GitHelper.reportDirtyDetails(GitHelper.getName(), "conflicting", diffIndex.getConflicting(), reporter);
                reporter.debugText(GitHelper.getName(), "ignored not in index size: " + ignoredSize);
                reporter.debugText(GitHelper.getName(), "missing size: " + missingSize);
                GitHelper.reportDirtyDetails(GitHelper.getName(), "missing", diffIndex.getMissing(), reporter);
                reporter.debugText(GitHelper.getName(), "modified size: " + modifiedSize);
                GitHelper.reportDirtyDetails(GitHelper.getName(), "modified", diffIndex.getModified(), reporter);
                reporter.debugText(GitHelper.getName(), "removed size: " + removedSize);
                GitHelper.reportDirtyDetails(GitHelper.getName(), "removed", diffIndex.getRemoved(), reporter);
                reporter.debugText(GitHelper.getName(), "untracked size: " + untrackedSize);
                GitHelper.reportDirtyDetails(GitHelper.getName(), "untracked", diffIndex.getUntracked(), reporter);
                reporter.debugText(GitHelper.getName(), "untracked folders size: " + untrackedFolderSize);
                GitHelper.reportDirtyDetails(GitHelper.getName(), "untracked folders", diffIndex.getUntrackedFolders(), reporter);
                reporter.endMethod();
                if (addedSize > 0 || changedSize > 0 || conflictSize > 0 || missingSize > 0 || modifiedSize > 0 || removedSize > 0) {
                    changed = true;
                    sb.append("Working tree has uncommitted changes");
                }
                if (!(allowUntracked || untrackedSize <= 0 && untrackedFolderSize <= 0)) {
                    if (ignoredSize > 0) {
                        Set ignores = diffIndex.getIgnoredNotInIndex();
                        if (untrackedSize > 0) {
                            Set utFiles = diffIndex.getUntracked();
                            utFiles.removeAll(ignores);
                            untrackedSize = utFiles.size();
                        }
                        if (untrackedFolderSize > 0) {
                            Set utFolders = diffIndex.getUntrackedFolders();
                            utFolders.removeAll(ignores);
                            untrackedFolderSize = utFolders.size();
                        }
                    }
                    if (untrackedSize > 0 || untrackedFolderSize > 0) {
                        untracked = true;
                    }
                    if (!changed) {
                        sb.append("Working tree has untracked files");
                    } else {
                        sb.append(" and untracked files");
                    }
                }
                return new CleanStatus(untracked, changed, sb.toString());
            }
            reporter.debugText(GitHelper.getName(), "working tree is clean");
            reporter.endMethod();
            return new CleanStatus(false, false, "Working tree is clean");
        }
        catch (IOException e) {
            reporter.errorText(GitHelper.getName(), e.getMessage());
            reporter.endMethod();
            reporter.flush();
            throw new JGitFlowIOException(e);
        }
    }

    private static void reportDirtyDetails(String cmdName, String reason, Set<String> files, JGitFlowReporter reporter) {
        if (files.size() > 0) {
            reporter.debugText(cmdName, reason + " details: ");
            for (String file : files) {
                reporter.debugText(cmdName, " -- " + reason + ": " + file);
            }
        }
    }

    public static boolean tagExists(Git git, String tagName) throws JGitFlowGitAPIException {
        boolean exists = false;
        if (StringUtils.isEmptyOrNull((String)tagName)) {
            return exists;
        }
        try {
            List refs = git.tagList().call();
            for (Ref ref : refs) {
                String simpleName = ref.getName().substring(ref.getName().indexOf("refs/tags/") + "refs/tags/".length());
                if (!simpleName.equals(tagName)) continue;
                exists = true;
                break;
            }
            return exists;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
    }

    private static String getName() {
        return GitHelper.class.getSimpleName();
    }
}

