/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.report.JGitFlowReportEntry;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;

public class JGitFlowReporter {
    public static final String EOL = System.getProperty("line.separator");
    public static final String P = EOL.concat(EOL);
    public static final String HR = P.concat(Strings.repeat((String)"-", (int)80)).concat(P);
    public static final int PAD = 4;
    private boolean wroteHeader = false;
    private boolean clearLog = false;
    private String header;
    private File logDir;
    private String startTime;
    private int indent;
    private List<JGitFlowReportEntry> entries = Lists.newArrayList();
    private List<JGitFlowReportEntry> allEntries = Lists.newArrayList();

    public JGitFlowReporter() {
        Date now = new Date();
        SimpleDateFormat displayFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss zzz");
        this.startTime = displayFormat.format(now);
        this.indent = 0;
    }

    public void setGitFlowConfiguration(Git git, GitFlowConfiguration config) {
        this.logDir = git.getRepository().getDirectory();
        this.header = this.generateHeader(git, config);
        this.flush();
    }

    public JGitFlowReporter debugCommandCall(String shortName) {
        this.entries.add(new JGitFlowReportEntry(shortName, Strings.repeat((String)" ", (int)this.indent) + "## _Command call():_ ", true, false));
        this.indent += 4;
        return this;
    }

    public JGitFlowReporter debugText(String shortName, String text) {
        this.entries.add(new JGitFlowReportEntry(shortName, Strings.repeat((String)" ", (int)this.indent) + "_ " + text + " _", true, false));
        return this;
    }

    public JGitFlowReporter errorText(String shortName, String text) {
        this.entries.add(new JGitFlowReportEntry(shortName, Strings.repeat((String)" ", (int)this.indent) + "** " + text + " **", false, true));
        return this;
    }

    public JGitFlowReporter commandCall(String shortName) {
        this.entries.add(new JGitFlowReportEntry(shortName, Strings.repeat((String)" ", (int)this.indent) + "## Command call(): ", false, false));
        this.indent += 4;
        return this;
    }

    public JGitFlowReporter endCommand() {
        this.indent -= 4;
        if (this.indent < 0) {
            this.indent = 0;
        }
        this.flush();
        return this;
    }

    public JGitFlowReporter clearLog() {
        this.clearLog = true;
        return this;
    }

    public JGitFlowReporter endMethod() {
        this.indent -= 4;
        if (this.indent < 0) {
            this.indent = 0;
        }
        this.entries.add(new JGitFlowReportEntry("", Strings.repeat((String)" ", (int)this.indent) + "_method END:_ ", true, false));
        this.flush();
        return this;
    }

    public JGitFlowReporter debugMethod(String shortName, String text) {
        this.entries.add(new JGitFlowReportEntry(shortName, Strings.repeat((String)" ", (int)this.indent) + "_method start:_ " + text, true, false));
        this.indent += 4;
        return this;
    }

    public JGitFlowReporter infoText(String shortName, String text) {
        this.entries.add(new JGitFlowReportEntry(shortName, Strings.repeat((String)" ", (int)this.indent) + text, false, false));
        return this;
    }

    public JGitFlowReporter mergeResult(String shortName, MergeResult mergeResult) {
        StringBuilder sb = new StringBuilder();
        sb.append(Strings.repeat((String)" ", (int)this.indent)).append("### Merge Result").append(EOL).append(mergeResult.toString());
        this.entries.add(new JGitFlowReportEntry(shortName, sb.toString(), false, false));
        return this;
    }

    public synchronized void flush() {
        if (null == this.logDir || !".git".equals(this.logDir.getName())) {
            return;
        }
        File logFile = new File(this.logDir, "jgitflow.log");
        Charset utf8 = Charset.forName("UTF-8");
        try {
            if (this.clearLog && null != this.logDir && this.logDir.exists()) {
                if (logFile.exists()) {
                    logFile.delete();
                }
                Files.touch((File)logFile);
                this.clearLog = false;
            }
            if (!this.clearLog && null == this.logDir || !logFile.exists()) {
                this.logDir.mkdirs();
                Files.touch((File)logFile);
            }
            if (!this.wroteHeader && null != this.header) {
                Files.append((CharSequence)this.header, (File)logFile, (Charset)utf8);
                this.wroteHeader = true;
            }
            if (!this.entries.isEmpty()) {
                this.allEntries.addAll(this.entries);
                ImmutableList entriesToWrite = ImmutableList.copyOf(this.entries);
                this.entries = Lists.newArrayList();
                String content = Joiner.on((String)EOL).join((Iterable)entriesToWrite) + EOL;
                Files.append((CharSequence)content, (File)logFile, (Charset)utf8);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String generateHeader(Git git, GitFlowConfiguration config) {
        Package gitPkg = Git.class.getPackage();
        String gitVersion = gitPkg.getImplementationVersion();
        Package flowPkg = JGitFlow.class.getPackage();
        String flowVersion = flowPkg.getImplementationVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("# JGitFlow Log - " + this.startTime).append(P).append("  ## Configuration").append(EOL).append("    JGit Version: ").append(gitVersion).append(EOL).append("    JGitFlow Version: ").append(flowVersion).append(EOL).append("    Master name: ").append(config.getMaster()).append(EOL);
        try {
            sb.append("    Origin master exists = ").append(GitHelper.remoteBranchExists(git, config.getMaster(), this)).append(EOL);
        }
        catch (JGitFlowGitAPIException e) {
            // empty catch block
        }
        sb.append("    Develop name: ").append(config.getDevelop()).append(EOL);
        try {
            sb.append("    Origin develop exists = ").append(GitHelper.remoteBranchExists(git, config.getDevelop(), this)).append(EOL);
        }
        catch (JGitFlowGitAPIException e) {
            // empty catch block
        }
        for (String pname : config.getPrefixNames()) {
            sb.append("    ").append(pname).append(" name: ").append(config.getPrefixValue(pname)).append(EOL);
        }
        sb.append(HR);
        return sb.toString();
    }
}

