/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import java.io.File;
import org.eclipse.jgit.api.Git;

public class JGitFlowInfo {
    private final Git git;
    private final JGitFlowReporter reporter;
    private final String masterBranchName;
    private final String developBranchName;
    private final String featureBranchPrefix;
    private final String releaseBranchPrefix;
    private final String hotfixBranchPrefix;
    private final String supportBranchPrefix;
    private final String versionTagPrefix;

    public JGitFlowInfo(Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        this.git = git;
        this.reporter = reporter;
        this.developBranchName = gfConfig.getDevelop();
        this.featureBranchPrefix = gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.FEATURE.configKey());
        this.hotfixBranchPrefix = gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.HOTFIX.configKey());
        this.masterBranchName = gfConfig.getMaster();
        this.releaseBranchPrefix = gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.RELEASE.configKey());
        this.supportBranchPrefix = gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.SUPPORT.configKey());
        this.versionTagPrefix = gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.VERSIONTAG.configKey());
    }

    public Git git() {
        return this.git;
    }

    public File getProjectRoot() {
        return this.git.getRepository().getWorkTree();
    }

    public String getMasterBranchName() {
        return this.masterBranchName;
    }

    public String getDevelopBranchName() {
        return this.developBranchName;
    }

    public String getFeatureBranchPrefix() {
        return this.featureBranchPrefix;
    }

    public String getReleaseBranchPrefix() {
        return this.releaseBranchPrefix;
    }

    public String getHotfixBranchPrefix() {
        return this.hotfixBranchPrefix;
    }

    public String getSupportBranchPrefix() {
        return this.supportBranchPrefix;
    }

    public String getVersionTagPrefix() {
        return this.versionTagPrefix;
    }

    public JGitFlowReporter getReporter() {
        return this.reporter;
    }
}

