/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.commandLine;

import edu.internet2.middleware.grouperClient.api.GcLdapSearchAttribute;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GcLdapSearchAttributeConfig {
    private SearchAttributeResultType searchAttributeResultTypeEnum;
    private String operationName = null;
    private String outputTemplate = null;
    private Map<String, String> matchingAttributes = new LinkedHashMap<String, String>();
    private Set<String> returningAttributes = new LinkedHashSet<String>();
    private String ldapName;

    public String getOutputTemplate() {
        return this.outputTemplate;
    }

    public void setOutputTemplate(String outputTemplate1) {
        this.outputTemplate = outputTemplate1;
    }

    public void setSearchAttributeResultType(String string) {
        this.searchAttributeResultTypeEnum = SearchAttributeResultType.valueOfIgnoreCase(string);
    }

    public SearchAttributeResultType getSearchAttributeResultTypeEnum() {
        return this.searchAttributeResultTypeEnum;
    }

    public String toString() {
        return "operationName: " + this.operationName + ", resultType: " + (Object)((Object)this.searchAttributeResultTypeEnum);
    }

    public void setOperationName(String theOperationName) {
        this.operationName = theOperationName;
    }

    public void addMatchingAttribute(String attributeLabel, String ldapAttribute) {
        this.matchingAttributes.put(attributeLabel, ldapAttribute);
    }

    public void addReturningAttribute(String ldapAttribute) {
        this.returningAttributes.add(ldapAttribute);
    }

    public Map<String, String> getMatchingAttributes() {
        return this.matchingAttributes;
    }

    public Set<String> getReturningAttributes() {
        return this.returningAttributes;
    }

    public String getLdapName() {
        return this.ldapName;
    }

    public void setLdapName(String ldapName1) {
        this.ldapName = ldapName1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchAttributeResultType {
        STRING{

            public String processOutput(GcLdapSearchAttributeConfig gcLdapSearchAttributeConfig, GcLdapSearchAttribute gcLdapSearchAttribute, String outputTemplate) {
                String returningLdapAttribute = gcLdapSearchAttributeConfig.getReturningAttributes().iterator().next();
                String returningAttributeValue = GrouperClientUtils.defaultString(gcLdapSearchAttribute.retrieveResultAttributeString());
                LinkedHashMap<String, Object> substitutionVars = new LinkedHashMap<String, Object>();
                substitutionVars.put(returningLdapAttribute, returningAttributeValue);
                substitutionVars.put("grouperClientUtils", new GrouperClientUtils());
                this.addMatchingAttributesToSubstitutionVars(gcLdapSearchAttributeConfig, gcLdapSearchAttribute, substitutionVars);
                String result = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substitutionVars);
                return result + "\n";
            }
        }
        ,
        BOOLEAN{

            public String processOutput(GcLdapSearchAttributeConfig gcLdapSearchAttributeConfig, GcLdapSearchAttribute gcLdapSearchAttribute, String outputTemplate) {
                String ldapReturningAttribute = gcLdapSearchAttributeConfig.getReturningAttributes().iterator().next();
                String inputValue = gcLdapSearchAttribute.getMatchingAttribute(ldapReturningAttribute);
                String returningAttributeValue = GrouperClientUtils.defaultString(gcLdapSearchAttribute.retrieveResultAttributeString());
                boolean foundAttribute = GrouperClientUtils.equals(inputValue, returningAttributeValue);
                LinkedHashMap<String, Object> substitutionVars = new LinkedHashMap<String, Object>();
                substitutionVars.put(ldapReturningAttribute, returningAttributeValue);
                substitutionVars.put("resultBoolean", foundAttribute);
                substitutionVars.put("grouperClientUtils", new GrouperClientUtils());
                this.addMatchingAttributesToSubstitutionVars(gcLdapSearchAttributeConfig, gcLdapSearchAttribute, substitutionVars);
                String result = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substitutionVars);
                return result + "\n";
            }
        }
        ,
        STRING_LIST{

            public String processOutput(GcLdapSearchAttributeConfig gcLdapSearchAttributeConfig, GcLdapSearchAttribute gcLdapSearchAttribute, String outputTemplate) {
                List<String> returningAttributeValueList = GrouperClientUtils.nonNull(gcLdapSearchAttribute.retrieveResultAttributeStringList());
                StringBuilder result = new StringBuilder();
                LinkedHashMap<String, Object> substitutionVars = new LinkedHashMap<String, Object>();
                substitutionVars.put("grouperClientUtils", new GrouperClientUtils());
                this.addMatchingAttributesToSubstitutionVars(gcLdapSearchAttributeConfig, gcLdapSearchAttribute, substitutionVars);
                for (String returningAttributeValue : returningAttributeValueList) {
                    returningAttributeValue = GrouperClientUtils.defaultString(returningAttributeValue);
                    substitutionVars.put("resultString", returningAttributeValue);
                    String row = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substitutionVars);
                    result.append(row);
                }
                result.append("\n");
                return result.toString();
            }
        }
        ,
        STRING_LIST_LIST{

            public String processOutput(GcLdapSearchAttributeConfig gcLdapSearchAttributeConfig, GcLdapSearchAttribute gcLdapSearchAttribute, String outputTemplate) {
                throw new RuntimeException("Still need to implement");
            }
        };


        public static SearchAttributeResultType valueOfIgnoreCase(String string) {
            return GrouperClientUtils.enumValueOfIgnoreCase(SearchAttributeResultType.class, string, true);
        }

        public abstract String processOutput(GcLdapSearchAttributeConfig var1, GcLdapSearchAttribute var2, String var3);

        void addMatchingAttributesToSubstitutionVars(GcLdapSearchAttributeConfig gcLdapSearchAttributeConfig, GcLdapSearchAttribute gcLdapSearchAttribute, Map<String, Object> substitutionVars) {
            String ldapValue;
            String ldapName;
            for (String matchingAttributeLabel : gcLdapSearchAttributeConfig.getMatchingAttributes().keySet()) {
                ldapName = gcLdapSearchAttributeConfig.getMatchingAttributes().get(matchingAttributeLabel);
                ldapValue = gcLdapSearchAttribute.getMatchingAttribute(ldapName);
                substitutionVars.put(ldapName, ldapValue);
            }
            for (String matchingAttributeLabel : gcLdapSearchAttributeConfig.getMatchingAttributes().keySet()) {
                ldapName = gcLdapSearchAttributeConfig.getMatchingAttributes().get(matchingAttributeLabel);
                ldapValue = gcLdapSearchAttribute.getMatchingAttribute(ldapName);
                if (substitutionVars.containsKey(matchingAttributeLabel)) continue;
                substitutionVars.put(matchingAttributeLabel, ldapValue);
            }
        }
    }
}

