/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembershipsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetMembershipsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetMemberships {
    private String enabled;
    private Set<WsSubjectLookup> wsSubjectLookups = new LinkedHashSet<WsSubjectLookup>();
    private String stemScope = null;
    private WsStemLookup wsStemLookup = null;
    private String clientVersion;
    private Set<String> groupNames = new LinkedHashSet<String>();
    private Set<String> groupUuids = new LinkedHashSet<String>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsMemberFilter memberFilter;
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private String scope;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<String> sourceIds = null;
    private Set<String> membershipIds = null;

    public GcGetMemberships assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetMemberships assignWsStem(WsStemLookup theWsStemLookup) {
        this.wsStemLookup = theWsStemLookup;
        return this;
    }

    public GcGetMemberships addGroupName(String theGroupName) {
        this.groupNames.add(theGroupName);
        return this;
    }

    public GcGetMemberships addWsSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.wsSubjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcGetMemberships addGroupUuid(String theGroupUuid) {
        this.groupUuids.add(theGroupUuid);
        return this;
    }

    public GcGetMemberships addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetMemberships addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetMemberships assignMemberFilter(WsMemberFilter theMemberFilter) {
        this.memberFilter = theMemberFilter;
        return this;
    }

    public GcGetMemberships assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.groupNames) == 0 && GrouperClientUtils.length(this.groupUuids) == 0 && GrouperClientUtils.length(this.membershipIds) == 0 && GrouperClientUtils.length(this.wsSubjectLookups) == 0) {
            throw new RuntimeException("Group name or uuid or subject lookup or membership id is required: " + this);
        }
    }

    public GcGetMemberships assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcGetMemberships assignScope(String theScope) {
        this.scope = theScope;
        return this;
    }

    public GcGetMemberships addSourceId(String sourceId) {
        if (this.sourceIds == null) {
            this.sourceIds = new LinkedHashSet<String>();
        }
        this.sourceIds.add(sourceId);
        return this;
    }

    public GcGetMemberships addMembershipId(String sourceId) {
        if (this.membershipIds == null) {
            this.membershipIds = new LinkedHashSet<String>();
        }
        this.membershipIds.add(sourceId);
        return this;
    }

    public GcGetMemberships addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetMemberships assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetMemberships assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsGetMembershipsResults execute() {
        this.validate();
        WsGetMembershipsResults wsGetMembershipsResults = null;
        try {
            WsRestGetMembershipsRequest getMemberships = new WsRestGetMembershipsRequest();
            getMemberships.setActAsSubjectLookup(this.actAsSubject);
            getMemberships.setEnabled(this.enabled);
            getMemberships.setFieldName(this.fieldName);
            ArrayList<WsGroupLookup> groupLookups = new ArrayList<WsGroupLookup>();
            for (String groupName : this.groupNames) {
                groupLookups.add(new WsGroupLookup(groupName, null));
            }
            for (String groupUuid : this.groupUuids) {
                groupLookups.add(new WsGroupLookup(null, groupUuid));
            }
            if (GrouperClientUtils.length(groupLookups) > 0) {
                getMemberships.setWsGroupLookups(GrouperClientUtils.toArray(groupLookups, WsGroupLookup.class));
            }
            if (this.includeGroupDetail != null) {
                getMemberships.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                getMemberships.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            getMemberships.setMemberFilter(this.memberFilter == null ? null : this.memberFilter.name());
            if (GrouperClientUtils.length(this.membershipIds) > 0) {
                getMemberships.setMembershipIds(GrouperClientUtils.toArray(this.membershipIds, String.class));
            }
            if (this.params.size() > 0) {
                getMemberships.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            getMemberships.setScope(this.scope);
            if (GrouperClientUtils.length(this.sourceIds) > 0) {
                getMemberships.setSourceIds(GrouperClientUtils.toArray(this.sourceIds, String.class));
            }
            getMemberships.setStemScope(this.stemScope);
            if (this.subjectAttributeNames.size() > 0) {
                getMemberships.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            getMemberships.setWsStemLookup(this.wsStemLookup);
            if (GrouperClientUtils.length(this.wsSubjectLookups) > 0) {
                getMemberships.setWsSubjectLookups(GrouperClientUtils.toArray(this.wsSubjectLookups, WsSubjectLookup.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGetMembershipsResults = (WsGetMembershipsResults)grouperClientWs.executeService("memberships", getMemberships, "getMemberships", this.clientVersion);
            String resultMessage = wsGetMembershipsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetMembershipsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetMembershipsResults;
    }

    public GcGetMemberships assigStemScope(String theStemScope) {
        this.stemScope = theStemScope;
        return this;
    }

    public GcGetMemberships assignEnabled(String theEnabled) {
        this.enabled = theEnabled;
        return this;
    }
}

