/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.swing;

import de.huxhorn.sulky.formatting.HumanReadable;
import de.huxhorn.sulky.swing.GraphicsUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStatus
extends JComponent {
    private static final int GRADIENT_PIXELS = 3;
    private final Logger logger = LoggerFactory.getLogger(MemoryStatus.class);
    private Runtime runtime = Runtime.getRuntime();
    private MemoryInfo memoryInfo;
    private boolean paused = true;
    private boolean usingTotal;
    private boolean usingBinaryUnits;
    private BufferedImage offscreenImage;
    private static final Color USED_COLOR = new Color(20, 255, 20);
    private static final Color TOTAL_COLOR = new Color(255, 255, 20, 192);

    public MemoryStatus() {
        JLabel fontLabel = new JLabel("8,888.88 XXX");
        this.setFont(fontLabel.getFont());
        this.updateMemoryBar();
        this.addMouseListener(new GcMouseListener());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Font: {}", (Object)this.getFont());
        }
        Thread t = new Thread((Runnable)new PollRunnable(), "MemoryStatus-Poller");
        t.setDaemon(true);
        t.start();
    }

    public boolean isUsingBinaryUnits() {
        return this.usingBinaryUnits;
    }

    public void setUsingBinaryUnits(boolean usingBinaryUnits) {
        this.usingBinaryUnits = usingBinaryUnits;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.calculatePreferredSize();
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.calculatePreferredSize();
    }

    private void calculatePreferredSize() {
        JLabel label = new JLabel("8,888.88 XXX");
        label.setFont(this.getFont());
        label.setBorder(this.getBorder());
        Dimension size = label.getPreferredSize();
        size.height += 6;
        this.setPreferredSize(size);
    }

    public boolean isUsingTotal() {
        return this.usingTotal;
    }

    public void setUsingTotal(boolean usingTotal) {
        this.usingTotal = usingTotal;
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    protected void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        Dimension size = this.getSize();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        Rectangle paintingBounds = new Rectangle();
        paintingBounds.x = insets.left;
        paintingBounds.y = insets.top;
        paintingBounds.width = size.width - insets.left - insets.right;
        paintingBounds.height = size.height - insets.top - insets.bottom;
        if (this.offscreenImage == null || this.offscreenImage.getWidth() != paintingBounds.width || this.offscreenImage.getHeight() != paintingBounds.height) {
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
            if (paintingBounds.width > 0 && paintingBounds.height > 0) {
                GraphicsConfiguration gc = this.getGraphicsConfiguration();
                this.offscreenImage = gc.createCompatibleImage(paintingBounds.width, paintingBounds.height, 3);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Created offscreen-image...");
                }
            }
        }
        if (this.offscreenImage != null) {
            Graphics gr = this.offscreenImage.getGraphics();
            this.paintMemoryStatus(gr, paintingBounds);
            gr.dispose();
            g.drawImage(this.offscreenImage, paintingBounds.x, paintingBounds.y, null);
        }
    }

    private void paintMemoryStatus(Graphics g, Rectangle paintingBounds) {
        MemoryInfo info = this.memoryInfo;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, paintingBounds.width, paintingBounds.height);
        g2.setComposite(AlphaComposite.SrcOver);
        if (info != null) {
            double usedFraction;
            if (!this.usingTotal) {
                usedFraction = (double)info.getUsed() / (double)info.getMax();
                double totalFraction = (double)info.getTotal() / (double)info.getMax();
                int usedWidth = (int)((double)paintingBounds.width * usedFraction + 0.5);
                int totalWidth = (int)((double)paintingBounds.width * totalFraction + 0.5);
                this.drawBar(g2, 0, usedWidth, paintingBounds.height, USED_COLOR);
                this.drawBar(g2, usedWidth, totalWidth, paintingBounds.height, TOTAL_COLOR);
            } else {
                usedFraction = (double)info.getUsed() / (double)info.getTotal();
                int usedWidth = (int)((double)paintingBounds.width * usedFraction + 0.5);
                this.drawBar(g2, 0, usedWidth, paintingBounds.height, USED_COLOR);
            }
            String text = HumanReadable.getHumanReadableSize((long)info.getUsed(), (boolean)this.usingBinaryUnits, (boolean)true) + "B";
            FontRenderContext frc = g2.getFontRenderContext();
            TextLayout tl = new TextLayout(text, this.getFont(), frc);
            Shape s = tl.getOutline(null);
            Rectangle textBounds = s.getBounds();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("textBounds: {}", (Object)textBounds);
            }
            textBounds.x = textBounds.x * -1 + (paintingBounds.width - textBounds.width) / 2;
            textBounds.y = textBounds.y * -1 + (paintingBounds.height - textBounds.height) / 2;
            g.translate(textBounds.x, textBounds.y);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("corrected textBounds: {}", (Object)textBounds);
            }
            g.setColor(Color.WHITE);
            GraphicsUtilities.drawHighlight(g2, s, 3, 0.2f);
            g.setColor(Color.BLACK);
            g2.fill(s);
        }
    }

    private void drawBar(Graphics2D g2, int startX, int endX, int height, Color c) {
        int halfHeight = height / 2;
        int gradientHeight = Math.min(3, halfHeight);
        if (2 * gradientHeight < height) {
            g2.setColor(c);
            g2.fillRect(startX, gradientHeight, endX, height - 2 * gradientHeight);
        }
        Color brighter = c.brighter().brighter();
        Color darker = c.darker().darker();
        int colorAlpha = c.getAlpha();
        if (colorAlpha < 255) {
            brighter = new Color(brighter.getRed(), brighter.getGreen(), brighter.getBlue(), colorAlpha);
            darker = new Color(darker.getRed(), darker.getGreen(), darker.getBlue(), colorAlpha);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Corrected alpha-values.");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("original: {}\nbrighter: {}\ndarker: {}", new Object[]{c, brighter, darker});
        }
        GradientPaint p = new GradientPaint(0.0f, 0.0f, brighter, 0.0f, gradientHeight, c);
        g2.setPaint(p);
        g2.fillRect(startX, 0, endX, gradientHeight);
        p = new GradientPaint(0.0f, height - gradientHeight, c, 0.0f, height, darker);
        g2.setPaint(p);
        g2.fillRect(startX, height - gradientHeight, endX, gradientHeight);
    }

    public synchronized void setPaused(boolean paused) {
        this.paused = paused;
        this.notifyAll();
    }

    private void updateMemoryBar() {
        this.memoryInfo = new MemoryInfo(this.runtime);
        StringBuilder msg = new StringBuilder();
        msg.append("<html>");
        msg.append("Used memory: ");
        msg.append(HumanReadable.getHumanReadableSize((long)this.memoryInfo.getUsed(), (boolean)this.usingBinaryUnits, (boolean)false)).append("bytes");
        msg.append("<br>");
        msg.append("Total memory: ");
        msg.append(HumanReadable.getHumanReadableSize((long)this.memoryInfo.getTotal(), (boolean)this.usingBinaryUnits, (boolean)false)).append("bytes");
        msg.append("<br>");
        msg.append("Maximum memory: ");
        msg.append(HumanReadable.getHumanReadableSize((long)this.memoryInfo.getMax(), (boolean)this.usingBinaryUnits, (boolean)false)).append("bytes");
        msg.append("<br><br>");
        msg.append("Double-click to garbage-collect.");
        msg.append("</html>");
        this.setToolTipText(msg.toString());
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.setPaused(false);
    }

    public void removeNotify() {
        super.removeNotify();
        this.setPaused(true);
    }

    class GcMouseListener
    extends MouseAdapter {
        GcMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2 && evt.getButton() == 1) {
                System.gc();
                if (MemoryStatus.this.logger.isInfoEnabled()) {
                    MemoryStatus.this.logger.info("Executed garbage-collection.");
                }
                MemoryStatus.this.updateMemoryBar();
            }
        }
    }

    class UpdateRunnable
    implements Runnable {
        UpdateRunnable() {
        }

        public void run() {
            MemoryStatus.this.updateMemoryBar();
        }
    }

    class PollRunnable
    implements Runnable {
        Runnable updateRunnable;
        private long frequency = 5000L;

        public PollRunnable() {
            this.updateRunnable = new UpdateRunnable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                MemoryStatus memoryStatus = MemoryStatus.this;
                synchronized (memoryStatus) {
                    while (MemoryStatus.this.isPaused()) {
                        try {
                            MemoryStatus.this.wait();
                        }
                        catch (InterruptedException e) {
                            if (MemoryStatus.this.logger.isDebugEnabled()) {
                                MemoryStatus.this.logger.debug("Interrupted...", (Throwable)e);
                            }
                            return;
                        }
                    }
                }
                SwingUtilities.invokeLater(this.updateRunnable);
                try {
                    Thread.sleep(this.frequency);
                }
                catch (InterruptedException e) {
                    if (MemoryStatus.this.logger.isDebugEnabled()) {
                        MemoryStatus.this.logger.debug("Interrupted...", (Throwable)e);
                    }
                    return;
                }
            }
        }
    }

    private static class MemoryInfo {
        private long total;
        private long used;
        private long max;

        public MemoryInfo(Runtime runtime) {
            this.total = runtime.totalMemory();
            this.used = this.total - runtime.freeMemory();
            this.max = runtime.maxMemory();
        }

        public long getTotal() {
            return this.total;
        }

        public long getUsed() {
            return this.used;
        }

        public long getMax() {
            return this.max;
        }
    }
}

