/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.swing;

import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyStrokes {
    public static final String COMMAND_ALIAS = "command";
    public static final String COMMAND_MODIFIERS;
    public static final int COMMAND_KEYMASK;

    private KeyStrokes() {
    }

    public static String getModifiersString(int modifiers) {
        StringBuilder result = new StringBuilder();
        if ((modifiers & 1) != 0) {
            result.append("shift");
        }
        if ((modifiers & 2) != 0) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append("control");
        }
        if ((modifiers & 4) != 0) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append("meta");
        }
        if ((modifiers & 8) != 0) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append("alt");
        }
        if ((modifiers & 0x20) != 0) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append("altGraph");
        }
        return result.toString();
    }

    public static String preprocessAccelerator(String accel) {
        return accel.replaceAll(COMMAND_ALIAS, COMMAND_MODIFIERS);
    }

    public static KeyStroke resolveAcceleratorKeyStroke(String keyStroke) {
        Logger logger = LoggerFactory.getLogger(KeyStrokes.class);
        String preprocessedKeyStroke = KeyStrokes.preprocessAccelerator(keyStroke);
        KeyStroke result = KeyStroke.getKeyStroke(preprocessedKeyStroke);
        if (logger.isDebugEnabled()) {
            logger.debug("keyStroke {} resolved to {} resulted in {}.", new Object[]{keyStroke, preprocessedKeyStroke, result});
        }
        return result;
    }

    public static void registerCommand(JComponent component, Action action, String commandName) {
        Logger logger = LoggerFactory.getLogger(KeyStrokes.class);
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke != null) {
            if (logger.isDebugEnabled()) {
                KeyStrokes.logInputMaps(component, "BEFORE");
            }
            InputMap inputMap = component.getInputMap(2);
            ActionMap actionMap = component.getActionMap();
            inputMap.put(keyStroke, commandName);
            actionMap.put(commandName, action);
            inputMap = component.getInputMap(0);
            Object value = inputMap.get(keyStroke);
            if (value != null) {
                inputMap.put(keyStroke, commandName);
            }
            if ((value = (inputMap = component.getInputMap(1)).get(keyStroke)) != null) {
                inputMap.put(keyStroke, commandName);
            }
            if (logger.isDebugEnabled()) {
                KeyStrokes.logInputMaps(component, "AFTER");
            }
        }
    }

    private static void logInputMaps(JComponent component, String identifier) {
        Logger logger = LoggerFactory.getLogger(KeyStrokes.class);
        StringBuilder buffer = new StringBuilder();
        buffer.append("Component: ").append(component).append(":\n");
        buffer.append("\t").append(identifier).append(":\n");
        InputMap inputMap = component.getInputMap(0);
        KeyStrokes.appendInputMap(buffer, "WHEN_FOCUSED", inputMap);
        inputMap = component.getInputMap(1);
        KeyStrokes.appendInputMap(buffer, "WHEN_ANCESTOR_OF_FOCUSED_COMPONENT", inputMap);
        inputMap = component.getInputMap(2);
        KeyStrokes.appendInputMap(buffer, "WHEN_IN_FOCUSED_WINDOW", inputMap);
        logger.debug(buffer.toString());
    }

    private static void appendInputMap(StringBuilder buffer, String mapName, InputMap inputMap) {
        buffer.append("\tmapName: ").append(mapName).append("\n");
        KeyStroke[] keys = inputMap.allKeys();
        if (keys != null) {
            for (KeyStroke ks : keys) {
                buffer.append("\t\tKey  : ").append(ks).append("\n");
                buffer.append("\t\tValue: ").append(inputMap.get(ks)).append("\n");
                buffer.append("\t\t----------\n");
            }
        }
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        COMMAND_KEYMASK = toolkit.getMenuShortcutKeyMask();
        COMMAND_MODIFIERS = KeyStrokes.getModifiersString(COMMAND_KEYMASK);
    }
}

