/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.swing;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphicsUtilities {
    private GraphicsUtilities() {
    }

    private static GraphicsConfiguration getConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return GraphicsUtilities.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return GraphicsUtilities.getConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        return GraphicsUtilities.getConfiguration().createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage createOpaqueCompatibleImage(int width, int height) {
        return GraphicsUtilities.createCompatibleImage(width, height, 1);
    }

    public static BufferedImage createTranslucentCompatibleImage(int width, int height) {
        return GraphicsUtilities.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration gc = GraphicsUtilities.getConfiguration();
        if (image.getColorModel().equals(gc.getColorModel())) {
            return image;
        }
        return GraphicsUtilities.createCompatibleCopy(image);
    }

    public static BufferedImage createCompatibleCopy(BufferedImage image) {
        BufferedImage result = GraphicsUtilities.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g = result.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return result;
    }

    public static void drawHighlight(Graphics2D g2, Shape s, int size, float opacity) {
        Logger logger = LoggerFactory.getLogger(GraphicsUtilities.class);
        if (Float.compare(opacity, 0.0f) == 0) {
            return;
        }
        Composite c = g2.getComposite();
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                float distance = i * i + j * j;
                float alpha = opacity;
                if (Float.compare(distance, 0.0f) > 0) {
                    alpha = 1.0f / distance * opacity * (float)size;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Calculated alpha: {}", (Object)Float.valueOf(alpha));
                    }
                }
                if ((double)alpha > 1.0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Corrected alpha: {}", (Object)Float.valueOf(alpha));
                    }
                    alpha = 1.0f;
                }
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                g2.translate(i, j);
                g2.fill(s);
                g2.translate(-i, -j);
            }
        }
        g2.setComposite(c);
    }

    public static int[] getPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (w == 0 || h == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w * h];
        } else if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h, pixels);
        }
        return img.getRGB(x, y, w, h, pixels, 0, w);
    }

    public static void setPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (pixels == null || w == 0 || h == 0) {
            return;
        }
        if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h, pixels);
        } else {
            img.setRGB(x, y, w, h, pixels, 0, w);
        }
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return GraphicsUtilities.toCompatibleImage(image);
    }
}

