/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.renderer;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.table.Colors;
import de.huxhorn.lilith.swing.table.ColorsProvider;
import de.huxhorn.lilith.swing.table.renderer.LabelCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TimestampRenderer
implements TableCellRenderer {
    private LabelCellRenderer renderer = new LabelCellRenderer();
    private SimpleDateFormat timeFormat;

    public TimestampRenderer() {
        this.renderer.setHorizontalAlignment(0);
        this.renderer.setToolTipText(null);
        this.renderer.setIcon(null);
        this.timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        if (!isSelected) {
            boolean bl = isSelected = rowIndex == LabelCellRenderer.getSelectedRow(table);
        }
        if (!hasFocus && isSelected) {
            hasFocus = table.isFocusOwner();
        }
        this.renderer.setSelected(isSelected);
        this.renderer.setFocused(hasFocus);
        Color foreground = Color.BLACK;
        String text = "";
        if (value instanceof EventWrapper) {
            Long timestamp;
            LoggingEvent event;
            EventWrapper wrapper = (EventWrapper)value;
            Serializable eventObj = wrapper.getEvent();
            if (eventObj instanceof LoggingEvent) {
                event = (LoggingEvent)eventObj;
                timestamp = event.getTimeStamp();
                if (timestamp != null) {
                    text = this.timeFormat.format(new Date(timestamp));
                }
            } else if (eventObj instanceof AccessEvent && (timestamp = (event = (AccessEvent)eventObj).getTimeStamp()) != null) {
                text = this.timeFormat.format(new Date(timestamp));
            }
        }
        this.renderer.setText(text);
        boolean colorsInitialized = false;
        if (!hasFocus && !isSelected && table instanceof ColorsProvider && value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            ColorsProvider cp = (ColorsProvider)((Object)table);
            Colors colors = cp.resolveColors(wrapper, rowIndex, vColIndex);
            colorsInitialized = this.renderer.updateColors(colors);
        }
        if (!colorsInitialized) {
            this.renderer.setForeground(foreground);
        }
        this.renderer.correctRowHeight(table);
        return this.renderer;
    }
}

