/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.renderer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.lilith.swing.table.Colors;
import de.huxhorn.lilith.swing.table.ColorsProvider;
import de.huxhorn.lilith.swing.table.renderer.LabelCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class LevelRenderer
implements TableCellRenderer {
    private LabelCellRenderer renderer = new LabelCellRenderer();

    public LevelRenderer() {
        this.renderer.setHorizontalAlignment(0);
        this.renderer.setToolTipText(null);
        this.renderer.setIcon(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        EventWrapper wrapper;
        ColorsProvider cp;
        Colors colors;
        EventWrapper wrapper2;
        Serializable eventObj;
        if (!isSelected) {
            boolean bl = isSelected = rowIndex == LabelCellRenderer.getSelectedRow(table);
        }
        if (!hasFocus && isSelected) {
            hasFocus = table.isFocusOwner();
        }
        this.renderer.setSelected(isSelected);
        this.renderer.setFocused(hasFocus);
        String text = "";
        LoggingEvent.Level level = null;
        if (value instanceof EventWrapper && (eventObj = (wrapper2 = (EventWrapper)value).getEvent()) instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObj;
            level = event.getLevel();
            text = "" + level;
        }
        this.renderer.setText(text);
        boolean colorsInitialized = false;
        if (!hasFocus && !isSelected && table instanceof ColorsProvider && value instanceof EventWrapper && (colors = (cp = (ColorsProvider)((Object)table)).resolveColors(wrapper = (EventWrapper)value, rowIndex, vColIndex)).isSticky()) {
            colorsInitialized = this.renderer.updateColors(colors);
        }
        if (!colorsInitialized && level != null && table instanceof ColorsProvider) {
            ColorsProvider cp2 = (ColorsProvider)((Object)table);
            Colors colors2 = cp2.resolveColors(level, rowIndex, vColIndex);
            ColorScheme scheme = colors2.getColorScheme();
            this.renderer.setForeground(Color.BLACK);
            if (scheme != null) {
                Color c = scheme.getBackgroundColor();
                if (c != null) {
                    this.renderer.setBackground(c);
                }
                if ((c = scheme.getTextColor()) != null) {
                    this.renderer.setForeground(c);
                }
                c = scheme.getBorderColor();
                this.renderer.setBorderColor(c);
            }
        }
        this.renderer.correctRowHeight(table);
        return this.renderer;
    }
}

