/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ConditionalBorder
extends AbstractBorder {
    private static final long serialVersionUID = -2372658104457011019L;
    private int thickness;
    private int innerThickness;
    private Color borderColor;

    public ConditionalBorder(Color color) {
        this(color, 1, 0);
    }

    public ConditionalBorder(Color color, int thickness) {
        this(color, thickness, 0);
    }

    public ConditionalBorder(Color color, int thickness, int innerThickness) {
        this.setBorderColor(color);
        this.setThickness(thickness);
        this.setInnerThickness(innerThickness);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.borderColor != null && this.thickness > 0) {
            Color oldColor = g.getColor();
            g.setColor(this.borderColor);
            for (int i = 0; i < this.thickness; ++i) {
                g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
            }
            g.setColor(oldColor);
        }
    }

    public Insets getBorderInsets(Component c) {
        int actualThickness = this.thickness + this.innerThickness;
        return new Insets(actualThickness, actualThickness, actualThickness, actualThickness);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        int actualThickness;
        insets.left = actualThickness = this.thickness + this.innerThickness;
        insets.top = actualThickness;
        insets.right = actualThickness;
        insets.bottom = actualThickness;
        return insets;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getInnerThickness() {
        return this.innerThickness;
    }

    public void setInnerThickness(int innerThickness) {
        if (innerThickness < 0) {
            throw new IllegalArgumentException("innerThickness must not be negative!");
        }
        this.innerThickness = innerThickness;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        if (thickness < 0) {
            throw new IllegalArgumentException("thickness must not be negative!");
        }
        this.thickness = thickness;
    }

    public boolean isBorderOpaque() {
        return this.innerThickness == 0 && this.thickness > 0 && this.borderColor != null;
    }
}

