/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table;

import java.awt.Color;
import java.io.Serializable;

public final class ColorScheme
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5979344161643301761L;
    private Color textColor;
    private Color backgroundColor;
    private Color borderColor;

    public ColorScheme() {
        this(null, null, null);
    }

    public ColorScheme(Color textColor, Color backgroundColor, Color borderColor) {
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
    }

    public ColorScheme initDefaults() {
        this.textColor = ColorScheme.clone(Color.BLACK);
        this.backgroundColor = ColorScheme.clone(Color.WHITE);
        this.borderColor = ColorScheme.clone(Color.WHITE);
        return this;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public ColorScheme mergeWith(ColorScheme other) {
        if (!this.isAbsolute() && other != null) {
            if (this.textColor == null) {
                this.textColor = other.textColor;
            }
            if (this.backgroundColor == null) {
                this.backgroundColor = other.backgroundColor;
            }
            if (this.borderColor == null) {
                this.borderColor = other.borderColor;
            }
        }
        return this;
    }

    public boolean isAbsolute() {
        return this.textColor != null && this.backgroundColor != null && this.borderColor != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorScheme that = (ColorScheme)o;
        if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) {
            return false;
        }
        if (this.borderColor != null ? !this.borderColor.equals(that.borderColor) : that.borderColor != null) {
            return false;
        }
        return !(this.textColor != null ? !this.textColor.equals(that.textColor) : that.textColor != null);
    }

    public int hashCode() {
        int result = this.textColor != null ? this.textColor.hashCode() : 0;
        result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
        result = 31 * result + (this.borderColor != null ? this.borderColor.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ColorScheme[textColor=" + this.textColor + ", backgroundColor=" + this.backgroundColor + ", borderColor=" + this.borderColor + "]";
    }

    public ColorScheme clone() throws CloneNotSupportedException {
        ColorScheme result = (ColorScheme)super.clone();
        result.textColor = ColorScheme.clone(this.textColor);
        result.backgroundColor = ColorScheme.clone(this.backgroundColor);
        result.borderColor = ColorScheme.clone(this.borderColor);
        return result;
    }

    private static Color clone(Color c) {
        if (c != null) {
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        return null;
    }
}

